import matplotlib.pyplot as plt
import numpy as np
import pandas as pd
from matplotlib.ticker import MultipleLocator, FixedLocator
from figsquare import figsquare
import itertools
import string

## Import data
filename = '/Users/MaaskantE/Documents/PhD/Articles and outlines/PDMS_POSS_onalumina/Figures/Fig_x_heat_stage/PDMS_POSS_heat_stage.xlsx'

data = pd.read_excel(filename)

##plot all in seperate plots
plt.style.use('paper')

plt.close('all')

#find index where T=250
for i,value in enumerate(data['Temperature (°C)']):
    if value >= 250:
        index_left = i
        break

print(index_left)

#find index where T gets smaller than 250
for i,value in enumerate(data['Temperature (°C)'][index_left:]):
    if value < 250:
        index_right = i + index_left   
        break

print(index_right)

# add new column with the time starting from zero when isothermal step starts.0
data['Time_reset'] = data['Time (min.)']-data['Time (min.)'].iloc[index_left]

# thickness
plt.figure(1,figsize=(140/25.4,133.33/25.4))

ax1=plt.subplot(221)
plt.plot(data['Temperature (°C)'][:index_left],data['Relative thickness'][:index_left],'k')
plt.ylabel('Relative thickness (-)',labelpad=11)
plt.xlabel(u'Temperature (\u00B0C)')


ax2=plt.subplot(222,sharey=ax1)
plt.plot(data['Time_reset'][index_left:index_right],data['Relative thickness'][index_left:index_right],'k')
plt.setp(ax2.get_yticklabels(), visible=False)
plt.xlabel('Time (min)')

plt.ylim(0.5,1.1)
ax=plt.gca()
ax.yaxis.set_major_locator(MultipleLocator(0.2))
ax.yaxis.set_minor_locator(MultipleLocator(0.1))

#index plots
ax3=plt.subplot(223,sharex=ax1)
plt.plot(data['Temperature (°C)'][:index_left],data['Relative refractive index'][:index_left],'k')
plt.ylabel('Relative refractive index (-)',labelpad=4)
plt.xlabel(u'Temperature (\u00B0C)')
plt.xlim(25,250)
ax = plt.gca()
ax.xaxis.set_major_locator(FixedLocator([25,75,125,175,225]))
ax.xaxis.set_minor_locator(MultipleLocator(25))

ax4=plt.subplot(224,sharex=ax2,sharey=ax3)
plt.plot(data['Time_reset'][index_left:index_right],data['Relative refractive index'][index_left:index_right],'k')
plt.setp(ax4.get_yticklabels(), visible=False)
plt.xlabel('Time (min)')
plt.xlim(0,20)
ax = plt.gca()
ax.xaxis.set_major_locator(MultipleLocator(5))
ax.xaxis.set_minor_locator(MultipleLocator(2.5))

plt.ylim(0.95,1.05)
ax=plt.gca()
ax.yaxis.set_major_locator(MultipleLocator(0.05))
ax.yaxis.set_minor_locator(MultipleLocator(0.025))

#text and final layout
ax1.text(0.03, 0.91,'a', fontsize=12, transform = ax1.transAxes)
ax2.text(0.03, 0.91,'b', fontsize=12, transform = ax2.transAxes)
ax3.text(0.03, 0.91,'c', fontsize=12, transform = ax3.transAxes)
ax4.text(0.03, 0.91,'d', fontsize=12, transform = ax4.transAxes)
plt.tight_layout()
plt.subplots_adjust(wspace=0.07)
    

plt.savefig('PDMS_POSS_heatstage.pdf')