import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec
import numpy as np
import pandas as pd
from matplotlib.ticker import MultipleLocator, FixedLocator,NullLocator
from figsquare import figsquare
import itertools
import string

plt.style.use('paper')

##import data
filename = '/Users/MaaskantE/Documents/PhD/Characterization/TGA-MS/pdms poss/20150429 PDMS POSS pH 9_11 MID/ExpDat_20150506_PDMSPOSS_pH911_20K_1000C_N2_TG_TGAMSmerged.xls'

#headers = ['Time',	'Temperature',	'Mass',	'Diff_mass',	12,	14,	15,	16,	17,	18,	19,	20,	22,	28,	29,	30,	32,	35,	36,	37,	38,	39,	40,	41,	42,	43,	44,	50,	51,	52,	53,	55]

plt.close('all')

##
plt.figure(1,figsize=(90/25.4,100/25.4))
gs1 = gridspec.GridSpec(2, 1, height_ratios=[2.0,3.5])
gs1.update(bottom=0.11,top=0.98,hspace=0.05,right=0.93,left=0.2)

#make subplot and share axes where applicable
ax0 = plt.subplot(gs1[0])
ax2 = ax0.twinx()
ax1 = plt.subplot(gs1[1],sharex=ax0)
plt.yscale('log')

# no axis labels on shared axes
plt.setp(ax0.get_xticklabels(), visible=False)
plt.setp(ax2.get_yticklabels(), visible=False)

#limits and tick position
ax1.set_xlim([0,1000])
ax1.set_ylim([1E-13,2.1E-11])
ax0.set_ylim([0,105])
ax0.yaxis.set_major_locator(FixedLocator([0,50,100]))
ax0.yaxis.set_minor_locator(FixedLocator([25,75]))
ax2.yaxis.set_major_locator(NullLocator())
#ax0.yaxis.set_minor_locator(MultipleLocator(12.5))
ax1.xaxis.set_major_locator(FixedLocator([0,200,400,600,800,1000]))
ax1.xaxis.set_minor_locator(FixedLocator([100,300,500,700,900]))

#tick params
ax1.tick_params('y',labelsize=9)

#labels
ax0.set_ylabel('Mass (%)',labelpad=11)
ax1.set_xlabel(u'Temperature (\u00B0C)') 
ax1.set_ylabel('Ion current (A)')
ax2.set_ylabel('dm/dT (%/\u00B0C)') 

##annotation
ax1.text(0.20, 0.85,'$\mathregular{H_2O}$', color='b',fontsize=10, transform = ax1.transAxes)
ax1.text(0.55, 0.86,'$\mathregular{CH_4}$', color='g',fontsize=10, transform = ax1.transAxes)
ax1.text(0.60, 0.53,'NO', color='#ff0066',fontsize=10, transform = ax1.transAxes)
ax1.text(0.30, 0.31,'$\mathregular{CO_2}$', color='k',fontsize=10, transform = ax1.transAxes)
ax1.text(0.50, 0.08,'$\mathregular{CH_3CH_2CH_2}$', color='#ff9933',fontsize=10, transform = ax1.transAxes)


## plot the data
df = pd.read_excel(filename)  

ax0.plot(df['Temperature (?C)'], df['Mass (%)'],'k',lw=1)
ax2.plot(df['Temperature (?C)'], df['Differential mass (%/min)'],'k',ls='--',lw=1)

ax1.plot(df['Temperature (?C)'], df[18.09],'b',ls=':',lw=1.2)
ax1.plot(df['Temperature (?C)'], df[43.97],'k',ls=':',lw=1.2)
ax1.plot(df['Temperature (?C)'], df[30.05],'#ff0066',ls=':',lw=1.2)
ax1.plot(df['Temperature (?C)'], df[15.09],'g',ls=':',lw=1.2)   
ax1.plot(df['Temperature (?C)'], df[42.97],'#ff9933',ls=':',lw=1.2)    
      
#plt.tight_layout()
plt.savefig('/Users/MaaskantE/Documents/PhD/Articles and outlines/PDMS_POSS_onalumina/Figures/Fig_x_TGA/TGA_PDMS_POSS_N2.pdf')