import matplotlib.pyplot as plt
import numpy as np
import pandas as pd
from matplotlib.ticker import MultipleLocator
import itertools
import string
#from figsquare import figsquare

## Import data
filename_EtOH = 'PDMS-POSS Ethanol.xlsx'
filename_EtOAc = 'PDMS-POSS Ethyl acetate swelling.xlsx'
filename_hexane = 'PDMS-POSS hexane swelling.xlsx'

headers = ['Time', 'Corrected_time', 'raar','appact', 'Time@1', 'thickness', 'index', 'absorbance', 'swell deg', 'norm index']

filenames = [filename_hexane, filename_EtOAc, filename_EtOH]
solvent = ['n-hexane', 'ethyl acetate', 'ethanol']

plt.style.use('paper')

##import and plot as separate plots
# 
# plt.style.use('paper')
# 
# plt.close('all')
# color_a = itertools.cycle(('0.15', '0.3', '0.5'))
# color_b = itertools.cycle(('0.15', '0.3', '0.5'))
# 
# j=1
# 
# for i, filename in enumerate(filenames):
#     tabs = pd.read_excel(filename,sheetname=['1','2','3'], header=0, names=headers, skiprows=3)    
#     
#     plt.figure(j,figsize=(160/25.4,80/25.4))
#     
#     for tab_name, df in sorted(tabs.items()):
#         df_leftfigure = df[df['appact']<0.999]
#         
#         ax1=plt.subplot(121)
#         plt.plot(df_leftfigure['appact'],df_leftfigure['swell deg'],next(color_a))
#         plt.xlim(0,1)
#         ax = plt.gca()
#         ax.xaxis.set_major_locator(MultipleLocator(0.5))
#         ax.xaxis.set_minor_locator(MultipleLocator(0.25))
#         plt.ylabel('Swelling degree (%)')
#         plt.xlabel('Apparent activity (-)')
#         ax2=plt.subplot(122,sharey=ax1)
#         plt.plot(df['Time@1'],df['swell deg'],next(color_b))
#         plt.setp(ax2.get_yticklabels(), visible=False)
#         plt.xlim(0,200)
#         ax = plt.gca()
#         ax.xaxis.set_major_locator(MultipleLocator(50))
#         ax.xaxis.set_minor_locator(MultipleLocator(25))
#         plt.xlabel('Time at apparent activity 1 (min)')
#         plt.ylim(0,12)
#         ax=plt.gca()
#         ax.yaxis.set_major_locator(MultipleLocator(4))
#         ax.yaxis.set_minor_locator(MultipleLocator(2))
#     ax1.text(0.03, 0.91,'a', fontsize=12, transform = ax1.transAxes)
#     ax2.text(0.03, 0.91,'b', fontsize=12, transform = ax2.transAxes)
#     plt.tight_layout()
#     plt.subplots_adjust(wspace=0.07)
#         
#     j=j+1
    

##Adjust y scale for plots    
plt.figure(1)#EtOH
plt.text(160,3.2,'n=1.53')
plt.text(160,10.5,'n=1.48')
plt.text(160,7.9,'n=1.50')
plt.savefig('PDMS_POSS_EtOH.pdf')

plt.figure(2)#EtOAc
plt.text(160,2.4,'n=1.53')
plt.text(160,7.2,'n=1.50')
plt.text(160,5.3,'n=1.51')
plt.savefig('PDMS_POSS_EtOAc.pdf')

plt.figure(3)#hexane
plt.text(160,6.6,'n=1.51')
plt.text(160,3.5,'n=1.49')
plt.text(160,5.0,'n=1.51')
plt.savefig('PDMS_POSS_hexane.pdf')

## one big figure

plt.style.use('paper')

plt.close('all')
# color_a = itertools.cycle(('0.15', '0.3', '0.5'))
# color_b = itertools.cycle(('0.15', '0.3', '0.5'))

plt.figure(4,figsize=(130/25.4,180/25.4))

for i, filename in enumerate(filenames):
    tabs = pd.read_excel(filename,sheetname=['1','2','3'], header=0, names=headers, skiprows=3)    
    color_l = itertools.cycle(('0.15', '0.3', '0.5'))
    color_r = itertools.cycle(('0.15', '0.3', '0.5'))
    for tab_name, df in sorted(tabs.items()):
        df_leftfigure = df[df['appact']<0.999]
        
        ax1=plt.subplot(321 + i*2)
        plt.plot(df_leftfigure['appact'],df_leftfigure['swell deg'],next(color_l),marker='s',markersize=6,markerfacecolor='w',linestyle='--')
        plt.xlim(0,1)
        ax = plt.gca()
        ax.xaxis.set_major_locator(MultipleLocator(0.5))
        ax.xaxis.set_minor_locator(MultipleLocator(0.25))
        plt.ylabel('Swelling degree (%)')
        plt.xlabel('Apparent activity (-)')
        ax2=plt.subplot(322+i*2,sharey=ax1)
        plt.plot(df['Time@1'],df['swell deg'],next(color_r))
        plt.setp(ax2.get_yticklabels(), visible=False)
        plt.xlim(0,200)
        ax = plt.gca()
        ax.xaxis.set_major_locator(MultipleLocator(50))
        ax.xaxis.set_minor_locator(MultipleLocator(25))
        plt.xlabel('Time (min)')
        plt.ylim(0,12)
        ax=plt.gca()
        ax.yaxis.set_major_locator(MultipleLocator(4))
        ax.yaxis.set_minor_locator(MultipleLocator(2))
    
    if i==0:
        plt.text(150,6.6,'n=1.49',fontsize=10)
        plt.text(150,3.3,'n=1.51',fontsize=10)
        plt.text(150,5.0,'n=1.51',fontsize=10)
    
    if i==1:
        plt.text(150,2.15,'n=1.53',fontsize=10)
        plt.text(150,7.2,'n=1.50',fontsize=10)
        plt.text(150,5.3,'n=1.51',fontsize=10)
    
    if i==2:
        plt.text(150,3.1,'n=1.53',fontsize=10)
        plt.text(150,10.3,'n=1.48',fontsize=10)
        plt.text(150,7.65,'n=1.50',fontsize=10)
        
    print(i, string.ascii_lowercase[i*2])
    ax1.text(0.03, 0.90,string.ascii_lowercase[i*2], fontsize=12, transform = ax1.transAxes)
    ax2.text(0.03, 0.90,string.ascii_lowercase[1+i*2], fontsize=12, transform = ax2.transAxes)
    ax1.text(0.95, 0.90,solvent[i], fontsize=10, ha='right',transform = ax1.transAxes)
    plt.tight_layout()
    plt.subplots_adjust(wspace=0.07)

plt.savefig('PDMS_POSS_allinone.pdf')

##
