import matplotlib.pyplot as plt
import numpy as np
import pandas as pd
from matplotlib.ticker import MultipleLocator
from figsquare import figsquare
import itertools
import string

## Import data
filename = '/Users/MaaskantE/Documents/PhD/Articles and outlines/PDMS_POSS_onalumina/Experimental/PDMS swelling.xlsx'

headers = ['Time', 'Corrected_time', 'appact', 'Time@1', 'thickness', 'index', 'absorbance', 'swell deg', 'norm index']

tabs = pd.read_excel(filename,sheetname=['EtOH','EtOAc','hexane'], header=0, names=headers, skiprows=3)


df_EtOH=tabs['EtOH']
df_EtOAc=tabs['EtOAc']
df_hexane=tabs['hexane']

##plot all in seperate plots
plt.style.use('paper')

plt.close('all')
# i=1
# for tab_name, df in sorted(tabs.items()):
#     df_leftfigure = df[df['appact']<0.999]
#     
#     plt.figure(i,figsize=(160/25.4,80/25.4))
#     ax1=plt.subplot(121)
#     plt.plot(df_leftfigure['appact'],df_leftfigure['swell deg'],color='0.15')
#     plt.xlim(0,1)
#     ax = plt.gca()
#     ax.xaxis.set_major_locator(MultipleLocator(0.5))
#     ax.xaxis.set_minor_locator(MultipleLocator(0.25))
#     plt.ylabel('Swelling degree (%)')
#     plt.xlabel('Apparent activity (-)')
#     ax2=plt.subplot(122,sharey=ax1)
#     plt.plot(df['Time@1'],df['swell deg'],color='0.15')
#     plt.setp(ax2.get_yticklabels(), visible=False)
#     plt.xlim(0,200)
#     ax = plt.gca()
#     ax.xaxis.set_major_locator(MultipleLocator(50))
#     ax.xaxis.set_minor_locator(MultipleLocator(25))
#     plt.xlabel('Time at apparent activity 1 (min)')
#     
#     ax1.text(0.03, 0.91,'a', fontsize=12, transform = ax1.transAxes)
#     ax2.text(0.03, 0.91,'b', fontsize=12, transform = ax2.transAxes)
#     plt.tight_layout()
#     plt.subplots_adjust(wspace=0.07)
#     
#     i=i+1
#     
# 
# ##Adjust y scale for plots    
# plt.figure(1)#EtOAc
# plt.ylim(0,30)
# ax=plt.gca()
# ax.yaxis.set_major_locator(MultipleLocator(10))
# ax.yaxis.set_minor_locator(MultipleLocator(5))
# plt.savefig('PDMS_EtOAc.pdf')
# 
# plt.figure(2)#EtOH
# plt.ylim(0,4)
# ax=plt.gca()
# ax.yaxis.set_major_locator(MultipleLocator(1))
# ax.yaxis.set_minor_locator(MultipleLocator(0.5))
# plt.savefig('PDMS_EtOH.pdf')
# 
# plt.figure(3)#hexane
# plt.ylim(0,100)
# ax=plt.gca()
# ax.yaxis.set_major_locator(MultipleLocator(25))
# ax.yaxis.set_minor_locator(MultipleLocator(12.5))
# plt.savefig('PDMS_hexane.pdf')

##plot all in one plot
color_a = itertools.cycle(('0.15', '0.3', '0.5'))
color_b = itertools.cycle(('0.15', '0.3', '0.5'))

for tab_name, df in sorted(tabs.items()):
    df_leftfigure = df[df['appact']<0.999]
    
    plt.figure(4,figsize=(140/25.4,70/25.4))
    ax1=plt.subplot(121)
    plt.plot(df_leftfigure['appact'],df_leftfigure['swell deg'],next(color_a),marker='s',markersize=6,markerfacecolor='w',linestyle='--')
    plt.xlim(0,1)
    ax = plt.gca()
    ax.xaxis.set_major_locator(MultipleLocator(0.5))
    ax.xaxis.set_minor_locator(MultipleLocator(0.25))
    plt.ylabel('Swelling degree (%)')
    plt.xlabel('Apparent activity (-)')
    ax2=plt.subplot(122,sharey=ax1)
    plt.plot(df['Time@1'],df['swell deg'],next(color_b))
    plt.setp(ax2.get_yticklabels(), visible=False)
    plt.xlim(0,200)
    ax = plt.gca()
    ax.xaxis.set_major_locator(MultipleLocator(50))
    ax.xaxis.set_minor_locator(MultipleLocator(25))
    plt.xlabel('Time (min)')
    
ax1.text(0.03, 0.91,'a', fontsize=12, transform = ax1.transAxes)
ax2.text(0.03, 0.91,'b', fontsize=12, transform = ax2.transAxes)
plt.tight_layout()
plt.subplots_adjust(wspace=0.07)
    
plt.ylim(0,100)
plt.text(43,73,'n-hexane',fontsize=10)
plt.text(115,29,'ethyl acetate',fontsize=10)
plt.text(148,8.0,'ethanol',fontsize=10)
ax=plt.gca()
ax.yaxis.set_major_locator(MultipleLocator(25))
ax.yaxis.set_minor_locator(MultipleLocator(12.5))
plt.savefig('PDMS_allinone_2.pdf')