import matplotlib.pyplot as plt
import pandas as pd
import numpy as np
from PySide import QtGui
import scipy.ndimage
import os
from matplotlib.ticker import MultipleLocator
from figsquare import figsquare
import itertools

plt.style.use('paper')

# plt.rcParams['axes.unicode_minus'] = False
# 
# os.environ['PATH'] += ':/Library/TeX/texbin'
# plt.rcParams['text.usetex'] = True
# plt.rcParams['mathtext.default'] = 'regular'
# plt.rcParams['text.latex.preamble'] = [
# r'''
# \usepackage[version=3]{mhchem}
# \setlength{\parskip}{\medskipamount}
# \setlength{\parindent}{0pt}
# ''']


#Import data
filename_1 = '/Users/MaaskantE/Documents/PhD/Characterization/FTIR/2015/PDMS POSS/PDMS_POSS_amic_acid_pH9_11.txt'
filename_2 = '/Users/MaaskantE/Documents/PhD/Characterization/FTIR/2015/PDMS POSS/PDMS_POSS_imid_230C_3h_pH9_11.txt'

headers = ['Wavenumber','Absorbance']

filenames = [filename_1, filename_2]

## fit the data for figure 1
output = pd.DataFrame()
plt.close('all')
plt.figure(1,figsize=(80/25.4,90/25.4))


for i, filename in enumerate(filenames, 0):
    data = pd.read_csv(filename, sep='\t', header=0, names=headers, skiprows=1)
    max = data['Absorbance'].max()
    min = data['Absorbance'].min()
    
    data['Normalized']= (data['Absorbance']-min)/(max-min)-i+1
    
    if i==0:
        #plt.axvline(x=1547, ymin=0, ymax=1, linestyle='--', color='0.9')
        #plt.axvline(x=1638, ymin=0, ymax=1, linestyle='--', color='0.9')
        plt.text(1970,1.9,'amic acid')
        # plt.text(1340,1.5,'\ce{Si-CH3}',fontsize=8)
        # plt.text(1090,1.95,'\ce{Si-OH}',fontsize=8)
        # plt.text(760,2.0,'\ce{Si-CH3}',fontsize=8)
        # plt.text(1590,1.4,'\ce{N-H}',fontsize=8)
        # plt.text(1700,1.55,'\ce{C=O}',fontsize=8)
        
    else:
        #plt.axvline(x=1701, ymin=0, ymax=1, linestyle='--', color='0.9')
        plt.text(1970,0.8,'imide')
        # plt.text(1770,0.4,'\ce{C=O}',fontsize=8)
        
    
    plt.plot(data['Wavenumber'],data['Normalized'], 'k')
 
    
plt.figure(1)
plt.xlim(2000,400)
plt.ylim(-0.02,2.1)
plt.ylabel('Absorbance (a.u.)')
ax1 = plt.gca()
ax1.xaxis.set_major_locator(MultipleLocator(400))
#ax.xaxis.set_minor_locator(MultipleLocator(50))
plt.xlabel(r'Wavenumber (cm$^{\endash1}$)')
plt.yticks([])

plt.axvspan(1714, 1686, alpha=0.5, color='0.8')
plt.axvspan(1657, 1624, alpha=0.5, color='0.8')
plt.axvspan(1572, 1512, alpha=0.5, color='0.8')
plt.axvspan(1267, 1245, alpha=0.5, color='0.8')
plt.axvspan(1114, 980, alpha=0.5, color='0.8')
plt.axvspan(810, 767, alpha=0.5, color='0.8')

ax2 = ax1.twiny()
ax2.set_xlim(ax1.get_xlim())
ax2.set_xticks([1700,1659,1542,1256,1047,788])
ax2.set_xticklabels(['C=O', '','N-H', r'Si-CH$_3$', 'Si-OH',r'Si-CH$_3$'], fontsize=8, ha='center', rotation=45)
#ax2.set_xticklabels(['C=O', '','N-H', r'Si-CH\textsubscript{3}', 'Si-OH',r'Si-CH\textsubscript{3}'], fontsize=8, ha='center', rotation=45)

plt.tight_layout()
    
plt.savefig('/Users/MaaskantE/Documents/PhD/Articles and outlines/PDMS_POSS_onalumina/Figures/Fig_FTIR_amic_acid_imide/PDMS_POSS_FTIR.pdf')



