import csv
import statistics
import numpy as np


def csv_to_dict(filename):
    data_dict = {}
    with open(filename, mode="r", newline="", encoding="utf-8") as file:
        reader = csv.reader(file)
        headers = next(reader)
        for row in reader:
            uid = row[0]
            values = list(map(int, row[1:]))
            data_dict[uid] = values
    return data_dict

llm_data = csv_to_dict("data_raw_llm.csv")
rbs_data = csv_to_dict("data_raw_rbs.csv")

def split_into_constructs(data):
    data_split = {}
    overalls = []
    for uid, v in data.items():
        overall = round(statistics.mean(v[0:11] + [-v[11]] + v[12:16] + [-v[16]] + [-v[17]] + v[18:21] + [-v[21]] + v[22:24]),3)
        overalls.append(v[0:11] + [-v[11]] + v[12:16] + [-v[16]] + [-v[17]] + v[18:21] + [-v[21]] + v[22:24])
        AllBeliev = round(statistics.mean(v[24:30] + [v[1]] + [v[3]]), 3)
        believability1 = round(statistics.mean(v[24:28] + [v[1]]),3)
        believability2 = round(statistics.mean(v[28:30] + [v[3]]),3)
        engagement = round(statistics.mean([v[12]] + v[30:32]),3)
        attitude = round(statistics.mean([v[18]] + [v[32]] + [-v[33]]),3)
        data_split[uid] = [overall, AllBeliev, believability1, believability2, engagement, attitude]
    averaged_overalls = averaged_array = np.array(overalls).mean(axis=0)
    print(str(np.round(averaged_overalls, 2)))
    return data_split

llm_split = split_into_constructs(llm_data)
rbs_split = split_into_constructs(rbs_data)

def dict_to_csv(dictionary, filename):
    with open(filename, mode="w", newline="", encoding="utf-8") as file:
        writer = csv.writer(file)

        max_values = max(len(v) for v in dictionary.values())

        header = ["PROLIFIC_PID", "OVERALL", "AllBeliev", "BELIEVABILITY1", "BELIEVABILITY2", "ENGAGEMENT", "ATTITUDE"]
        writer.writerow(header)

        # Write data rows
        for uid, values in dictionary.items():
            writer.writerow([uid] + values)

dict_to_csv(llm_split, "constructs_averaged_llm.csv")
dict_to_csv(rbs_split, "constructs_averaged_rbs.csv")