% =========================================================================
% This code is used to read data from the droplet trajectory h5 files
% in the article 'Towards realistic simulations of human cough: Effect of 
% droplet emission duration and spread angle.  International Journal of 
% Multiphase Flow, 103883'.
% =========================================================================


Temp_drop = 34; Temp_ambient = 20;  % temperature of exhaled and ambient air, in Celsius 

delta_t = 0.2e-3; % [s] time step (DNS angle 0)
% delta_t = 0.172e-3; % [s] time step (DNS angle 45)

l = 2.3e-2;    % [m] length scale (mouth diameter)
stride_t = 1;  % stride in time
Nt_DNS = 4001; % number of time steps
stride_d = 2;  % stride in droplet num
N_drop = 5000; % number of droplets

h5name = 'cone_0deg_parthist.h5';

% initial droplet diameter
pp_diam_ini = h5read(h5name,'/pp_diam',[2,1],[1,floor((N_drop-1)/stride_d)],[1,stride_d]);
pp_diam_ini = pp_diam_ini*l;

start = [1 1];
count = [floor((Nt_DNS-1)/stride_t) floor((N_drop-1)/stride_d)];  % [num of time steps, num of droplets]
stride = [stride_t stride_d];

% droplet diameter
pp_diam = h5read(h5name,'/pp_diam',start,count,stride);
pp_diam = pp_diam*l;

% droplet temperature
pp_temp = h5read(h5name,'/pp_temp',start,count,stride);
pp_temp = pp_temp*(Temp_drop-Temp_ambient)+Temp_ambient;

% air temperature at droplet position
fluid_temp = h5read(h5name,'/fluid_dens',start,count,stride);
fluid_temp = fluid_temp*(Temp_drop-Temp_ambient)+Temp_ambient;

% vapour mass fraction at droplet position
fluid_sal = h5read(h5name,'/fluid_sal',start,count,stride);

% dd2/dt
pp_dtwo_change = h5read(h5name,'/pp_dtwo_change',start,count,stride);
pp_dtwo_change = pp_dtwo_change*l^2/delta_t;

% saturated vapour mass fraction at droplet position, Antoine's equation
fluid_sal_sat = 1.e5*exp(11.6834-3816.44./(226.87+fluid_temp))/461.5./(fluid_temp+273.15)/1.204;

% relative humidity
RH = fluid_sal./fluid_sal_sat;

% droplet coordinate [spanwise, wall normal, streamwise]
ppart_pos_x = h5read(h5name,'/ppart_pos_x',start,count,stride)*l;
ppart_pos_y = h5read(h5name,'/ppart_pos_y',start,count,stride)*l;
ppart_pos_z = h5read(h5name,'/ppart_pos_z',start,count,stride)*l;

% flag of droplet status
pp_isdead = h5read(h5name,'/pp_isdead',start,count,stride);
pp_isstart = h5read(h5name,'/pp_isstart',start,count,stride);