# Reasons to continue or stop using a virtual coach for quitting smoking and increasing physical activity: A mixed-methods analysis.

This repository contains the results and the code related to the analysis conducted to find out what the reasons are to continue or stop using a virtual coach for quitting smoking and increasing physical activity. Go to https://doi.org/10.4121/19934783.v1 to have a look at the original data used for this analysis. For a comprehensive discussion of the results, please look at the thesis which can be found under the references on the 4tu page. 

## Contents of the repository
```
AnalysisData
│
└───Code
│   │   cohensKappa.py
│   │   correlation.py
│
└───Data
│   │   Coding of the data.xlsx
│   │	Double coding of the data.xlsx
│   │   Final coding of the data.xlsx
│
│	README.md
│
└───Results
│   │   Codes plus themes.pdf
│   │   Cohen's kappa results.xlsx
│   │   Cronbach's alpha results.xlsx
│   │	Quantitative analysis results.xlsx
```

| File/Folder name                 | Content                                                                                   |
| -------------------------------- | ----------------------------------------------------------------------------------------- |
| cohensKappa.py                   | Python file containing the code to calculate the cohen's kappa of codes.                  |
| correlation.py                   | Python file containing the code to calculate the Pearson correlation coefficient.         |
| Coding of the data.xlsx          | xlsx file containing three rounds of coding of the free-text responses given by participants.|
| Double coding of the data.xlsx   | xlsx file containing the double coding of the free-text responses given by participants.  |
| Final coding of the data.xlsx    | xlsx file containing the final coding of the free-text responses given by participants (this file was used for the analysis).                                  |
| README.md                        | Current file that you are reading.                                                        |
| Codes plus themes.pdf            | Pdf file containing the image of the final coding scheme and the image of the three themes found together with their corresponding codes.                                           |
| Cohen's kappa results.xlsx       | xlsx file containing the cohen's kappa values for the codes used in the second coding round and by the double coder.                                   |
| Cronbach's alpha results.xlsx         | xlsx file containing the cronbach's alpha values for a subgroup of user characteristics that can be found in the original data set.                                           |
| Quantitative analysis results.xlsx | xlsx file containing the correlations and quotes collected after the quantitative analysis.                                 |

## Running the cohensKappa.py 
1. Add two csv files containing zero-one encoding for the codes (e.g. Final coding of the data.xlsx withouth the three theme columns).
2. Run the file. 
3. Results are printed in the terminal. 

## Running the correlation.py 
1. Add two csv files containing only numerical data (e.g. the column theme1 without the first line from the Final coding of the data.xlsx file and a column from the original data withouth the first line).
2. Run the file. 
3. Results are printed in the terminal. 

## Tables/figures and corresponding files

| File Name                | Corresponding figure/table in the paper                                                  |
|--------------------------|------------------------------------------------------------------------------------------|
| Cronbach's alpha results.xlsx | Table 1: Cronbach’s alpha score for the psychometric tests.                         |
| Quantitative analysis results.xlsx | Table 2: Codes depicted with the percentage that the code was used in the responses covered by the theme ’Authenticity of the interaction’. |
| Quantitative analysis results.xlsx | Table 3: Pearson correlation coefficients \(R) and the corresponding significance value (P) between the theme ’authenticity of the interaction’ and a subgroup of user characteristics. |
| Quantitative analysis results.xlsx | Table 4: Codes depicted with the percentage that the code was used in the responses covered by the theme ’Caring character of the virtual coach’.                                                           |
| Quantitative analysis results.xlsx  | Table 5: Pearson correlation coefficients \(R) and the corresponding significance value (P) between the theme ’Caring character of the virtual coach’ and a subgroup of user characteristics.   |
| Quantitative analysis results.xlsx | Table 6: Codes depicted with the percentage that the code was used in the responses covered by the theme ’Content of the interactions’.                        |
| Quantitative analysis results.xlsx | Table 7: Pearson correlation coefficients \(R) and the corresponding significance value (P) between the theme ’Content of the interactions’ and a subgroup of user characteristics. |
| Quantitative analysis results.xlsx | Table 8: Pearson correlation coefficients \(R) and the corresponding significance value (P) between the ratings given by the participants and a subgroup of user characteristics. |

