from numpy import genfromtxt
from scipy.stats import mstats

if __name__ == '__main__':

    # Add the name of the first csv file that contains the numerical data.
    file = open('correlationFile1.csv')
    data1 = genfromtxt(file, delimiter=';')

    # Add the name of the second csv file that contains the numerical data.
    file = open('correlationFile2.csv')
    data2 = genfromtxt(file, delimiter=';')

    # Uses the mstats pearson correlation coefficient function to receive the
    # correlation coefficient and P-value.
    result = mstats.pearsonr(data1, data2)

    # Prints the correlation coefficient and P-value in the terminal.
    print("r: ")
    print(result[0])
    print("p-value: ")
    print(result[1])








