clc
clear all
close all

% Load data
load('P1.mat')
patient{1}.Fx = -3:4;
patient{1}.v = (output_table.velocity(1:2:16) + output_table.velocity(2:2:16)) / 2;
patient{1}.vBack = mean(output_table.velocity(23:24));
patient{1}.vFront = mean(output_table.velocity(21:22));
patient{1}.vMid = mean(output_table.velocity(25:26));

load('P2.mat')
patient{2}.Fx = -3:4;
patient{2}.v = (output_table.velocity(1:2:16) + output_table.velocity(2:2:16)) / 2;
patient{2}.vBack = mean(output_table.velocity(19:20));
patient{2}.vFront = mean(output_table.velocity(17:18));
patient{2}.vMid = mean(output_table.velocity(21:22));

load('P3.mat')
patient{3}.Fx = -1:4;
patient{3}.v = (output_table.velocity(3:2:14) + output_table.velocity(4:2:14)) / 2;



figure
hold on

colors = [[0 0 1]; [1 0 0]; [0 0.5 0]];

for patientIdx = 1:length(patient)
    plot(patient{patientIdx}.Fx, patient{patientIdx}.v, 'color', colors(patientIdx,:))
    if isfield(patient{patientIdx}, 'vBack')
        scatter(0, patient{patientIdx}.vBack, '*', 'MarkerEdgeColor', colors(patientIdx,:),'HandleVisibility','off')
    end
    if isfield(patient{patientIdx}, 'vMid')
        scatter(0, patient{patientIdx}.vMid, 'MarkerEdgeColor', colors(patientIdx,:),'HandleVisibility','off')
    end
    if isfield(patient{patientIdx}, 'vFront')
        scatter(0, patient{patientIdx}.vFront, 'x', 'MarkerEdgeColor', colors(patientIdx,:),'HandleVisibility','off')
    end
end

xlabel('Ap force (%)')
ylabel('Walking velocity (m/s)')

legend('P1', 'P2', 'P3')

saveas(gcf, '..\paperFigures\patientVelocity')

