clc
clear all
close all

%% Define body properties (Leva 1996)
% [female, male]
massTotal = [61.9, 73.0];
lengthTotal = [1.735, 1.741];

massLowerLeg = [4.81, 4.33] .* massTotal / 100;
massUpperLeg = [14.78, 14.16] .* massTotal / 100;
massTrunk = [42.57, 43.46] .* massTotal / 100;
massHead = [6.68, 6.94] .* massTotal / 100;
massUpperArm = [2.55, 2.71] .* massTotal / 100;
massLowerArm = [1.38, 1.62] .* massTotal / 100;
massHand = [0.56, 0.61] .* massTotal / 100;

lengthLowerLeg = [432.3, 434.0]/1000;
lengthUpperLeg = [368.5, 422.2]/1000;
lengthTrunk = [529.3, 531.9]/1000;
lengthHead = [200.2, 203.3]/1000;
lengthUpperArm = [275.1, 281.7]/1000;
lengthLowerArm = [264.3, 268.9]/1000;
lengthHand = [78.0, 86.2]/1000;

lengthToCoG_LowerLeg = [55.84, 55.41] / 100 .* lengthLowerLeg;
lengthToCoG_UpperLeg = [63.88, 59.05] / 100 .* lengthUpperLeg;
lengthToCoG_Trunk = [58.49, 55.14] / 100 .* lengthTrunk;
lengthToCoG_Head = [41.06, 40.24] / 100 .* lengthHead;
lengthToCoG_UpperArm = [42.46, 57.72] / 100 .* lengthUpperArm;
lengthToCoG_LowerArm = [45.59, 45.74] / 100 .* lengthLowerArm;
lengthToCoG_Hand = [74.74, 79.00] / 100 .* lengthHand;

%% Simplify model to trunc, lower leg, upper leg



massTrunkSimplified = massTrunk + massHead + 2*massUpperArm + 2*massLowerArm + 2*massHand;
lengthTrunkSimplified = lengthTrunk + lengthHead;

lengthToCoG_TrunkSimplified = (lengthToCoG_Trunk .* massTrunk + ...
                               (lengthTrunk + lengthToCoG_Trunk).* massHead + ...
                               2*(lengthTrunk - lengthToCoG_UpperArm).* massUpperArm + ...
                               2*(lengthTrunk - lengthUpperArm - lengthToCoG_LowerArm).* massLowerArm + ...
                               2*(lengthTrunk - lengthUpperArm - lengthLowerArm - lengthToCoG_Hand).* massHand) ./ massTrunkSimplified;

mass.trunk = mean(massTrunkSimplified);
mass.UpperLeg = mean(massUpperLeg);
mass.LowerLeg = mean(massLowerLeg)

length.trunk = mean(lengthTrunkSimplified);
length.UpperLeg = mean(lengthUpperLeg);
length.LowerLeg = mean(lengthLowerLeg)

lengthToCoG.trunk = mean(lengthToCoG_TrunkSimplified);
lengthToCoG.UpperLeg = mean(lengthToCoG_UpperLeg);
lengthToCoG.LowerLeg = mean(lengthToCoG_LowerLeg)


%% define posture:

phi_Trunc = 0.1;
phi_UpperLeg = 0.1;
phi_LowerLeg = 0.1;

%% Apply unloading

gravitationalConstant = 9.81;

massTotal = massTrunkSimplified + 2*massUpperLeg + 2*massLowerLeg;
unloadingFraction = (0:0.01:0.8)';
unloadingForce = unloadingFraction.*massTotal*gravitationalConstant;

hipToAttachment0 = lengthTrunk;
hipToAttachmentLowerAttachment = lengthTrunk*0.75;

Fx = 0.015*massTotal*gravitationalConstant;

%% Calculate hip torques

Th0 = massTrunkSimplified * gravitationalConstant .* lengthToCoG_TrunkSimplified .* sin(phi_Trunc) - unloadingForce .* hipToAttachment0.* sin(phi_Trunc);
ThLowerAttachment = massTrunkSimplified * gravitationalConstant .* lengthToCoG_TrunkSimplified .* sin(phi_Trunc) - unloadingForce .* hipToAttachmentLowerAttachment.* sin(phi_Trunc);
ThFx = massTrunkSimplified * gravitationalConstant .* lengthToCoG_TrunkSimplified .* sin(phi_Trunc) - unloadingForce .* hipToAttachment0.* sin(phi_Trunc) + Fx .* hipToAttachment0 .* cos(phi_Trunc);

hHip = plot(unloadingFraction*100, mean(Th0, 2) / mean(Th0(1,:)), 'b');
hold on
plot(unloadingFraction*100, mean(ThLowerAttachment, 2) / mean(Th0(1,:)), 'b-.')
plot(unloadingFraction*100, mean(ThFx, 2) / mean(Th0(1,:)), 'b--')
plot(unloadingFraction*100, unloadingFraction*0 / mean(Th0(1,:)), 'color', [0 0 0])


%% Calculate knee torques
% The factor 0.5 here is to divide the torque over both legs
Fhz = (massTrunkSimplified * gravitationalConstant - unloadingForce) / 2;

Tk0 = Th0/2 + massUpperLeg * gravitationalConstant .* lengthToCoG_UpperLeg .* sin(phi_UpperLeg) + Fhz .* lengthUpperLeg.* sin(phi_UpperLeg);
TkLowerAttachment = ThLowerAttachment/2 + massUpperLeg * gravitationalConstant .* lengthToCoG_UpperLeg .* sin(phi_UpperLeg) + Fhz .* lengthUpperLeg.* sin(phi_UpperLeg);
TkFx = ThFx/2 + massUpperLeg * gravitationalConstant .* lengthToCoG_UpperLeg .* sin(phi_UpperLeg) + Fhz .* lengthUpperLeg.* sin(phi_UpperLeg) + Fx .* lengthUpperLeg .* cos(phi_UpperLeg);

% figure
hKnee = plot(unloadingFraction*100, mean(Tk0, 2) / mean(Tk0(1,:)), 'r');
% hold on
% plot(unloadingFraction*100, mean(TkLowerAttachment, 2) / mean(Tk0(1,:)), 'r')
% plot(unloadingFraction*100, mean(TkFx, 2) / mean(Tk0(1,:)), 'r')
% plot(unloadingFraction*100, unloadingFraction*0 / mean(Tk0(1,:)), 'r')
% 

%% Calculate ankle torques

Fkz = Fhz + (massUpperLeg) * gravitationalConstant;

Ta0 = Tk0 + massLowerLeg * gravitationalConstant .* lengthToCoG_LowerLeg .* sin(phi_LowerLeg) + Fkz .* lengthLowerLeg.* sin(phi_LowerLeg);
TaLowerAttachment = TkLowerAttachment + massLowerLeg * gravitationalConstant .* lengthToCoG_LowerLeg .* sin(phi_LowerLeg) + Fkz .* lengthLowerLeg.* sin(phi_LowerLeg);
TaFx = TkFx + massLowerLeg * gravitationalConstant .* lengthToCoG_LowerLeg .* sin(phi_LowerLeg) + Fkz .* lengthLowerLeg.* sin(phi_LowerLeg) + Fx .* lengthLowerLeg .* cos(phi_LowerLeg);

% figure
hAnkle = plot(unloadingFraction*100, mean(Ta0, 2) / mean(Ta0(1,:)), 'color', [0 0.5 0]);
% hold on
% plot(unloadingFraction*100, mean(TaLowerAttachment, 2) / mean(Ta0(1,:)), 'g')
% plot(unloadingFraction*100, mean(TaFx, 2) / mean(Ta0(1,:)), 'g')
% plot(unloadingFraction*100, unloadingFraction*0 / mean(Ta0(1,:)), 'g')

xlabel('Unloading (%)')
ylabel('Normalized joint torque')
% legend([hHip, hKnee, hAnkle], 'Hip', 'Knee', 'Ankle')
legend('Hip', 'Hip with alternative attachment', 'Hip with AP force', 'Knee', 'Ankle')

title('Static model joint torques')

saveas(gcf, '..\paperFigures\StaticModel')

