clc
clear all
close all

load('parsedData.mat');

% Assumed frequency
f = 1000;
dt = 1/f;


%% Obtain FLOAT data
velocity = [];
unloading = [];
desiredAPForce = [];
desiredAPForceFileName = [];
actualAPForce = [];
actualAPForceSTD = [];
desiredAPForceNorm = [];
actualAPForceNorm = [];
velocityNorm = [];
direction = [];
P_vel_vs_AP_force = [];
impulse = [];


h = openfig('..\paperFigures\RYSEN_vel_vs_APforce.fig');

for subjectIdx = 1:length(subjectData)
    for trialIdx = 1:length(subjectData{subjectIdx}.trial)
        % Extract data
        FDes = subjectData{subjectIdx}.trial{trialIdx}.FLOATDesiredForce;
        FAct= subjectData{subjectIdx}.trial{trialIdx}.FLOATActualForce;
        pos = subjectData{subjectIdx}.trial{trialIdx}.position;
        time = 0:dt:(size(FDes, 1)-1)/f;
        weight = mean(subjectData{subjectIdx}.estimatedWeight);

        % AP forces and velocity data
        velocity = [velocity; (pos(end,1)-pos(1,1)) / (time(end) - time(1)) * subjectData{subjectIdx}.trial{trialIdx}.direction];
        unloading = [unloading; mean(FDes(:,3))];
        desiredAPForce = [desiredAPForce; mean(FDes(:,1))];
        actualAPForce = [actualAPForce; mean(FAct(:,1))];
        actualAPForceSTD = [actualAPForceSTD; std(FAct(:,1))];
        direction = [direction; subjectData{subjectIdx}.trial{trialIdx}.direction];
        
        
        if ~isempty(subjectData{subjectIdx}.trial{trialIdx}.DesiredAPForce)
            desiredAPForceFileName = [desiredAPForceFileName; direction(end)*subjectData{subjectIdx}.trial{trialIdx}.DesiredAPForce, mean(FDes(:,1))];
        else
            desiredAPForceFileName = [desiredAPForceFileName; NaN, mean(FDes(:,1))];
        end
        
        
        % Force plate impulse data
        Ffpx1 = subjectData{subjectIdx}.trial{trialIdx}.FForcePlate1(:,1);
        Ffpx2 = subjectData{subjectIdx}.trial{trialIdx}.FForcePlate2(:,1);
        time = 0:dt:(size(Ffpx1, 1)-1)/f;
        direction = subjectData{subjectIdx}.trial{trialIdx}.direction;
        
        Ffpx1 = (Ffpx1 - mean(Ffpx1(1:500))) * -direction;
        Ffpx2 = (Ffpx2 - mean(Ffpx2(1:500))) * direction;
        
        impulse1 = cumtrapz(time, Ffpx1);
%         impulse1 = impulse1(end);
        
        impulse2 = cumtrapz(time, Ffpx2);
%         impulse2 = impulse2(end);
        
        impulse(end+1, :) = [impulse1(end), impulse2(end)];

        if 1
            figure(5);
            plot(time, [impulse1, impulse2])
            
        end
        
        
        % Some intermediate plots
        if 0
            figure(1)
            subplot(2,1,1);
            hold on;
            title(['Force, ', ...
                num2str(subjectData{subjectIdx}.trial{trialIdx}.DesiredVerticalForce), ...
                ' Vertical, ', ...
                num2str(subjectData{subjectIdx}.trial{trialIdx}.DesiredAPForce), ...
                'FWD']);
            plot(FDes(:,1),'b--');
            plot(FAct(:,1),'b');
            plot(FDes(:,2),'r--');
            plot(FAct(:,2),'r');
            plot(FDes(:,3),'k--');
            plot(FAct(:,3),'k');
            subplot(2,1,2);
            plot(pos);
            title('position')
        end
        
        % Normalize
        if ~isempty(weight)
            desiredAPForceNorm = [desiredAPForceNorm; mean(FDes(:,1)) / (weight*9.81)];
            actualAPForceNorm = [actualAPForceNorm; mean(FAct(:,1)) / (weight*9.81)];          
        else
            desiredAPForceNorm = [desiredAPForceNorm; nan];
            actualAPForceNorm = [actualAPForceNorm; nan];                      
        end
                
    end

    nrOfTrials = length(subjectData{subjectIdx}.trial);

       
    % Plot velocity vs AP force
    
    subjectAPForceActNorm = actualAPForceNorm((end-nrOfTrials+1:end));
    subjectVelocity = velocity((end-nrOfTrials+1:end));
    
    P = polyfit(subjectAPForceActNorm, subjectVelocity, 1);
    normalWalkingVelocity = P(2);
    subjectVelocityNorm = subjectVelocity / normalWalkingVelocity;
    
    
    
    if nrOfTrials > 10
        P_vel_vs_AP_force = [P_vel_vs_AP_force; P(1) / normalWalkingVelocity];
        
        figure(h);
        scatter(subjectAPForceActNorm*100, subjectVelocityNorm)
        hold on
        plot(subjectAPForceActNorm * 100, polyval(P, subjectAPForceActNorm) / normalWalkingVelocity)
        xlabel('AP force (N)')
        ylabel('Self selected velocity');
    end
    
    
    if 0
        figure(3)
        scatter3(actualAPForceAbs(end-nrOfTrials+1:end).*direction(end-nrOfTrials+1:end), unloading(end-nrOfTrials+1:end), velocity(end-nrOfTrials+1:end).*direction(end-nrOfTrials+1:end));
    end
end
% 
% saveas(h, ['..\paperFigures\FLOAT_and_RYSEN_vel_vs_F'], 'fig')


%% Obtain walking velocities at certain unloading

Fz = 500;

velocities_Fz = velocity((unloading > Fz-10) .* (unloading < Fz + 10) == 1);

mean(velocities_Fz)
std(velocities_Fz)

%% Plot velocity, unloading, bias relationship


% 3D plot
figure
scatter3(velocity, unloading, (actualAPForce-desiredAPForce))
title('FLOAT controller bias')
xlabel('velocity (m/s)')
ylabel('unloading (N)')
zlabel('bias (N)')

% 2D plot
unloadingVect = 100:100:500;
velocityVect = 0.5:0.05:1.4;

[velocityGrid, unloadingGrid] = meshgrid(velocityVect, unloadingVect);

biasGrid = interpolateUnsortedGrid(velocity, unloading, (actualAPForce-desiredAPForce), velocityGrid, unloadingGrid, 0.2);
biasGridSTD = interpolateUnsortedGrid(velocity, unloading, actualAPForceSTD, velocityGrid, unloadingGrid, 0.2);

hold on
surf(velocityGrid, unloadingGrid, biasGrid)



% h = uiopen('..\paperFigures\RYSEN_controller_bias.fig',1)
h = openfig('..\paperFigures\RYSEN_controller_bias.fig');

hold on
plot(velocityVect, biasGrid);

for Idx = 1:length(unloadingVect)
    jbfill(velocityVect , (biasGrid(Idx,:)+biasGridSTD(Idx,:)), ...
            (biasGrid(Idx,:)-biasGridSTD(Idx,:)), ...
            'r', 'r', 1, 0.2);
end

title('FLOAT and RYSEN controller biases')
xlabel('velocity (m/s)')
ylabel('bias (N)')

saveas(h, ['..\paperFigures\FLOAT_and_RYSEN_controller_bias'], 'fig')


%% Include data in plot of RYSEN

h = openfig('..\paperFigures\RYSEN_vel_vs_APforce.fig');
minFx = -3.5;
maxFx = 3.5;

Fx = (minFx:0.01:maxFx);

velFit = polyval([mean(P_vel_vs_AP_force(~isnan(P_vel_vs_AP_force))), 1], Fx/100);

plot(Fx, velFit)


saveas(h, ['..\paperFigures\FLOAT_and_RYSEN_vel_vs_F'], 'fig')


%% Plot forward impulse force plates vs AP force

figure

scatter(actualAPForce, impulse(:,1), 'b')
hold on
scatter(actualAPForce, impulse(:,2), 'r')

P = polyfit(actualAPForce, mean(impulse,2), 1);
P1 = polyfit(actualAPForce, impulse(:,1), 1);
P2 = polyfit(actualAPForce, impulse(:,2), 1);

impulseFit = polyval(P, actualAPForce);
impulseFit1 = polyval(P1, actualAPForce);
impulseFit2 = polyval(P2, actualAPForce);

hold on
plot(actualAPForce, impulseFit)
plot(actualAPForce, impulseFit1, 'b')
plot(actualAPForce, impulseFit2, 'r')

xlabel('Actual FLOAT AP force (N)')
ylabel('Force plate impulse (Ns)')
legend('Force plate 1', 'Force plate 2')

figure
scatter3(actualAPForce, unloading, mean(impulse,2))


