

clc
clear all
close all

weights = [61;
    77.3;
    68.5;
    62.2;
    70.2;
    57.5;
    61.4;
    79.0;
    73.7;
    52.8;
    89.5;
    74.6;
    67.4;
    97.3;
    80.3;
    NaN;
    84.7;
    NaN;
    72.9];

heights = [1.68;
    1.75;
    1.80;
    1.645;
    1.77;
    1.63;
    1.625;
    1.77;
    1.775;
    1.77;
    1.88;
    NaN;
    1.65;
    NaN;
    1.80;
    NaN;
    1.83;
    NaN;
    1.19];

startTimes = [1228;
    1893;
    1840;
    2760;
    0;
    2470;
    2360;
    4050;
    2140;
    247;
    270;
    170;
    530;
    0;
    235;
    0;
    128;
    0;
    150];

endTimes = [2050;
    2824;
    2600;
    3610;
    0;
    3450;
    3050;
    5100;
    3300;
    1000;
    1420;
    915;
    1130;
    0;
    1048;
    0;
    950;
    0;
    1262];

SubjectSelection = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 17, 19];


ConditionChangeIdxs = [
    1,5,11,16,21,26,31,36,41,46,51, zeros(1,6);
    1,5,8,13,18,23,28,33,38,43,48,53, zeros(1,5);
    1,6,11,16,23,28,33,38,43,48,53, zeros(1,6);
    1,5,10,15,21,26,31,36,37,42,43,44,49,54,59,64, 0;
    1,6,11,17,22,27,34,45,50,57,62,67,zeros(1,5);
    1,4,9,16,22,25,32,39,44,49,55,60,65, zeros(1,4);
    1,6,11,17,22,27,32,39,44,48,53,59, zeros(1,5);
    1,7,13,18,23,29,35,40,45,50,58,63 zeros(1,5);
    1,8,16,23,30,31,32,33,39,44,49,56,62,69,74, zeros(1,2);
    1,4,9,14,19,24,29,34,35,40,45,50, zeros(1,5);       % 10
    1,5,9,14,19,24,29,35,40,45,50,55, zeros(1,5);
    1,5,11,16,21,26,31,36,38,43,48,53, zeros(1,5);
    1,4,10,15,20,25,31,36,41,46,51,56, zeros(1,5);
    zeros(1,17);
    1,5,10,15,20,25,30,35,41,47,52,57,zeros(1,5);
    zeros(1,17);
    1,5,10,15,20,25,30,36,41,46,51,56,61, zeros(1,4);
    zeros(1,17);
    1,4,9,14,20,25,30,35,41,48,53,58,64,68,72, 0, 0
    ];

% -5 denotes ignore condition
HorForceIDs = [
    0,-1.5,3,6,0,-3,0,3,-1.5,-3,1.5, -5*ones(1,5);
    0,-5,1.5,-1.5,-3,0,3,-1.5,-3,0,1.5,3,-5*ones(1,4);
    0,0,3,6,-1.5,-3,-1.5,0,1.5,-3,3,-5*ones(1,5);
    0,-3,3,6,0,-1.5,-5,-5,1.5,-5,-5,-3,1.5,0,-1.5,3;
    0,-1.5,-3,0,1.5,3,3,-3,6,0,-1.5,1.5,-5*ones(1,4);
    0,-1.5,-3,0,-5,3,6,1.5,-3,3,0,1.5,-1.5,-5*ones(1,3);
    0,1.5,-3,-1.5,3,0,6,-3,1.5,3,0,-1.5,-5*ones(1,4);
    0,3,0,6,-1.5,-3,1.5,-1.5,-3,3,0,1.5,-5*ones(1,4);
    0,3,-3,-1.5,-5,-5,-5,0,1.5,1.5,-3,3,-1.5,0,-5,-5*ones(1,1);
    0,3,1.5,-3,-1.5,0,-3,-5,1.5,-1.5,3,0,-5*ones(1,4);        % 10
    0,0,1.5,-1.5,3,-3,-1.5,-3,3,1.5,0,6,-5*ones(1,4);
    0,0,3,1.5,-1.5,-3,1.5,-5,-1.5,0,3,-3,-5*ones(1,4);
    0,3,1.5,-3,-1.5,0,0,-3,3,1.5,-1.5,6,-5*ones(1,4);
    -5*ones(1,16);
    0,3,0,1.5,-1.5,-3,6,-3,3,0,-1.5,1.5,-5*ones(1,4);
    -5*ones(1,16);
    0,0,-1.5,1.5,-3,3,-3,-1.5,3,0,6,1.5,-5,-5*ones(1,3);
    -5*ones(1,16);
    0,1.5,-3,3,0,-1.5,1.5,-3,6,-1.5,0,3,-5*ones(1,4)
    ];



%% Extract data

allData = [];

for SubjectIdx = SubjectSelection
    SubjectIdx
    load(['subject', num2str(SubjectIdx), '.mat']);
    
    time = time_ms / 1000;
    pos = [posX_mm, posY_mm, posZ_mm] / 1000;
    force = [forceX_mN, forceY_mN, forceZ_mN] / 1000;
    
    timeSampled = (time(1):0.01:time(end))';
    posSampled = interp1(time, pos, timeSampled);
    forceSampled = interp1(time, force, timeSampled);
    
    startTime = startTimes(SubjectIdx);
    endTime = endTimes(SubjectIdx);
    
    duration(SubjectIdx) = endTime - startTime;
    
    force30 = force((time >= startTime) .* (time <= endTime) == 1, :);
    pos30 = pos((time >= startTime) .* (time <= endTime) == 1, :);
    time30 = time((time >= startTime) .* (time <= endTime) == 1);
    
    
    time30Sampled = (startTime+0.05:0.01:endTime-0.1)';
    force30Sampled = interp1(time30, force30, time30Sampled);
    pos30Sampled = interp1(time30, pos30, time30Sampled);
    
    
    [timeData, posData, forceData, stepData, trialData] = extractSteps( timeSampled, posSampled, forceSampled, weights(SubjectIdx));
    
    allData{SubjectIdx}.stepData = stepData;
    allData{SubjectIdx}.trialData = trialData;
    
    Fref = [0, 0, 0.3*9.81*weights(SubjectIdx) + 2.0*9.81];
    
    bias(SubjectIdx, :) = mean(forceData) - Fref;
    sigma(SubjectIdx, :) = std(forceData);
    maxError(SubjectIdx, :) = max(abs(forceData - Fref));
    
end



%% Sort the steps per condition
FzList = [10, 30, 60];
FxList = [-3, -1.5, 0, 1.5, 3, 6];

forceAverages = [];

for SubjectIdx = SubjectSelection
    FAll = [];
    allData{SubjectIdx}.forceAverages = [];
    allData{SubjectIdx}.trialDataOrdered = [];
    
    
    for trialIdx = 1:length(allData{SubjectIdx}.trialData)
        FAll = [FAll; mean(allData{SubjectIdx}.trialData{trialIdx}.force)];
    end
    
    % Calculate force averages per condition
    for ConditionIdx = 1:size(ConditionChangeIdxs, 2)
        if ConditionChangeIdxs(SubjectIdx, ConditionIdx) ~= 0
            forceAveragesThisCondition = [];
            endIdx = ConditionChangeIdxs(SubjectIdx, ConditionIdx+1)-1;
            if endIdx == -1
                endIdx = length(allData{SubjectIdx}.trialData);
            end
            for trialIdx = ConditionChangeIdxs(SubjectIdx, ConditionIdx):endIdx
                forceAveragesThisCondition(end+1,:) = mean(allData{SubjectIdx}.trialData{trialIdx}.force);
            end
            allData{SubjectIdx}.forceAverages(end+1,:) = mean(forceAveragesThisCondition);
        end
    end
    
    errorFz = abs(FzList*weights(SubjectIdx)*9.81/100 - allData{SubjectIdx}.forceAverages(:,3));
    errorFx = abs(FxList*weights(SubjectIdx)*9.81/100 - allData{SubjectIdx}.forceAverages(:,1));
    FzIdx = zeros(size(allData{SubjectIdx}.forceAverages, 1), 1);
    FxIdx = zeros(size(allData{SubjectIdx}.forceAverages, 1), 1);
    
    for ConditionIdx = 1:size(allData{SubjectIdx}.forceAverages, 1)
        % Determine vertical force per condition
        FzIdx(ConditionIdx) = find(errorFz(ConditionIdx, :)==min(errorFz(ConditionIdx,:)));
        FxID = find(FxList == HorForceIDs(SubjectIdx, ConditionIdx));
        if length(FxID) == 1
            FxIdx(ConditionIdx) = find(FxList == HorForceIDs(SubjectIdx, ConditionIdx));
        end
        
        % Put data in struct
        startIdx = ConditionChangeIdxs(SubjectIdx, ConditionIdx);
        endIdx = ConditionChangeIdxs(SubjectIdx, ConditionIdx+1)-1;
        if endIdx == -1
            endIdx = length(allData{SubjectIdx}.trialData);
        end
        if FxIdx(ConditionIdx) > 0
            allData{SubjectIdx}.trialDataOrdered{FzIdx(ConditionIdx), FxIdx(ConditionIdx)}.trials = [];
            if endIdx-startIdx+1 < 3
                SubjectIdx, ConditionIdx, endIdx-startIdx
            end
            for trialIdx = max(startIdx+1, endIdx-3):endIdx
                allData{SubjectIdx}.trialDataOrdered{FzIdx(ConditionIdx), FxIdx(ConditionIdx)}.trials{end+1}.time = allData{SubjectIdx}.trialData{trialIdx}.time;
                allData{SubjectIdx}.trialDataOrdered{FzIdx(ConditionIdx), FxIdx(ConditionIdx)}.trials{end}.pos = allData{SubjectIdx}.trialData{trialIdx}.pos;
                allData{SubjectIdx}.trialDataOrdered{FzIdx(ConditionIdx), FxIdx(ConditionIdx)}.trials{end}.force = allData{SubjectIdx}.trialData{trialIdx}.force;
            end
        end
    end
    
    
    
end






%% outcome measures

forceOutcomeData = [];


for SubjectIdx = SubjectSelection
    for FzIdx = 1:length(FzList)
        forceOutcomeData{SubjectIdx, FzIdx}.bias = zeros(length(FxList), 3);
        forceOutcomeData{SubjectIdx, FzIdx}.sigma = zeros(length(FxList), 3);
        forceOutcomeData{SubjectIdx, FzIdx}.maxError = zeros(length(FxList), 3);
        
        for FxIdx = 1:length(FxList)
            forceCondition = [];
            forceRef = [FxList(FxIdx), 0, FzList(FzIdx)]/100*9.81*weights(SubjectIdx);
            if FxIdx <= size(allData{SubjectIdx}.trialDataOrdered, 2)
                if length(allData{SubjectIdx}.trialDataOrdered{FzIdx, FxIdx}) > 0
                    for trialIdx = 1:length(allData{SubjectIdx}.trialDataOrdered{FzIdx, FxIdx}.trials)
                        forceCondition = [forceCondition; allData{SubjectIdx}.trialDataOrdered{FzIdx, FxIdx}.trials{trialIdx}.force];
                    end
                    if length(forceCondition) > 0
                        forceOutcomeData{SubjectIdx, FzIdx}.bias(FxIdx, :) = mean(forceCondition - forceRef);
                        forceOutcomeData{SubjectIdx, FzIdx}.sigma(FxIdx, :) = std(forceCondition - forceRef);
                        forceOutcomeData{SubjectIdx, FzIdx}.maxError(FxIdx, :) = max(abs(forceCondition - forceRef));
                    end
                end
            end
        end
    end
    
end


% Combine output data
biasDataPerCondition = [];
sigmaDataPerCondition = [];
maxErrorDataPerCondition = [];

biasMatrices = [];
sigmaMatrices = [];
maxErrorMatrices = [];

biasMatrices_normalized = [];
sigmaMatrices_normalized = [];
maxErrorMatrices_normalized = [];

for FzIdx = 1:length(FzList)
    biasMatrices{FzIdx}.matrix = zeros(length(FxIdx), 3);
    sigmaMatrices{FzIdx}.matrix = zeros(length(FxIdx), 3);
    maxErrorMatrices{FzIdx}.matrix = zeros(length(FxIdx), 3);
    
    biasMatrices_normalized{FzIdx}.matrix = zeros(length(FxIdx), 3);
    sigmaMatrices_normalized{FzIdx}.matrix = zeros(length(FxIdx), 3);
    maxErrorMatrices_normalized{FzIdx}.matrix = zeros(length(FxIdx), 3);
    
    for FxIdx = 1:length(FxList)
        biasDataPerCondition{FzIdx, FxIdx}.data = [];
        sigmaDataPerCondition{FzIdx, FxIdx}.data = [];
        maxErrorDataPerCondition{FzIdx, FxIdx}.data = [];
        
        biasDataPerCondition_normalized{FzIdx, FxIdx}.data = [];
        sigmaDataPerCondition_normalized{FzIdx, FxIdx}.data = [];
        maxErrorDataPerCondition_normalized{FzIdx, FxIdx}.data = [];
        
        
        for SubjectIdx = SubjectSelection
            if forceOutcomeData{SubjectIdx, FzIdx}.bias(FxIdx, 1) ~= 0
                biasDataPerCondition{FzIdx, FxIdx}.data(end+1,:) = forceOutcomeData{SubjectIdx, FzIdx}.bias(FxIdx, :);
                sigmaDataPerCondition{FzIdx, FxIdx}.data(end+1,:) = forceOutcomeData{SubjectIdx, FzIdx}.sigma(FxIdx, :);
                maxErrorDataPerCondition{FzIdx, FxIdx}.data(end+1,:) = forceOutcomeData{SubjectIdx, FzIdx}.maxError(FxIdx, :);
                
                biasDataPerCondition_normalized{FzIdx, FxIdx}.data(end+1,:) = forceOutcomeData{SubjectIdx, FzIdx}.bias(FxIdx, :) / (9.81*weights(SubjectIdx));
                sigmaDataPerCondition_normalized{FzIdx, FxIdx}.data(end+1,:) = forceOutcomeData{SubjectIdx, FzIdx}.sigma(FxIdx, :) / (9.81*weights(SubjectIdx));
                maxErrorDataPerCondition_normalized{FzIdx, FxIdx}.data(end+1,:) = forceOutcomeData{SubjectIdx, FzIdx}.maxError(FxIdx, :) / (9.81*weights(SubjectIdx));
            end
        end
        biasMatrices{FzIdx}.matrix(FxIdx, :) = mean(biasDataPerCondition{FzIdx, FxIdx}.data);
        sigmaMatrices{FzIdx}.matrix(FxIdx, :) = mean(sigmaDataPerCondition{FzIdx, FxIdx}.data);
        maxErrorMatrices{FzIdx}.matrix(FxIdx, :) = mean(maxErrorDataPerCondition{FzIdx, FxIdx}.data);
        
        biasMatrices_normalized{FzIdx}.matrix(FxIdx, :) = mean(biasDataPerCondition_normalized{FzIdx, FxIdx}.data);
        sigmaMatrices_normalized{FzIdx}.matrix(FxIdx, :) = mean(sigmaDataPerCondition_normalized{FzIdx, FxIdx}.data);
        maxErrorMatrices_normalized{FzIdx}.matrix(FxIdx, :) = mean(maxErrorDataPerCondition_normalized{FzIdx, FxIdx}.data);
        
    end
end



%% Save the stuff
dataPerSubject = [];

% put in correct format
for SubjectIdx = 1:19
    dataPerSubject{SubjectIdx}.weight = weights(SubjectIdx);
    dataPerSubject{SubjectIdx}.length = heights(SubjectIdx);
    if length(allData{SubjectIdx}) > 0
        dataPerSubject{SubjectIdx}.trialDataPerCondition = allData{SubjectIdx}.trialDataOrdered;
        
        for FzIdx = 1:length(FzList)
            for FxIdx = 1:length(FxList)
                dataPerSubject{SubjectIdx}.forceOutcomeDataPerCondition{FzIdx, FxIdx}.bias = forceOutcomeData{SubjectIdx, FzIdx}.bias(FxIdx,:);
                dataPerSubject{SubjectIdx}.forceOutcomeDataPerCondition{FzIdx, FxIdx}.sigma = forceOutcomeData{SubjectIdx, FzIdx}.sigma(FxIdx,:);
                dataPerSubject{SubjectIdx}.forceOutcomeDataPerCondition{FzIdx, FxIdx}.maxError = forceOutcomeData{SubjectIdx, FzIdx}.maxError(FxIdx,:);
                
                dataPerSubject{SubjectIdx}.forceOutcomeDataPerCondition_normalized{FzIdx, FxIdx}.bias = forceOutcomeData{SubjectIdx, FzIdx}.bias(FxIdx,:) / (9.81*weights(SubjectIdx));
                dataPerSubject{SubjectIdx}.forceOutcomeDataPerCondition_normalized{FzIdx, FxIdx}.sigma = forceOutcomeData{SubjectIdx, FzIdx}.sigma(FxIdx,:) / (9.81*weights(SubjectIdx));
                dataPerSubject{SubjectIdx}.forceOutcomeDataPerCondition_normalized{FzIdx, FxIdx}.maxError = forceOutcomeData{SubjectIdx, FzIdx}.maxError(FxIdx,:) / (9.81*weights(SubjectIdx));

            end
        end
    end
    
end

forceOutcomeDataPerCondition = [];

for FzIdx = 1:length(FzList)
    for FxIdx = 1:length(FxList)
        forceOutcomeDataPerCondition{FzIdx, FxIdx}.bias = biasMatrices{FzIdx}.matrix(FxIdx,:);
        forceOutcomeDataPerCondition{FzIdx, FxIdx}.sigma = sigmaMatrices{FzIdx}.matrix(FxIdx,:);
        forceOutcomeDataPerCondition{FzIdx, FxIdx}.maxError = maxErrorMatrices{FzIdx}.matrix(FxIdx,:);
        
        forceOutcomeDataPerCondition{FzIdx, FxIdx}.bias_normalized = biasMatrices_normalized{FzIdx}.matrix(FxIdx,:);
        forceOutcomeDataPerCondition{FzIdx, FxIdx}.sigma_normalized = sigmaMatrices_normalized{FzIdx}.matrix(FxIdx,:);
        forceOutcomeDataPerCondition{FzIdx, FxIdx}.maxError_normalized = maxErrorMatrices_normalized{FzIdx}.matrix(FxIdx,:);

    end
end



save('RYSENData.mat', 'dataPerSubject', 'forceOutcomeDataPerCondition', 'FzList', 'FxList', 'SubjectSelection');


%% Plot some stuff for subjects

for SubjectIdx = SubjectSelection
    for FzIdx = 1:3
        for FxIdx = 1:6
            clf
            hold on
            if size(allData{SubjectIdx}.trialDataOrdered, 2) >= FxIdx
                if size(allData{SubjectIdx}.trialDataOrdered{FzIdx, FxIdx}) > 0
                    [SubjectIdx,FzIdx,FxIdx]
                    for Idx = 1:size(allData{SubjectIdx}.trialDataOrdered{FzIdx, FxIdx}.trials,2)
                        plot(allData{SubjectIdx}.trialDataOrdered{FzIdx, FxIdx}.trials{Idx}.time, allData{SubjectIdx}.trialDataOrdered{FzIdx, FxIdx}.trials{Idx}.force(:,[1 3]))
                        
                    end
                    keyboard
                end
            end
        end
    end
end






