

clc
clear all
close all

load('RYSENData.mat')


velocity = [];
unloading = [];
desiredAPForce = [];
actualAPForce = [];
actualAPForceSTD = [];

for FzIdx = 1:length(FzList)
    figure(FzIdx)
    hold on
    dataThisFz = [];
    labelsThisFz = [];
    for FxIdx = 1:length(FxList)
        for SubjectIdx = SubjectSelection
            weight = dataPerSubject{SubjectIdx}.weight;

            if size(dataPerSubject{SubjectIdx}.trialDataPerCondition, 2) >= FxIdx
                if length(dataPerSubject{SubjectIdx}.trialDataPerCondition{FzIdx,FxIdx}) > 0
                    % [FzIdx, FxIdx]
                    data = [];
                    for trialIdx = 1:length(dataPerSubject{SubjectIdx}.trialDataPerCondition{FzIdx,FxIdx}.trials)
                        data = [data; dataPerSubject{SubjectIdx}.trialDataPerCondition{FzIdx,FxIdx}.trials{trialIdx}.force / (9.81*weight)*100];
                    end
                    dataThisFz = [dataThisFz; data];
                    labelsThisFz = [labelsThisFz; FxList(FxIdx)*ones(size(data,1), 1)];
                    
                end
            end
            if size(dataPerSubject{SubjectIdx}.trialDataPerCondition, 2) >= FxIdx
                if isfield(dataPerSubject{SubjectIdx}.trialDataPerCondition{FzIdx,FxIdx}, 'trials')
                    time = dataPerSubject{SubjectIdx}.trialDataPerCondition{FzIdx,FxIdx}.trials{trialIdx}.time;
                    pos = dataPerSubject{SubjectIdx}.trialDataPerCondition{FzIdx,FxIdx}.trials{trialIdx}.pos;
                    force = dataPerSubject{SubjectIdx}.trialDataPerCondition{FzIdx,FxIdx}.trials{trialIdx}.force;
                    
                    velocity = [velocity; (pos(end,1) - pos(1,1)) / (time(end) - time(1))];
                    unloading = [unloading; mean(force(:,3))];
                    desiredAPForce = [desiredAPForce; FxList(FxIdx) * (9.81*weight)/100];
                    actualAPForce = [actualAPForce; mean(force(:,1))];
                    actualAPForceSTD = [actualAPForceSTD; std(force(:,1))];
                    
                end
            end
            
        end
    end
    for directionIdx = 1:3
        subplot(1,3,directionIdx)
        boxplot(dataThisFz(:,directionIdx), labelsThisFz);
        if directionIdx == 1
            if FzIdx == 1
                line([FxList(1); FxList(end)],[0;0],'color', 'b');
            end
            if FzIdx == 2
                line(repmat([FxList(1); FxList(end)], 1,5),repmat(FxList(1:end-1), 2,1),'color', 'b');
            end
            if FzIdx == 3
                line(repmat([FxList(1); FxList(end)], 1,6),repmat(FxList, 2,1),'color', 'b');
            end
            ylim([-10,10])
            xlabel('Desired Fx (%)')
            ylabel('Fx (%)')
        end
        if directionIdx == 2
            line([FxList(1); FxList(end)],[0,0]);
            ylim([-10,10])
            xlabel('Desired Fx (%)')
            ylabel('Fy (%)')
        end
        if directionIdx == 3
            line([FxList(1); FxList(end)],[FzList(FzIdx), FzList(FzIdx)]);
            ylim([0,100])
            xlabel('Desired Fx (%)')
            ylabel('Fz (%)')
        end
    end
end

figure(1)
saveas(gcf, '..\paperFigures\RYSEN_forceTracking_humans_10', 'fig')

figure(2)
saveas(gcf, '..\paperFigures\RYSEN_forceTracking_humans_30', 'fig')

figure(3)
saveas(gcf, '..\paperFigures\RYSEN_forceTracking_humans_60', 'fig')


%% Make 2D bias plot for paper


figure
scatter3(velocity, unloading, (actualAPForce-desiredAPForce))
title('RYSEN controller bias')
xlabel('velocity (m/s)')
ylabel('unloading (N)')
zlabel('bias (N)')



% 2D plot
unloadingVect = 100:100:500;
velocityVect = 0.5:0.05:1.4;

[velocityGrid, unloadingGrid] = meshgrid(velocityVect, unloadingVect);

biasGrid = interpolateUnsortedGrid(velocity, unloading, (actualAPForce-desiredAPForce), velocityGrid, unloadingGrid, 0.2);
biasGridSTD = interpolateUnsortedGrid(velocity, unloading, actualAPForceSTD, velocityGrid, unloadingGrid, 0.2);



hold on
surf(velocityGrid, unloadingGrid, biasGrid)


figure
plot(velocityVect, biasGrid);


for Idx = 1:length(unloadingVect)
    jbfill(velocityVect , (biasGrid(Idx,:)+biasGridSTD(Idx,:)), ...
            (biasGrid(Idx,:)-biasGridSTD(Idx,:)), ...
            'b', 'b', 1, 0.2);
end

                  
title('RYSEN controller bias 2D')
xlabel('velocity (m/s)')
ylabel('bias (N)')


saveas(gcf, '..\paperFigures\RYSEN_controller_bias', 'fig')




