function [zDes] = interpolateUnsortedGrid(x, y, z, xDes, yDes, maxRelError)

xDes = xDes / (max(x) - min(x));
yDes = yDes / (max(y) - min(y));


x = x(:) / (max(x) - min(x));
y = y(:) / (max(y) - min(y));

if sum(size(xDes) - size(yDes)) ~= 0
    disp('sizes do not match');
end

zDes = nan(size(xDes));

for Idx1 = 1:size(xDes, 1)
    for Idx2 = 1:size(xDes, 2)
        xPoint = xDes(Idx1, Idx2);
        yPoint = yDes(Idx1, Idx2);

        distances = sqrt((x-xPoint).^2 + (y-yPoint).^2);
        angles = (sign(x-xPoint) == -1) * pi + atan((y-yPoint)./(x-xPoint));
        
        % First add the 2 closest points
        distancesSort = sort(distances);
        polygonIdxs = zeros(3,1);
        for Idx = 1:2
            polygonIdxs(Idx) = find(distances == distancesSort(Idx));
        end
        
        % Then iterate to find additional points that have the right angle      
        for Idx3 = 3:length(distances)
            if maxRelError < distancesSort(Idx3)
                break;
            end
            % Add point
            polygonIdxs(3) = find(distances == distancesSort(Idx3));
            
            % Check angles
            anglesPolygon = angles(polygonIdxs);
            
            % either break or delete point
            anglesPolygonSort = sort(anglesPolygon);
            anglesPolygonDiff = abs(anglesPolygonSort([2,3,1])+[0;0;2*pi] - anglesPolygonSort);
            if max(anglesPolygonDiff) <= pi
                % Calculate Z
                p = [x(polygonIdxs), y(polygonIdxs), z(polygonIdxs)];
                v12 = p(2,1:2) -  p(1,1:2);
                v13 = p(3,1:2) -  p(1,1:2);
                v14 = [xPoint, yPoint] -  p(1, 1:2);
                s = inv([v12(1:2)', v13(1:2)']) * v14';
                zDes(Idx1, Idx2) = s'*(p(2:3,3) - p(1,3)) + p(1,3);
                break;
            else
                
                if mod(find(anglesPolygonDiff > pi)-2, 3)+1 == 0
                    keyboard
                end
                IdxToDelete = find(anglesPolygon == anglesPolygonSort(mod(find(anglesPolygonDiff > pi)-2, 3)+1));
                polygonIdxs(IdxToDelete) = [];
                
            end
            
        end
        
        
    end
end





end

