

clc
clear all
close all

weights = [61;
    77.3;
    68.5;
    62.2;
    70.2;
    57.5;
    61.4;
    79.0;
    73.7;
    52.8;
    89.5;
    74.6;
    67.4;
    97.3;
    80.3;
    NaN;
    84.7;
    NaN;
    72.9];

heights = [1.68;
    1.75;
    1.80;
    1.645;
    1.77;
    1.63;
    1.625;
    1.77;
    1.775;
    1.77;
    1.88;
    NaN;
    1.65;
    NaN;
    1.80;
    NaN;
    1.83;
    NaN;
    1.19];

startTimes = [1228;
    1893;
    1840;
    2760;
    0;
    2470;
    2360;
    4050;
    2140;
    247;
    270;
    170;
    530;
    0;
    235;
    0;
    128;
    0;
    150];

endTimes = [2050;
    2824;
    2600;
    3610;
    0;
    3450;
    3050;
    5100;
    3300;
    1000;
    1420;
    915;
    1130;
    0;
    1048;
    0;
    950;
    0;
    1262];



ConditionChangeIdxs = [
    1,17,41,60,80,100,120,140,160,180,200, zeros(1,6);
    1,17,48,68,88,108,128,148,168,188,208, zeros(1,6);
    1,21,41,61,89,109,129,149,169,189,209, zeros(1,6);
    1,17,37,57,81,101,121,141,145,165,169,173,193,213,233,253, 0;
    zeros(1,17);
    1,13,33,61,85,125,153,173,193,217,237,257, zeros(1,5);
    1,21,41,65,85,105,125,153,173,189,209,233, zeros(1,5);
    1,25,49,68,89,113,117,137,157,177,197,229,249, zeros(1,4);
    1,29,61,89,117,125,129,153,173,193,221,245,273, zeros(1,4);
    1,13,33,53,73,92,112,130,134,138,154,174,194, zeros(1,4);
    1,17,33,53,73,93,113,137,157,177,197,217, zeros(1,5);
    1,17,41,65,81,101,121,141,148,168,188,208, zeros(1,5);
    1,13,37,57,77,97,121,141,161,181,201, zeros(1,6);
    zeros(1,17);
    1,17,37,57,77,97,117,137,161,185,205,225,zeros(1,5);
    zeros(1,17);
    1,17,37,58,77,97,117,141,160,179,199,219, zeros(1,5);
    zeros(1,17);
    1,13,33,53,77,97,117,137,161,189,209,229,253,269,284, 0, 0
    ];

% -5 denotes ignore condition
HorForceIDs = [
    0,-1.5,3,6,0,-3,0,3,-1.5,-3,1.5, -5*ones(1,5);
    0,1.5,-1.5,-3,0,3,-1.5,-3,0,1.5,3,-5*ones(1,5);
    0,0,3,6,-1.5,-3,-1.5,0,1.5,-3,3,-5*ones(1,5);
    0,-3,3,6,0,-1.5,-5,-5,1.5,-5,-5,-3,1.5,0,-1.5,3;
    -5*ones(1,16);
    0,-1.5,-3,0,3,6,1.5,-3,3,0,1.5,-1.5,-5*ones(1,4);
    0,1.5,-3,-1.5,3,0,6,-3,1.5,3,0,-1.5,-5*ones(1,4);
    0,3,0,6,-1.5,-5,-3,1.5,-1.5,-3,3,0,1.5,-5*ones(1,3);
    0,3,-3,-1.5,-5,-5,0,1.5,1.5,-3,3,-1.5,0,-5*ones(1,3);
    0,3,1.5,-3,-1.5,0,-3,-5,-5,1.5,-1.5,3,0,-5*ones(1,3);        % 10
    0,1.5,-1.5,3,-3,-1.5,-3,3,1.5,0,6,-5*ones(1,5);
    0,0,3,1.5,-1.5,-3,1.5,-5,-1.5,3,-3,-5*ones(1,5);
    0,3,1.5,-3,-1.5,0,0,-3,3,1.5,-1.5,6,-5*ones(1,4);
    -5*ones(1,16);
    0,3,0,1.5,-1.5,-3,6,-3,3,0,-1.5,1.5,-5*ones(1,4);
    -5*ones(1,16);
    0,0,-1.5,1.5,-3,3,-3,-1.5,3,0,6,1.5,-5*ones(1,4);
    -5*ones(1,16);
    0,1.5,-3,3,0,-1.5,1.5,-3,6,-1.5,0,3,-5*ones(1,4)
    ];



%% Extract data

allData = [];

for SubjectIdx = [1, 2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 15, 17, 19]
    SubjectIdx
    load(['subject', num2str(SubjectIdx), '.mat']);
    
    time = time_ms / 1000;
    pos = [posX_mm, posY_mm, posZ_mm] / 1000;
    force = [forceX_mN, forceY_mN, forceZ_mN] / 1000;
    
    timeSampled = (time(1):0.01:time(end))';
    posSampled = interp1(time, pos, timeSampled);
    forceSampled = interp1(time, force, timeSampled);
    
    startTime = startTimes(SubjectIdx);
    endTime = endTimes(SubjectIdx);
    
    duration(SubjectIdx) = endTime - startTime;
    
    force30 = force((time >= startTime) .* (time <= endTime) == 1, :);
    pos30 = pos((time >= startTime) .* (time <= endTime) == 1, :);
    time30 = time((time >= startTime) .* (time <= endTime) == 1);
    
    
    time30Sampled = (startTime+0.05:0.01:endTime-0.1)';
    force30Sampled = interp1(time30, force30, time30Sampled);
    pos30Sampled = interp1(time30, pos30, time30Sampled);
    
    
    [timeData, posData, forceData, stepData, trialData] = extractSteps( timeSampled, posSampled, forceSampled, weights(SubjectIdx));
    
    allData{SubjectIdx}.stepData = stepData;
    allData{SubjectIdx}.trialData = trialData;
    
    Fref = [0, 0, 0.3*9.81*weights(SubjectIdx) + 2.0*9.81];
    
    bias(SubjectIdx, :) = mean(forceData) - Fref;
    sigma(SubjectIdx, :) = std(forceData);
    maxError(SubjectIdx, :) = max(abs(forceData - Fref));
    
end



%% Sort the steps per condition
FzList = [10, 30, 60];
FxList = [-3, -1.5, 0, 1.5, 3, 6];

forceAverages = [];

for SubjectIdx = [1, 2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 15, 17, 19]
    F = allData{SubjectIdx}.stepData{1}.forceMean;
    FAll = F;
    allData{SubjectIdx}.forceAverages = [];
    allData{SubjectIdx}.stepDataOrdered = [];
    
    
    for stepIdx = 2:length(allData{SubjectIdx}.stepData)
        FAll = [FAll; allData{SubjectIdx}.stepData{stepIdx}.forceMean];
        if (allData{SubjectIdx}.stepData{stepIdx}.forceMean(1) ~= allData{SubjectIdx}.stepData{stepIdx-1}.forceMean(1))
            F = [F; allData{SubjectIdx}.stepData{stepIdx}.forceMean];
        end
    end
    
    % Calculate force averages per condition
    for ConditionIdx = 1:size(ConditionChangeIdxs, 2)
        if ConditionChangeIdxs(SubjectIdx, ConditionIdx) ~= 0
            forceAveragesThisCondition = [];
            endIdx = ConditionChangeIdxs(SubjectIdx, ConditionIdx+1);
            if endIdx == 0
                endIdx = length(allData{SubjectIdx}.stepData);
            end
            for stepIdx = ConditionChangeIdxs(SubjectIdx, ConditionIdx):endIdx
                forceAveragesThisCondition(end+1,:) = mean(allData{SubjectIdx}.stepData{stepIdx}.force);
            end
            allData{SubjectIdx}.forceAverages(end+1,:) = mean(forceAveragesThisCondition);
        end
    end
    
    errorFz = abs(FzList*weights(SubjectIdx)*9.81/100 - allData{SubjectIdx}.forceAverages(:,3));
    errorFx = abs(FxList*weights(SubjectIdx)*9.81/100 - allData{SubjectIdx}.forceAverages(:,1));
    FzIdx = zeros(size(allData{SubjectIdx}.forceAverages, 1), 1);
    FxIdx = zeros(size(allData{SubjectIdx}.forceAverages, 1), 1);
    
    for ConditionIdx = 1:size(allData{SubjectIdx}.forceAverages, 1)
        % Determine vertical force per condition
        FzIdx(ConditionIdx) = find(errorFz(ConditionIdx, :)==min(errorFz(ConditionIdx,:)));
        FxID = find(FxList == HorForceIDs(SubjectIdx, ConditionIdx));
        if length(FxID) == 1
            FxIdx(ConditionIdx) = find(FxList == HorForceIDs(SubjectIdx, ConditionIdx));
        end
        
        % Put data in struct
        startIdx = ConditionChangeIdxs(SubjectIdx, ConditionIdx);
        endIdx = ConditionChangeIdxs(SubjectIdx, ConditionIdx+1);
        if endIdx == 0
            endIdx = length(allData{SubjectIdx}.stepData);
        end
        if FxIdx(ConditionIdx) > 0
            allData{SubjectIdx}.stepDataOrdered{FzIdx(ConditionIdx), FxIdx(ConditionIdx)}.steps = [];
            if endIdx-startIdx < 10
                SubjectIdx, ConditionIdx, endIdx-startIdx
            end
            for stepIdx = startIdx:endIdx
                allData{SubjectIdx}.stepDataOrdered{FzIdx(ConditionIdx), FxIdx(ConditionIdx)}.steps{end+1}.time = allData{SubjectIdx}.stepData{stepIdx}.time;
                allData{SubjectIdx}.stepDataOrdered{FzIdx(ConditionIdx), FxIdx(ConditionIdx)}.steps{end}.pos = allData{SubjectIdx}.stepData{stepIdx}.pos;
                allData{SubjectIdx}.stepDataOrdered{FzIdx(ConditionIdx), FxIdx(ConditionIdx)}.steps{end}.force = allData{SubjectIdx}.stepData{stepIdx}.force;
            end
        end
    end
    
    
    
end






%% outcome measures

forceOutcomeData = [];


for SubjectIdx = [1, 2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 15, 17, 19]
    for FzIdx = 1:length(FzList)
        forceOutcomeData{SubjectIdx, FzIdx}.bias = zeros(length(FxList), 3);
        forceOutcomeData{SubjectIdx, FzIdx}.sigma = zeros(length(FxList), 3);
        forceOutcomeData{SubjectIdx, FzIdx}.maxError = zeros(length(FxList), 3);
        
        for FxIdx = 1:length(FxList)
            forceCondition = [];
            forceRef = [FxList(FxIdx), 0, FzList(FzIdx)]/100*9.81*weights(SubjectIdx);
            if FxIdx <= size(allData{SubjectIdx}.stepDataOrdered, 2)
                if length(allData{SubjectIdx}.stepDataOrdered{FzIdx, FxIdx}) > 0
                    for stepIdx = 1:length(allData{SubjectIdx}.stepDataOrdered{FzIdx, FxIdx}.steps)
                        forceCondition = [forceCondition; allData{SubjectIdx}.stepDataOrdered{FzIdx, FxIdx}.steps{stepIdx}.force];
                    end
                    if length(forceCondition) > 0
                        forceOutcomeData{SubjectIdx, FzIdx}.bias(FxIdx, :) = mean(forceCondition - forceRef);
                        forceOutcomeData{SubjectIdx, FzIdx}.sigma(FxIdx, :) = std(forceCondition - forceRef);
                        forceOutcomeData{SubjectIdx, FzIdx}.maxError(FxIdx, :) = max(abs(forceCondition - forceRef));
                    end
                end
            end
        end
    end
    
end



%% Plot some stuff for subject 19




time30Sampled = time30Sampled - time30Sampled(1);


figure

plot(timeData, forceData)






