load('subject19.mat')





startPos = [2.17, -0.1];
radius = 0.2;

time = time_ms / 1000;
force = [forceX_mN, forceY_mN, forceZ_mN] / 1000;
position = [posX_mm, posY_mm, posZ_mm] / 1000;
velocity = gradient(position')'./gradient(time);

[B,A] = butter(1,0.01);
velocity = filtfilt(B, A, velocity);



start10 = 1017000;
end10 = 1057710;

force10 = force(start10:end10,:);
position10 = position(start10:end10,:);
time10 = (time_ms(start10:end10) - time_ms(start10)) / 1000;
velocity10 = velocity(start10:end10,:);

standStillIdx10 = sum((position10(:,1:2) - startPos).^2, 2) < radius^2;
force10(standStillIdx10, :) = [];
position10(standStillIdx10, :) = [];
time10(standStillIdx10, :) = [];
velocity10(standStillIdx10, :) = [];

plot(velocity10, force10)

speed10 = sqrt (sum(velocity10'.^2))';



start30 = 1065000;
end30 = 1099000;

force30 = force(start30:end30,:);
position30 = position(start30:end30,:);
time30 = (time_ms(start30:end30) - time_ms(start30)) / 1000;
velocity30 = velocity(start30:end30,:);


standStillIdx30 = sum((position30(:,1:2) - startPos).^2, 2) < radius^2;
force30(standStillIdx30, :) = [];
position30(standStillIdx30, :) = [];
time30(standStillIdx30, :) = [];
velocity30(standStillIdx30, :) = [];

figure
plot(velocity30, force30)

speed30 = sqrt (sum(velocity30'.^2))';



start60 = 1102000;
end60 = 1139000;


force60 = force(start60:end60,:);
position60 = position(start60:end60,:);
time60 = (time_ms(start60:end60) - time_ms(start60)) / 1000;
velocity60 = velocity(start60:end60,:);



standStillIdx60 = sum((position60(:,1:2) - startPos).^2, 2) < radius^2;
force60(standStillIdx60, :) = [];
position60(standStillIdx60, :) = [];
time60(standStillIdx60, :) = [];
velocity60(standStillIdx60, :) = [];

figure
plot(velocity60, force60)

speed60 = sqrt (sum(velocity60'.^2))';



% Octave stuff (untested in MATLAB)
P = polyfit(velocity10, force10,1);
[p, e_var, r, p_var, fit_var] = LinearRegression (velocity10, force10);


