function [ timeData, posData, forceData, stepData, trialData] = extractSteps( time30Sampled, pos30Sampled, force30Sampled, weight)

FzList = [10, 30, 60];
% stepIdx
stepData = [];
trialData = [];

startPos = 3.5;
endPos = 6.5;

maxTrialLength = 10;
numberOfSteps = 4;
minimumStepDuration = 0.5;


% analyse data
startWalkingIdxs = [];
endWalkingIdxs = [];



for Idx = length(time30Sampled):-1:2
    if length(startWalkingIdxs) == length(endWalkingIdxs)
        if (pos30Sampled(Idx, 1) > endPos && pos30Sampled(Idx-1, 1) <= endPos)
            endWalkingIdxs(end+1) = Idx;
        end
    else
        if (pos30Sampled(Idx, 1) > endPos && pos30Sampled(Idx-1, 1) <= endPos)
            endWalkingIdxs(end) = Idx;
        end
        if (pos30Sampled(Idx, 1) < startPos)
            startWalkingIdxs(end+1) = Idx;
        end
    end
end

endWalkingIdxs = endWalkingIdxs(1:length(startWalkingIdxs));
endWalkingIdxs = endWalkingIdxs(end:-1:1);
startWalkingIdxs = startWalkingIdxs(end:-1:1);

posData = [];
forceData = [];
timeData = [];
timeStart = 0;

for Idx = 1:length(startWalkingIdxs)
    % Extract 4 steps
    timeDataRun = time30Sampled(startWalkingIdxs(Idx):endWalkingIdxs(Idx)) - time30Sampled(startWalkingIdxs(Idx)) + timeStart;
    posDataRun = pos30Sampled(startWalkingIdxs(Idx):endWalkingIdxs(Idx), :);
    forceDataRun = force30Sampled(startWalkingIdxs(Idx):endWalkingIdxs(Idx), :);
    
    trialData{end+1}.time = timeDataRun - timeDataRun(1);
    trialData{end}.pos = posDataRun;
    trialData{end}.force = forceDataRun;
    
    
    stepIdxs = [];
    
    for Idx2 = length(timeDataRun)-round(0.5*minimumStepDuration/0.01):-1:1+round(0.5*minimumStepDuration/0.01)
        if sum(posDataRun(Idx2, 3) < posDataRun(Idx2-round(0.5*minimumStepDuration/0.01):Idx2+round(0.5*minimumStepDuration/0.01), 3)) == 0
            if length(stepIdxs) > 0
                if abs(stepIdxs(1) - Idx2) > round(0.5*minimumStepDuration/0.01)
                    stepIdxs = [Idx2; stepIdxs];
                end
            else
                stepIdxs = [Idx2; stepIdxs];
            end
            
        end
    end
    
    % Save steps
    F = mean(forceDataRun);
    
    for StepIdx = max(length(stepIdxs)-numberOfSteps, 1):length(stepIdxs)-1
        stepData{end+1}.time = timeDataRun(stepIdxs(StepIdx):stepIdxs(StepIdx+1)) - timeDataRun(stepIdxs(StepIdx));
        stepData{end}.pos = posDataRun(stepIdxs(StepIdx):stepIdxs(StepIdx+1), :);
        stepData{end}.force = forceDataRun(stepIdxs(StepIdx):stepIdxs(StepIdx+1), :);
        stepData{end}.forceMean = F;
    end
    
    
    
    % Save concatenated data
    
    stepIdxs = stepIdxs(max(end-numberOfSteps, 1)):stepIdxs(end);
    
    
    FzError = abs(FzList*weight/100*9.81 - F(3));
    if FzError(2) == min(FzError)
        timeData = [timeData; timeDataRun(stepIdxs) - timeDataRun(stepIdxs(1)) + timeStart];
        posData = [posData; posDataRun(stepIdxs, :)];
        forceData = [forceData; forceDataRun(stepIdxs, :)];
        timeStart = timeData(end) + 0.01;
    end
    
    
    
end








end

