
clc
clear all
close all

load('RYSENData.mat')

verticalForce = [10, 30, 60];
horizontalForce = [-3, -1.5, 0, 1.5, 3, 6];

subjectsIDs = [1, 2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 15, 17, 19];

averageVelocities = zeros(3,6);
numberOfSubjectsThisCondition = zeros(3,6);


for SubjectIdx = subjectsIDs
    for unloadingIdx = 1:3
        for horizontalIdx = 1:6
            if size(dataPerSubject{SubjectIdx}.trialDataPerCondition, 2) >= horizontalIdx
                if length(dataPerSubject{SubjectIdx}.trialDataPerCondition{unloadingIdx,horizontalIdx}) > 0
                    averageVelocity = 0;
                    numberOfTrials = length(dataPerSubject{SubjectIdx}.trialDataPerCondition{unloadingIdx,horizontalIdx}.trials);
                    for trialIdx = 1:numberOfTrials
                        time = dataPerSubject{SubjectIdx}.trialDataPerCondition{unloadingIdx,horizontalIdx}.trials{trialIdx}.time;
                        pos = dataPerSubject{SubjectIdx}.trialDataPerCondition{unloadingIdx,horizontalIdx}.trials{trialIdx}.pos;
                        averageVelocity = averageVelocity + (pos(end,1)-pos(1,1)) / (time(end) - time(1)) / numberOfTrials;
                    end
                    
                    dataPerSubject{SubjectIdx}.averageVelocities(unloadingIdx, horizontalIdx) = averageVelocity;
                    
                    nrOfSubjs = numberOfSubjectsThisCondition(unloadingIdx, horizontalIdx);
                    avgVel = averageVelocities(unloadingIdx, horizontalIdx);
                    nrOfSubjs = nrOfSubjs + 1;
                    avgVel = avgVel * (nrOfSubjs-1)/nrOfSubjs + averageVelocity / nrOfSubjs;
                    
                    
                    numberOfSubjectsThisCondition(unloadingIdx, horizontalIdx) = nrOfSubjs;
                    averageVelocities(unloadingIdx, horizontalIdx) = avgVel;
                end
            end
        end
    end
end

tenPercConditionData = 0;
hypotheses = nan(3,6);
probabilities = nan(3,6);
figure;


for unloadingIdx = 1:3
    subplot(1,3,unloadingIdx);
    switch unloadingIdx
        case 1
            ylabel('Velocity (m/s)');
            title('10%');
            hold on
        case 2
            title('30%');
            hold on
        case 3
            title('60%');
            hold on
    end
            
    
    dataThisFz = [];
    labelsThisFz = [];
    for horizontalIdx = 1:6
        subjectVelocities = [];
        for SubjectIdx = subjectsIDs
            if size(dataPerSubject{SubjectIdx}.averageVelocities, 2) >= horizontalIdx
                if dataPerSubject{SubjectIdx}.averageVelocities(unloadingIdx, horizontalIdx) > 0
                    subjectVelocities = [subjectVelocities; dataPerSubject{SubjectIdx}.averageVelocities(unloadingIdx, horizontalIdx)];
                end
            end
        end
        labels = horizontalForce(horizontalIdx) * ones(length(subjectVelocities), 1);
        dataThisFz = [dataThisFz; subjectVelocities];
        labelsThisFz = [labelsThisFz; labels];
        
        if (unloadingIdx == 1) && (horizontalIdx == 3)
            tenPercConditionData = subjectVelocities;
        elseif (unloadingIdx > 1) && ((unloadingIdx == 3) || (horizontalIdx < 6))
            if 0
                [h,p] = ttest(tenPercConditionData, subjectVelocities);
            else
                [h,p] = ttest2(tenPercConditionData, subjectVelocities);
            end
            hypotheses(unloadingIdx, horizontalIdx) = h;
            probabilities(unloadingIdx, horizontalIdx) = p;
        end
        
    end
    boxplot(dataThisFz, labelsThisFz)
    ylim([0,1.5])
    
    
end



hypotheses
probabilities




