
%% Because we suspected a miscalibration of the RYSEN, we performed some additional experiments to correct for this in the measurements
%% Center, 30 kg


% We hang an additional weight of 20kg on the RYSEN.
% Parameters of the RYSEN
w=2.6;
h=3.3;

% Position of CPS (y=0)
z=2.01;

% Increase in force sensor
F=73;

% Resulting increase in force
Fz = 4*F*(h-z)/sqrt((h-z)^2 + 0.5^2 + (w/2)^2)

% This confirms that the gain of the force sensors is correct

%%

% We hang a total of 30kg on the RYSEN

% Parameters of the config file of the RYSEN:
w=2.7;
h=3.3;

% Position of the CPS according to RYSEN:
z=2.08;

% Force measurement:
F=115;

% Force that the RYSEN should calculate
Fz1 = 4*F*(h-z)/sqrt((h-z)^2 + 0.5^2 + (w/2)^2) - 3.4*9.81

% This corresponds to the value read in TwinCAT. This confirms the
% kinematics.


%%

% We calculate what the RYSEN with correc calibration would have measured

% Actual RYSEN parameters
w=2.6;
h=3.3;

% Actual CPS height
z=2.01;

% Miscalibration in force sensor offset
F=115+4;

% This is the correct force (10N of harness excluded)
Fz2 = 4*F*(h-z)/sqrt((h-z)^2 + 0.5^2 + (w/2)^2) - 2.4*9.81

% This corresponds to the actual weight.


%% Calculate gain

additionalGain30 = Fz2 / Fz1






%% 15 kg


% We hang a weight of 15kg on the RYSEN.
% Parameters of the RYSEN
w=2.7;
h=3.3;

% Position of CPS (y=0)
z=2.06;

% Increase in force sensor
F=60;

% Resulting increase in force
Fz1 = 4*F*(h-z)/sqrt((h-z)^2 + 0.5^2 + (w/2)^2) - 3.4*9.81




%% 10 kg corrected


% We hang a weight of 10kg on the RYSEN.
% Parameters of the RYSEN
w=2.6;
h=3.3;

% Position of CPS (y=0)
z=1.98;

% Increase in force sensor
F=60;

% Resulting increase in force
Fz2 = 4*F*(h-z)/sqrt((h-z)^2 + 0.5^2 + (w/2)^2) - 1.0*9.81

% This confirms that the gain of the force sensors is correct


additionalGain15 = Fz2/Fz1



