clc
clear all
close all

misCalibrationTest;

%% Disturbance rejection

mass = zeros(1,3);
damping = zeros(1,3);
stiffness = zeros(1,3);
measurementError = zeros(1,3);
trackingError = zeros(1,3);
overallError = zeros(1,3);
overallRMS = zeros(1,3);

dataFileNames = {'DxC30A50-10', ...
    'DyC30A50-10', ...
    'DzC30A50-10', ...
    };



for fileIdx = 1:3
    fitDisturbanceRejection;
    load(dataFileNames{fileIdx})
    mass(fileIdx) = round(m, 1);
    damping(fileIdx) = round(d);
    stiffness(fileIdx) = round(k);
    trackingError(fileIdx) = round(mean(outComeData.OffsetRYSEN(:,fileIdx)));
    overallError(fileIdx) = round(mean(outComeData.OffsetLoadCell(:,fileIdx)));
    measurementError(fileIdx) = round(trackingError(fileIdx) - overallError(fileIdx));
end

ImpedanceExperiments.disturbanceRejection.mass = table(mass);
ImpedanceExperiments.disturbanceRejection.damping = table(damping);
ImpedanceExperiments.disturbanceRejection.stiffness = table(stiffness);
ImpedanceExperiments.disturbanceRejection.measurementError = table(measurementError);
ImpedanceExperiments.disturbanceRejection.trackingError = table(trackingError);
ImpedanceExperiments.disturbanceRejection.overallError = table(overallError);


%% Force tracking

misCalibrationTest;

dataFileNames = {'FxC30', ...
    'FyC30', ...
    'FzC30'...
    };

% parseCSVs;        % only do this when not pocessing the .mat files
fitForceTracking;
analyzeForceTracking;

measurementError = zeros(1,3);
trackingError = zeros(1,3);
overallError = zeros(1,3);
bandwidthData = zeros(1,3);

for fileIdx = 1:3
    load(dataFileNames{fileIdx});
    gain = outComeData.ALoadCell(:,fileIdx) ./ outComeData.ADesired(:,fileIdx);
    bandwidthData(fileIdx) = round(interp1(gain, f, 0.5), 1);
    trackingError(fileIdx) = round(mean(outComeData.OffsetRYSEN(fileIdx, fileIdx)));
    overallError(fileIdx) = round(mean(outComeData.OffsetLoadCell(fileIdx,fileIdx)));
end
trackingError(3) = trackingError(3) - 301;
overallError(3) = overallError(3) - 301;
measurementError = trackingError - overallError;


ImpedanceExperiments.forceTracking.bandwidthData = table(bandwidthData);
ImpedanceExperiments.forceTracking.measurementError = table(measurementError);
ImpedanceExperiments.forceTracking.trackingError = table(trackingError);
ImpedanceExperiments.forceTracking.overallError = table(overallError);

save('..\paperOutcomeData\ImpedanceExperiments.mat', 'ImpedanceExperiments')

