
dataFileNames = {'FxC30', ...
    'FyC30', ...
    'FzC30'...%, ...
%     'FxE30', ...
%     'FyE30', ...
%     'FzE30', ...
%     'FxL30', ...
%     'FyL30', ...
%     'FzL30', ...
%     'FxC15', ...
%     'FyC15', ...
%     'FzC15'
    };


% Define desired force profile
numberOfCycles = 12;


for fileIdx = 1:length(dataFileNames)
    
    dataFileName = dataFileNames{fileIdx};
    
    % Load data file
    load([dataFileName, '.mat'])
    
    
    positions = [length(find(dataFileName=='C')); length(find(dataFileName=='E')); length(find(dataFileName=='L'))];
    
    unloading = [length(find(dataFileName=='3')); length(find(dataFileName=='1'))];
    
    if unloading(1) == 1
        additionalGain = additionalGain30;
    else
        additionalGain = additionalGain15;
    end
    
    
    directions = [length(find(dataFileName=='x')); length(find(dataFileName=='y')); length(find(dataFileName=='z'))];
    
    
    
    
    
    A1 = 36.79 * additionalGain;
    f = (0.4:0.2:3.0)';
    Axy = A1*f(1) ./ f;
    
    A1 = 99.3 * additionalGain;
    f = (0.4:0.2:3.0)';
    Az = A1*f(1) ./ f;
    
    A = [Axy, Axy, Az];
    
    % Give easier names
    time = scopeData.time;
    CPSForce = scopeData.arrCPSForce * additionalGain;
    desiredForce = scopeData.arrDesiredForce * additionalGain;
    desiredForceExercise = scopeData.m_desForce_exercise * additionalGain;
    measuredForce = scopeData.arrForceTorque(:,1:3);
    performanceTestActive = scopeData.bPerformanceTestActive;
    desiredMotorPositon = scopeData.desiredPosition;
    currentMotorPosition = scopeData.currentMotorPos;
    
    
    %% Put data in cell array
    timeData = [];
    CPSForceData = [];
    desiredForceData = [];
    desiredForceExerciseData = [];
    measuredForceData = [];
    performanceTestActiveData = [];
    desiredMotorPositonData = [];
    currentMotorPositionData = [];
    
    testStartIdx = find(performanceTestActive==1, 1) - 100;
    testEndIdx = testStartIdx;
    
    for conditionIdx = 1:length(f)
        zeroCrossings = 0;
        while zeroCrossings < numberOfCycles
            if zeroCrossings < 2
                testStartIdx = testStartIdx + 1;
            end
            testEndIdx = testEndIdx + 1;
            if (desiredForce(testEndIdx, directions == 1) - desiredForce(1, directions == 1) < 0) && (desiredForce(testEndIdx+1, directions == 1) - desiredForce(1, directions == 1) >= 0)
                zeroCrossings = zeroCrossings + 1;
            end
        end
        
        timeData{conditionIdx} = time(testStartIdx:testEndIdx) - time(testStartIdx);
        CPSForceData{conditionIdx} = CPSForce(testStartIdx:testEndIdx, :);
        desiredForceData{conditionIdx} = desiredForce(testStartIdx:testEndIdx, :);
        desiredForceExerciseData{conditionIdx} = desiredForceExercise(testStartIdx:testEndIdx, :);
        measuredForceData{conditionIdx} = measuredForce(testStartIdx:testEndIdx, :);
        performanceTestActiveData{conditionIdx} = performanceTestActive(testStartIdx:testEndIdx);
        desiredMotorPositonData{conditionIdx} = desiredMotorPositon(testStartIdx:testEndIdx);
        currentMotorPositionData{conditionIdx} = currentMotorPosition(testStartIdx:testEndIdx);
        
        testStartIdx = testEndIdx+1;
    end
    
    conditionData.timeData = timeData;
    conditionData.CPSForceData = CPSForceData;
    conditionData.desiredForceData = desiredForceData;
    conditionData.desiredForceExerciseData = desiredForceExerciseData;
    conditionData.measuredForceData = measuredForceData;
    conditionData.performanceTestActiveData = performanceTestActiveData;
    conditionData.desiredMotorPositonData = desiredMotorPositonData;
    conditionData.currentMotorPositionData = currentMotorPositionData;
    
    
    
    
    %% Fit sines to data
    
    ADesired = A.*directions';
    ARYSEN = zeros(length(f), 3);
    ALoadCell = zeros(length(f), 3);
    AMeasurement = zeros(length(f), 3);
    
    PhaseDesired = zeros(length(f), 3);
    PhaseRYSEN = zeros(length(f), 3);
    PhaseLoadCell = zeros(length(f), 3);
    PhaseMeasurement = zeros(length(f), 3);
    
    OffsetDesired = zeros(length(f), 3);
    OffsetRYSEN = zeros(length(f), 3);
    OffsetLoadCell = zeros(length(f), 3);
    OffsetMeasurement = zeros(length(f), 3);
    
    
    figure(1)
    
    for conditionIdx = 1:length(f)
        params0 = [ADesired(conditionIdx,:), zeros(1, 5), [300, 150] * unloading];
        
        if conditionIdx > 1
            params0(4:9) = [PhaseRYSEN(conditionIdx-1, :), OffsetRYSEN(conditionIdx-1, :)];
        end
        
        % RYSEN data fit
        optimfun = @(params) calculateFit(params, timeData{conditionIdx}, CPSForceData{conditionIdx}, f(conditionIdx));
        
        params = fmincon(optimfun, params0, [],[], [], [], [0 0 0 -270 -270 -270 -1000 -1000 -1000], [1000 1000 1000 90 90 90 1000 1000 1000]);
        
        ARYSEN(conditionIdx, :) = params(1:3);
        PhaseRYSEN(conditionIdx, :) = params(4:6);
        OffsetRYSEN(conditionIdx, :) = params(7:9);
        
        dataFitRYSEN = OffsetRYSEN(conditionIdx,:) + ARYSEN(conditionIdx,:).*sin(2*pi*f(conditionIdx)*timeData{conditionIdx} + PhaseRYSEN(conditionIdx,:) / 180*pi);
        
        clf
        subplot(3,1,1)
        plot(timeData{conditionIdx}, [CPSForceData{conditionIdx}, dataFitRYSEN])
        
        
        % LoadCell data fit
        if conditionIdx > 1
            params0(4:9) = [PhaseLoadCell(conditionIdx-1, :), OffsetLoadCell(conditionIdx-1, :)];
        end
        
        optimfun = @(params) calculateFit(params, timeData{conditionIdx}, measuredForceData{conditionIdx}, f(conditionIdx));
        
        params = fmincon(optimfun, params0, [],[], [], [], [0 0 0 -270 -270 -270 -1000 -1000 -1000], [1000 1000 1000 90 90 90 1000 1000 1000]);
        
        ALoadCell(conditionIdx, :) = params(1:3);
        PhaseLoadCell(conditionIdx, :) = params(4:6);
        OffsetLoadCell(conditionIdx, :) = params(7:9);
        
        dataFitLoadcell = OffsetLoadCell(conditionIdx,:) + ALoadCell(conditionIdx,:).*sin(2*pi*f(conditionIdx)*timeData{conditionIdx} + PhaseLoadCell(conditionIdx,:) / 180*pi);
        
        subplot(3,1,2)
        plot(timeData{conditionIdx}, [measuredForceData{conditionIdx}, dataFitLoadcell])
        
        
        
        % Measurement error data fit
        if conditionIdx > 1
            params0(4:9) = [PhaseMeasurement(conditionIdx-1, :), OffsetMeasurement(conditionIdx-1, :)];
        end
        
        optimfun = @(params) calculateFit(params, timeData{conditionIdx}, measuredForceData{conditionIdx} - CPSForceData{conditionIdx}, f(conditionIdx));
        
        params = fmincon(optimfun, params0, [],[], [], [], [0 0 0 -270 -270 -270 -1000 -1000 -1000], [1000 1000 1000 90 90 90 1000 1000 1000]);
        
        AMeasurement(conditionIdx, :) = params(1:3);
        PhaseMeasurement(conditionIdx, :) = params(4:6);
        OffsetMeasurement(conditionIdx, :) = params(7:9);
        
        dataFitModel = OffsetMeasurement(conditionIdx,:) + AMeasurement(conditionIdx,:).*sin(2*pi*f(conditionIdx)*timeData{conditionIdx} + PhaseMeasurement(conditionIdx,:) / 180*pi);
        
        subplot(3,1,3)
        plot(timeData{conditionIdx}, [measuredForceData{conditionIdx} - CPSForceData{conditionIdx}, dataFitModel])
        
    end
    
    outComeData.ADesired = ADesired;
    outComeData.ARYSEN = ARYSEN;
    outComeData.ALoadCell = ALoadCell;
    outComeData.AMeasurement = AMeasurement;
    
    outComeData.PhaseDesired = PhaseDesired;
    outComeData.PhaseRYSEN = PhaseRYSEN;
    outComeData.PhaseLoadCell = PhaseLoadCell;
    outComeData.PhaseMeasurement = PhaseMeasurement;
    
    outComeData.OffsetDesired = OffsetDesired;
    outComeData.OffsetRYSEN = OffsetRYSEN;
    outComeData.OffsetLoadCell = OffsetLoadCell;
    outComeData.OffsetMeasurement = OffsetMeasurement;
    
    save(dataFileName, 'scopeData', 'outComeData', 'conditionData', 'f', 'directions');
    
    
end



%% Load specific condition
fileIdx = 3;

dataFileName = dataFileNames{fileIdx};

% Load data file
load([dataFileName, '.mat'])

directions = [length(find(dataFileName=='x')); length(find(dataFileName=='y')); length(find(dataFileName=='z'))];




%% Analyze measurement error, tracking error and controller error
measurementErrorRMS = zeros(length(f), 3);
trackingErrorRMS = zeros(length(f), 3);
controllerErrorRMS = zeros(length(f), 3);

measurementErrorMAX = zeros(length(f), 3);
trackingErrorMAX = zeros(length(f), 3);
controllerErrorMAX = zeros(length(f), 3);


for conditionIdx = 1:length(f)
    measurementErrorRMS(conditionIdx, :) = rms(measuredForceData{conditionIdx} - CPSForceData{conditionIdx});
    trackingErrorRMS(conditionIdx, :) = rms(desiredForceData{conditionIdx} - measuredForceData{conditionIdx});
    controllerErrorRMS(conditionIdx, :) = rms(desiredForceData{conditionIdx} - CPSForceData{conditionIdx});

    measurementErrorMAX(conditionIdx, :) = max(abs(measuredForceData{conditionIdx} - CPSForceData{conditionIdx}));
    trackingErrorMAX(conditionIdx, :) = max(abs(desiredForceData{conditionIdx} - measuredForceData{conditionIdx}));
    controllerErrorMAX(conditionIdx, :) = max(abs(desiredForceData{conditionIdx} - CPSForceData{conditionIdx}));
end


%% Plot outcome data




ADesired = outComeData.ADesired;
ARYSEN = outComeData.ARYSEN;
ALoadCell = outComeData.ALoadCell;

PhaseDesired = outComeData.PhaseDesired;
PhaseRYSEN = outComeData.PhaseRYSEN;
PhaseLoadCell = outComeData.PhaseLoadCell;

OffsetDesired = outComeData.OffsetDesired;
OffsetRYSEN = outComeData.OffsetRYSEN;
OffsetLoadCell = outComeData.OffsetLoadCell;



figure
subplot(3,1,1)
plot(f, ARYSEN(:,directions==1)./ADesired(:,directions==1))
hold on
plot(f, ALoadCell(:,directions==1)./ADesired(:,directions==1))
set(gca, 'YScale', 'log')
set(gca, 'XScale', 'log')

subplot(3,1,2)
plot(f, PhaseRYSEN(:,directions==1))
hold on
plot(f, PhaseLoadCell(:,directions==1))
set(gca, 'XScale', 'log')

subplot(3,1,3)
plot(f, OffsetRYSEN(:,directions==1))
hold on
plot(f, OffsetLoadCell(:,directions==1))
set(gca, 'XScale', 'log')





