


dataFileNames = {'DxC30A50-10', ...
    'DyC30A50-10', ...
    'DzC30A50-10', ...
    };


% Define desired force profile
numberOfCycles = 15;
skipCycles = 5;


dataFileName = dataFileNames{fileIdx};

% Load data file
load([dataFileName, '.mat'])


directions = [length(find(dataFileName=='x')); length(find(dataFileName=='y')); length(find(dataFileName=='z'))];

positions = [length(find(dataFileName=='C')); length(find(dataFileName=='E')); length(find(dataFileName=='L'))];

unloading = [length(find(dataFileName=='3')); 1-length(find(dataFileName=='3'))];


if unloading(1) == 1
    additionalGain = additionalGain30;
else
    additionalGain = additionalGain15;
end

    

Axyz = (0.05:-0.005:0.01)';
f0 = 0.45;
f = f0*Axyz(1) ./ Axyz;

A = [Axyz, Axyz, Axyz];

AVel = 2*pi*f(1).*A(1);


% Give easier names

% Transform
if fileIdx == 1
    T=[0,0,-1;0,1,0;1,0,0];
    time = scopeData.time(20000:end);
    CPSForce = scopeData.arrCPSForce(20000:end,:)*additionalGain;
    desiredForce = scopeData.arrDesiredForce(20000:end,:)*additionalGain;
    desiredForceExercise = scopeData.m_desForce_exercise(20000:end,:)*additionalGain;
    measuredForce = (T*scopeData.arrForceTorque((20000:end),1:3,:)')';
    performanceTestActive = scopeData.bPerformanceTestActive(20000:end,:);
    desiredMotorPositon = scopeData.desiredPosition(20000:end,:);
    currentMotorPosition = scopeData.currentMotorPos;
    
end

if fileIdx == 2
    T=[0,1,0;0,0,1;1,0,0];
    time = scopeData.time;
    CPSForce = scopeData.arrCPSForce*additionalGain;
    desiredForce = scopeData.arrDesiredForce*additionalGain;
    desiredForceExercise = scopeData.m_desForce_exercise*additionalGain;
    measuredForce = (T*scopeData.arrForceTorque(:,1:3,:)')';
    performanceTestActive = scopeData.bPerformanceTestActive;
    desiredMotorPositon = scopeData.desiredPosition;
    currentMotorPosition = scopeData.currentMotorPos;
    
end

if fileIdx == 3
    time = scopeData.time;
    CPSForce = scopeData.arrCPSForce*additionalGain;
    desiredForce = scopeData.arrDesiredForce*additionalGain;
    desiredForceExercise = scopeData.m_desForce_exercise*additionalGain;
    measuredForce = scopeData.arrForceTorque(:,1:3);
    performanceTestActive = scopeData.bPerformanceTestActive;
    desiredMotorPositon = scopeData.desiredPosition;
    currentMotorPosition = scopeData.currentMotorPos;
    
end



%% Put data in cell array
timeData = [];
CPSForceData = [];
desiredForceData = [];
desiredForceExerciseData = [];
measuredForceData = [];
performanceTestActiveData = [];
desiredMotorPositonData = [];
currentMotorPositionData = [];
CPSPositionData = [];
CPSVelocityData = [];
CPSAccelerationData = [];


conditionIdx = 0;
testCanStart = 0;
for Idx = 1:length(time)
    if testCanStart > 1000 && performanceTestActive(Idx)
        conditionIdx = conditionIdx + 1;
        testStartIdx = Idx - 100 + round(1000*(skipCycles / f(conditionIdx))); % skip 5 cycles
        testEndIdx = testStartIdx + round(1000*((numberOfCycles-skipCycles) / f(conditionIdx)));

       
        % Change sign because of orrientation of system
        signOfSine = 1;
        if fileIdx == 1
            signOfSine = -1;
        end

        
        timeData{conditionIdx} = time(testStartIdx:testEndIdx) - time(testStartIdx);

        CPSPositionData{conditionIdx} = signOfSine*sin(2*pi*f(conditionIdx)*timeData{conditionIdx}) * (A(conditionIdx).*directions)';
        CPSVelocityData{conditionIdx} = signOfSine*cos(2*pi*f(conditionIdx)*timeData{conditionIdx}) * 2*pi*f(conditionIdx)*(A(conditionIdx).*directions)';
        CPSAccelerationData{conditionIdx} = signOfSine*-sin(2*pi*f(conditionIdx)*timeData{conditionIdx}) * (2*pi*f(conditionIdx))^2*(A(conditionIdx).*directions)';
        
        
        CPSForceData{conditionIdx} = CPSForce(testStartIdx:testEndIdx, :);
        desiredForceData{conditionIdx} = desiredForce(testStartIdx:testEndIdx, :);
        desiredForceExerciseData{conditionIdx} = desiredForceExercise(testStartIdx:testEndIdx, :);
        measuredForceData{conditionIdx} = measuredForce(testStartIdx:testEndIdx, :);% - directions'.*CPSAccelerationData{conditionIdx} * 0.5;   inertia compensation
        performanceTestActiveData{conditionIdx} = performanceTestActive(testStartIdx:testEndIdx);
        desiredMotorPositonData{conditionIdx} = desiredMotorPositon(testStartIdx:testEndIdx);
        currentMotorPositionData{conditionIdx} = currentMotorPosition(testStartIdx:testEndIdx);
        
        
        
    end
    
    
    
    if performanceTestActive(Idx)
        testCanStart = 0;
    else
        testCanStart = testCanStart + 1;
    end    
end


conditionData.timeData = timeData;
conditionData.CPSForceData = CPSForceData;
conditionData.desiredForceData = desiredForceData;
conditionData.desiredForceExerciseData = desiredForceExerciseData;
conditionData.measuredForceData = measuredForceData;
conditionData.performanceTestActiveData = performanceTestActiveData;
conditionData.desiredMotorPositonData = desiredMotorPositonData;
conditionData.currentMotorPositionData = currentMotorPositionData;
conditionData.CPSPositionData = CPSPositionData;
conditionData.CPSVelocityData = CPSVelocityData;
conditionData.CPSAccelerationData = CPSAccelerationData;




%% Fit sines to data

ADesired = zeros(length(f), 3);
ARYSEN = zeros(length(f), 3);
ALoadCell = zeros(length(f), 3);

PhaseDesired = zeros(length(f), 3);
PhaseRYSEN = zeros(length(f), 3);
PhaseLoadCell = zeros(length(f), 3);

OffsetDesired = zeros(length(f), 3);
OffsetRYSEN = zeros(length(f), 3);
OffsetLoadCell = zeros(length(f), 3);


figure(1)

for conditionIdx = 1:length(f)
    params0 = [ADesired(conditionIdx,:), [-90,-90,-90], zeros(1, 2), [300,150]*unloading];
    
    if conditionIdx > 1
        params0(4:9) = [PhaseRYSEN(conditionIdx-1, :), OffsetRYSEN(conditionIdx-1, :)];
    end
    
    % RYSEN data fit
    optimfun = @(params) calculateFit(params, timeData{conditionIdx}, CPSForceData{conditionIdx}.*[sign(CPSVelocityData{conditionIdx}(1)), 1, 1], f(conditionIdx));
    
    params = fmincon(optimfun, params0, [],[], [], [], [0 0 0 -270 -270 -270 -1000 -1000 -1000], [1000 1000 1000 90 90 90 1000 1000 1000]);
    
    ARYSEN(conditionIdx, :) = params(1:3);
    PhaseRYSEN(conditionIdx, :) = params(4:6);
    OffsetRYSEN(conditionIdx, :) = params(7:9);
    
    dataFitRYSEN = OffsetRYSEN(conditionIdx,:) + ARYSEN(conditionIdx,:).*sin(2*pi*f(conditionIdx)*timeData{conditionIdx} + PhaseRYSEN(conditionIdx,:) / 180*pi).*[sign(CPSVelocityData{conditionIdx}(1)), 1, 1];
    
    clf
    subplot(2,1,1)
    plot(timeData{conditionIdx}, [CPSForceData{conditionIdx}, dataFitRYSEN])
    
    
    % LoadCell data fit
    if conditionIdx > 1
        params0(4:9) = [PhaseLoadCell(conditionIdx-1, :), OffsetLoadCell(conditionIdx-1, :)];
    end
    
    optimfun = @(params) calculateFit(params, timeData{conditionIdx}, measuredForceData{conditionIdx}.*[sign(CPSVelocityData{conditionIdx}(1)), 1, 1], f(conditionIdx));
    
    params = fmincon(optimfun, params0, [],[], [], [], [0 0 0 -270 -270 -270 -1000 -1000 -1000], [1000 1000 1000 90 90 90 1000 1000 1000]);
    
    ALoadCell(conditionIdx, :) = params(1:3);
    PhaseLoadCell(conditionIdx, :) = params(4:6);
    OffsetLoadCell(conditionIdx, :) = params(7:9);
    
    dataFitLoadcell = (OffsetLoadCell(conditionIdx,:) + ALoadCell(conditionIdx,:).*sin(2*pi*f(conditionIdx)*timeData{conditionIdx} + PhaseLoadCell(conditionIdx,:) / 180*pi)).*[sign(CPSVelocityData{conditionIdx}(1)), 1, 1];
    
    subplot(2,1,2)
    plot(timeData{conditionIdx}, [measuredForceData{conditionIdx}, dataFitLoadcell])
    
    
end

if directions(3) == 1
    OffsetRYSEN = OffsetRYSEN - [300,150]*unloading;
    OffsetLoadCell = OffsetLoadCell - [300,150]*unloading;
end


outComeData.ADesired = ADesired;
outComeData.ARYSEN = ARYSEN;
outComeData.ALoadCell = ALoadCell;

outComeData.PhaseDesired = PhaseDesired;
outComeData.PhaseRYSEN = PhaseRYSEN;
outComeData.PhaseLoadCell = PhaseLoadCell;

outComeData.OffsetDesired = OffsetDesired;
outComeData.OffsetRYSEN = OffsetRYSEN;
outComeData.OffsetLoadCell = OffsetLoadCell;

outComeData.AVel = AVel;





%% Fit mass-spring-damper model

m = 5;
d = 50;
k = 0;

params0 = [m d k];

optimfun = @(params) calculateModelFitness( params, A(:,directions==1), f, ALoadCell(:,directions==1), PhaseLoadCell(:,directions==1));

params = fmincon(optimfun, params0, [], [], [], [], [0.001, 0, 0]);

optimfun(params);


m = params(1);
d = params(2);
k = params(3);

t = (0:0.001:2*pi);

fFine = linspace(f(1), f(end), 1000)';
AFine = f(1)*A(1, directions==1) ./ fFine;

x = AFine.*sin(t);
dx = 2*pi*fFine.*AFine.*cos(t);
ddx = -4*pi^2*fFine.^2.*AFine.*sin(t);


F = m*ddx + d*dx + k*x;

AModel = max(F, [], 2);
phiModel = zeros(length(fFine), 1);
for Idx = 1:length(fFine)
    phiModel(Idx) = -t(F(Idx,:)==AModel(Idx)) - pi/2;
    if phiModel(Idx) < -1.5*pi
        phiModel(Idx) = phiModel(Idx) + 2*pi;
    end
end



figure
subplot(2,1,1)
plot(fFine, AModel/AVel)
hold on
plot(f, ALoadCell(:,directions==1)/AVel)
set(gca, 'YScale', 'log')
set(gca, 'XScale', 'log')

subplot(2,1,2)
plot(fFine, phiModel * 180 / pi)
hold on
plot(f, PhaseLoadCell(:,directions==1))
set(gca, 'XScale', 'log')


outComeData.model.m = m;
outComeData.model.k = k;
outComeData.model.d = d;


save(dataFileName, 'scopeData', 'outComeData', 'conditionData', 'f', 'directions');


%% Load specific condition
% fileIdx = 3;

dataFileName = dataFileNames{fileIdx};

% Load data file
load([dataFileName, '.mat'])

directions = [length(find(dataFileName=='x')); length(find(dataFileName=='y')); length(find(dataFileName=='z'))];




%% Analyze measurement error, tracking error and controller error
measurementErrorRMS = zeros(length(f), 3);
trackingErrorRMS = zeros(length(f), 3);
controllerErrorRMS = zeros(length(f), 3);

measurementErrorMAX = zeros(length(f), 3);
trackingErrorMAX = zeros(length(f), 3);
controllerErrorMAX = zeros(length(f), 3);


for conditionIdx = 1:length(f)
    measurementErrorRMS(conditionIdx, :) = rms(measuredForceData{conditionIdx} - CPSForceData{conditionIdx});
    trackingErrorRMS(conditionIdx, :) = rms(desiredForceData{conditionIdx} - measuredForceData{conditionIdx});
    controllerErrorRMS(conditionIdx, :) = rms(desiredForceData{conditionIdx} - CPSForceData{conditionIdx});
    
    measurementErrorMAX(conditionIdx, :) = max(abs(measuredForceData{conditionIdx} - CPSForceData{conditionIdx}));
    trackingErrorMAX(conditionIdx, :) = max(abs(desiredForceData{conditionIdx} - measuredForceData{conditionIdx}));
    controllerErrorMAX(conditionIdx, :) = max(abs(desiredForceData{conditionIdx} - CPSForceData{conditionIdx}));
end


%% Plot outcome data




ADesired = outComeData.ADesired;
ARYSEN = outComeData.ARYSEN;
ALoadCell = outComeData.ALoadCell;

PhaseDesired = outComeData.PhaseDesired;
PhaseRYSEN = outComeData.PhaseRYSEN;
PhaseLoadCell = outComeData.PhaseLoadCell;

OffsetDesired = outComeData.OffsetDesired;
OffsetRYSEN = outComeData.OffsetRYSEN;
OffsetLoadCell = outComeData.OffsetLoadCell;



figure
subplot(3,1,1)
plot(f, ARYSEN(:,directions==1)/AVel)
hold on
plot(f, ALoadCell(:,directions==1)/AVel)
plot(fFine, AModel/AVel)
set(gca, 'XScale', 'log')
legend('RYSEN', 'Load cell', 'Model')
xlabel('Frequency (Hz)')
ylabel('Impedance (Ns/m)')
yLimits = get(gca,'YLim');
ylim([0, 100])
if directions(3) == 1
    ylim([0, 400])
end    

subplot(3,1,2)
plot(f, PhaseRYSEN(:,directions==1))
hold on
plot(f, PhaseLoadCell(:,directions==1))
plot(fFine, phiModel * 180 / pi)
set(gca, 'XScale', 'log')
xlabel('Frequency (Hz)')
ylabel('Phase (deg)')
ylim([-270, 0])

subplot(3,1,3)
plot(f, OffsetRYSEN(:,directions==1))
hold on
plot(f, OffsetLoadCell(:,directions==1))
set(gca, 'XScale', 'log')
xlabel('Frequency (Hz)')
ylabel('Offset (N)')
ylim([-50, 50])


saveas(gcf, ['figures\', dataFileName])


% 
% 
% figure
% plot(f, measurementErrorRMS(:,directions==1), 'b');
% hold on
% plot(f, trackingErrorRMS(:,directions==1), 'r');
% plot(f, controllerErrorRMS(:,directions==1), 'g');
% plot(f, measurementErrorMAX(:,directions==1), 'b-');
% plot(f, trackingErrorMAX(:,directions==1), 'r-');
% plot(f, controllerErrorMAX(:,directions==1), 'g-');
% 


