function fitness = calculateModelFitness( params, A, f, AF, phiF)

t = (0:0.001:2*pi);


m = params(1);
d = params(2);
k = params(3);

x = A.*sin(t);
dx = 2*pi*f.*A.*cos(t);
ddx = -4*pi^2*f.^2.*A.*sin(t);


F = m*ddx + d*dx + k*x;

AFexpected = max(F, [], 2);
phiFexpected = zeros(length(f), 1);
for Idx = 1:length(f)
    phiFexpected(Idx) = -t(F(Idx,:)==AFexpected(Idx)) - pi/2;
    if phiFexpected(Idx) < -1.5*pi
        phiFexpected(Idx) = phiFexpected(Idx) + pi*2;
    end
end



% AFexpected = -A.*sqrt((k-4*pi^2*f.^2*m).^2 + (2*pi*f*d).^2);
% phiFexpected = 180 / pi *atan(2*pi*f*d ./ (k-4*pi^2*f.^2*m));

fitness = norm(AFexpected-AF) + 0.01*norm(phiFexpected - pi/180*phiF);




end

