
dataFileNames = {...
    'FxC30', ...
    'FyC30', ...
    'FzC30'... %,...
%     'FxE30', ...
%     'FyE30', ...
%     'FzE30', ...
%     'FxL30', ...
%     'FyL30', ...
%     'FzL30', ...
%     'FxC15', ...
%     'FyC15', ...
%     'FzC15'...
    };


for fileIdx = 1:length(dataFileNames)
    
    
    %% Load specific condition
    
    dataFileName = dataFileNames{fileIdx};
    
    % Load data file
    load([dataFileName, '.mat'])
    
    directions = [length(find(dataFileName=='x')); length(find(dataFileName=='y')); length(find(dataFileName=='z'))];
    
    
    
    
    %% Analyze measurement error, tracking error and controller error
    measurementErrorRMS = zeros(length(f), 3);
    trackingErrorRMS = zeros(length(f), 3);
    controllerErrorRMS = zeros(length(f), 3);
    
    measurementErrorMAX = zeros(length(f), 3);
    trackingErrorMAX = zeros(length(f), 3);
    controllerErrorMAX = zeros(length(f), 3);
    
    
    for conditionIdx = 1:length(f)
        measurementErrorRMS(conditionIdx, :) = rms(conditionData.measuredForceData{conditionIdx} - conditionData.CPSForceData{conditionIdx});
        trackingErrorRMS(conditionIdx, :) = rms(conditionData.desiredForceData{conditionIdx} - conditionData.measuredForceData{conditionIdx});
        controllerErrorRMS(conditionIdx, :) = rms(conditionData.desiredForceData{conditionIdx} - conditionData.CPSForceData{conditionIdx});
        
        measurementErrorMAX(conditionIdx, :) = max(abs(conditionData.measuredForceData{conditionIdx} - conditionData.CPSForceData{conditionIdx}));
        trackingErrorMAX(conditionIdx, :) = max(abs(conditionData.desiredForceData{conditionIdx} - conditionData.measuredForceData{conditionIdx}));
        controllerErrorMAX(conditionIdx, :) = max(abs(conditionData.desiredForceData{conditionIdx} - conditionData.CPSForceData{conditionIdx}));
    end
    
    overallRMS = rms(trackingErrorRMS);
    
    
    %% Plot outcome data
    
    
    ADesired = outComeData.ADesired;
    ARYSEN = outComeData.ARYSEN;
    ALoadCell = outComeData.ALoadCell;
    
    PhaseDesired = outComeData.PhaseDesired;
    PhaseRYSEN = outComeData.PhaseRYSEN;
    PhaseLoadCell = outComeData.PhaseLoadCell;
    
    OffsetDesired = outComeData.OffsetDesired;
    OffsetRYSEN = outComeData.OffsetRYSEN;
    OffsetLoadCell = outComeData.OffsetLoadCell;
    
    
    
    figure
    subplot(3,1,1)
    plot(f, ARYSEN(:,directions==1)./ADesired(:,directions==1))
    hold on
    plot(f, ALoadCell(:,directions==1)./ADesired(:,directions==1))
    xlabel('Frequency (Hz)')
    ylabel('Gain')
    set(gca, 'YScale', 'log')
    set(gca, 'XScale', 'log')
    
    subplot(3,1,2)
    plot(f, PhaseRYSEN(:,directions==1))
    hold on
    plot(f, PhaseLoadCell(:,directions==1))
    xlabel('Frequency (Hz)')
    ylabel('Phase (deg)')
    set(gca, 'XScale', 'log')
    
    subplot(3,1,3)
    plot(f, OffsetRYSEN(:,directions==1))
    hold on
    plot(f, OffsetLoadCell(:,directions==1))
    xlabel('Frequency (Hz)')
    ylabel('Offset (N)')
    set(gca, 'XScale', 'log')
    
    saveas(gcf, ['figures\', dataFileName])
    
    
end
