function [APGRF] = statisticalAnalysis(APGRF)

%% Statistical testing for the anteroposterior impulse values
% Welch t-test to compare braking impulse
pValueBrakingImpulse = [];
pValuePushoffImpulse = [];
pValueTotalImpulse = [];

for i = 1:1:5
[hbrake30,pbrake30,cibrake30,statsbrake30] = ttest2(APGRF.ap_00_1,APGRF.ap_30_1(:,i));
[hbrake60,pbrake60,cibrake60,statsbrake60] = ttest2(APGRF.ap_00_1,APGRF.ap_60_1(:,i));
pbrake = [pbrake30,pbrake60];

[hpushoff30,ppushoff30,cipushoff30,statspushoff30] = ttest2(APGRF.ap_00_2,APGRF.ap_30_2(:,i));
[hpushoff60,ppushoff60,cipushoff60,statspushoff60] = ttest2(APGRF.ap_00_2,APGRF.ap_60_2(:,i));
ppushoff = [ppushoff30,ppushoff30];

[htotal30,ptotal30,citotal30,statstotal30] = ttest2(APGRF.ap_00_3,APGRF.ap_30_3(:,i));
[htotal60,ptotal60,citotal60,statstotal60] = ttest2(APGRF.ap_00_3,APGRF.ap_60_3(:,i));
ptotal = [ptotal30,ptotal60];

pValueBrakingImpulse = [pValueBrakingImpulse;pbrake];
pValuePushoffImpulse = [pValuePushoffImpulse; ppushoff];
pValueTotalImpulse = [pValueTotalImpulse; ptotal];
end

APGRF.statistics.pValueBrakingImpulse = pValueBrakingImpulse;
APGRF.statistics.pValuePushoffImpulse = pValuePushoffImpulse;
APGRF.statistics.pValueTotalImpulse = pValueTotalImpulse;

end

