% Title of Dataset: Neglected physical human-robot interaction may explain variable outcomes in gait neurorehabilitation research
% pn: participant number, nTrials: number of trials, u: unloading -
% expressed as a string, h: horizontal force - expressed as a string, 
% ci: eligible trials, x: division of gait cycle into 1000 parts

pn = 19;

% Set unloading level
u0 = '00';
u10 = '10';
u30 = '30';
u60 = '60';

% Set horizontal forces
h0 = '000';
h1 = '001';
hAll = {'n03','n15','000','p15','p03'};

% Set number of trials
trials3 = [1,2,3];
trials4 = [1,2,3,4];

%%  
for i  = trials3
structName = sprintf('p%d_%s_%s_000%d.mat',pn,u0,h0,i);
[path,name,ext] = fileparts(structName);
a =load(structName);
baseline = a.(name);

data = rmfield(baseline, setdiff(fieldnames(baseline), {'Timestamp', 'Force'}));
assignedName = sprintf('p%d_%s_%s_000%d.mat',pn-4,u0,h0,i);
save(assignedName,'data');
end

%% 

for i  = trials3
structName = sprintf('p%d_%s_%s_000%d.mat',pn,u0,h1,i);
[path,name,ext] = fileparts(structName);
a =load(structName);
baseline = a.(name);

data = rmfield(baseline, setdiff(fieldnames(baseline), {'Timestamp', 'Force'}));
assignedName = sprintf('p%d_%s_%s_000%d.mat',pn-4,u0,h1,i);
save(assignedName,'data');
end

%% 

for i  = trials3
structName = sprintf('p%d_%s_%s_000%d.mat',pn,u10,h0,i);
[path,name,ext] = fileparts(structName);
a =load(structName);
baseline = a.(name);

data = rmfield(baseline, setdiff(fieldnames(baseline), {'Timestamp', 'Force'}));
assignedName = sprintf('p%d_%s_%s_000%d.mat',pn-4,u10,h0,i);
save(assignedName,'data');
end

%% 

for h = hAll
for i  = trials4
structName = sprintf('p%d_%s_%s_000%d.mat',pn,u30,[h{:}],i);
[path,name,ext] = fileparts(structName);
a =load(structName);
baseline = a.(name);

data = rmfield(baseline, setdiff(fieldnames(baseline), {'Timestamp', 'Force'}));
assignedName = sprintf('p%d_%s_%s_000%d.mat',pn-4,u30,[h{:}],i);
save(assignedName,'data');
end
end

%% 

for h = hAll
for i  = trials4
structName = sprintf('p%d_%s_%s_000%d.mat',pn,u60,[h{:}],i);
[path,name,ext] = fileparts(structName);
a =load(structName);
baseline = a.(name);

data = rmfield(baseline, setdiff(fieldnames(baseline), {'Timestamp', 'Force'}));
assignedName = sprintf('p%d_%s_%s_000%d.mat',pn-4,u60,[h{:}],i);
save(assignedName,'data');
end
end