function plotGRF(APGRF,VGRF)
% Title of Dataset: Neglected physical human-robot interaction may explain variable outcomes in gait neurorehabilitation research
%% Baseline data for AP impulse

bsl_up_1 = ones(1,5)*mean(APGRF.ap_00_1) + std(APGRF.ap_00_1);
bsl_dn_1 = ones(1,5)*mean(APGRF.ap_00_1) - std(APGRF.ap_00_1);
bsl_up_2 = ones(1,5)*mean(APGRF.ap_00_2) + std(APGRF.ap_00_2);
bsl_dn_2 = ones(1,5)*mean(APGRF.ap_00_2) - std(APGRF.ap_00_2);
bsl_up_3 = ones(1,5)*mean(APGRF.ap_00_3) + std(APGRF.ap_00_3);
bsl_dn_3 = ones(1,5)*mean(APGRF.ap_00_3) - std(APGRF.ap_00_3);
x = 1:1:5;
x2 = [x, fliplr(x)];
bsl_1 = [bsl_up_1, fliplr(bsl_dn_1)];
bsl_2 = [bsl_up_2, fliplr(bsl_dn_2)];
bsl_3 = [bsl_up_3, fliplr(bsl_dn_3)];

dist(:,1,:) = VGRF.VGRF30_d';
dist(:,2,:) = VGRF.VGRF60_d';
x = 1:5;
%% Plot AP impulse

figure
set(gcf, 'Units', 'Normalized', 'OuterPosition', [0 0 1 1]);
t = tiledlayout(2,3,'TileSpacing','Compact','Padding','Compact');
nexttile
b = fill(x2, bsl_1, [17 17 17]/255);
set(b,'facealpha',.25)
hold on
boxplot(APGRF.ap_30_1,'Labels',{'-3%','-1.5%','0','1.5%','3%'});
title('Normalized braking impulse')
set(findobj(gca,'type','line'),'linew',2)
ax = gca;
ax.XGrid = 'off';
ax.YMinorGrid = 'on';
set(gca,'xticklabel',{[]})
set(gca,'FontSize',18)
ylabel('30% unloading')

nexttile
b = fill(x2, bsl_2, [17 17 17]/255);
set(b,'facealpha',.25)
hold on
boxplot(APGRF.ap_30_2,'Labels',{'-3%','-1.5%','0','1.5%','3%'})
title('Normalized push-off impulse')
set(findobj(gca,'type','line'),'linew',2)
ax = gca;
ax.XGrid = 'off';
ax.YMinorGrid = 'on';
set(gca,'FontSize',18)
set(gca,'xticklabel',{[]})

nexttile
b = fill(x2, bsl_3, [17 17 17]/255);
set(b,'facealpha',.25)
hold on
boxplot(APGRF.ap_30_3,'Labels',{'-3%','-1.5%','0','1.5%','3%'})
title('Normalized total AP impulse')
set(findobj(gca,'type','line'),'linew',2)
ax = gca;
ax.XGrid = 'off';
ax.YMinorGrid = 'on';
set(gca,'FontSize',18)
set(gca,'xticklabel',{[]})

nexttile
b = fill(x2, bsl_1, [17 17 17]/255);
set(b,'facealpha',.25)
hold on
boxplot(APGRF.ap_60_1,'Labels',{'-3%','-1.5%','0','1.5%','3%'});
xlabel('% Horizontal force')
ylabel('60% unloading')
set(findobj(gca,'type','line'),'linew',2)
ax = gca;
ax.XGrid = 'off';
ax.YMinorGrid = 'on';
set(gca,'FontSize',18)

nexttile
b = fill(x2, bsl_2, [17 17 17]/255);
set(b,'facealpha',.25)
hold on
boxplot(APGRF.ap_60_2,'Labels',{'-3%','-1.5%','0','1.5%','3%'})
xlabel('% Horizontal force')
set(findobj(gca,'type','line'),'linew',2)
ax = gca;
ax.XGrid = 'off';
ax.YMinorGrid = 'on';
set(gca,'FontSize',18)

nexttile
b = fill(x2, bsl_3, [17 17 17]/255);
set(b,'facealpha',.25)
hold on
boxplot(APGRF.ap_60_3,'Labels',{'-3%','-1.5%','0','1.5%','3%'})
xlabel('% Horizontal force')
set(findobj(gca,'type','line'),'linew',2)
ax = gca;
ax.XGrid = 'off';
ax.YMinorGrid = 'on';
set(gca,'FontSize',18)

%% Plot vertical GRF

figure
set(gcf, 'Units', 'Normalized', 'OuterPosition', [0 0 1 1]);
t = tiledlayout(2,3,'TileSpacing','Compact','Padding','Compact');
gait = 0.1:0.1:100;

nexttile
shadedErrorBar(gait,VGRF.VGRF0_m  ,VGRF.VGRF0_s,'lineProps','--k')
shadedErrorBar(gait,VGRF.VGRF30_m(:,1)  ,VGRF.VGRF30_s(:,1),'lineProps','r')
shadedErrorBar(gait,VGRF.VGRF60_m(:,1)  ,VGRF.VGRF60_s(:,1),'lineProps','b')
set(findobj(gca,'type','line'),'linew',2)
set(gca,'FontSize',18)
title('-3% horizontal force')
ylim([0 1.5])
set(gca,'xticklabel',{[]})
ylabel('Normalized vertical GRF')

nexttile
shadedErrorBar(gait,VGRF.VGRF0_m  ,VGRF.VGRF0_s,'lineProps','--k')
shadedErrorBar(gait,VGRF.VGRF30_m(:,2)  ,VGRF.VGRF30_s(:,2),'lineProps','r')
shadedErrorBar(gait,VGRF.VGRF60_m(:,2)  ,VGRF.VGRF60_s(:,2),'lineProps','b')
set(findobj(gca,'type','line'),'linew',2)
set(gca,'FontSize',18)
title('-1.5% horizontal force')
ylim([0 1.5])
set(gca,'xticklabel',{[]})
set(gca,'yticklabel',{[]})

nexttile
shadedErrorBar(gait,VGRF.VGRF0_m  ,VGRF.VGRF0_s,'lineProps','--k')
shadedErrorBar(gait,VGRF.VGRF30_m(:,3)  ,VGRF.VGRF30_s(:,3),'lineProps','r')
shadedErrorBar(gait,VGRF.VGRF60_m(:,3)  ,VGRF.VGRF60_s(:,3),'lineProps','b')
xlabel('% gait cycle')
set(findobj(gca,'type','line'),'linew',2)
set(gca,'FontSize',18)
title('0% horizontal force')
ylim([0 1.5])

nexttile
shadedErrorBar(gait,VGRF.VGRF0_m  ,VGRF.VGRF0_s,'lineProps','--k')
shadedErrorBar(gait,VGRF.VGRF30_m(:,4)  ,VGRF.VGRF30_s(:,4),'lineProps','r')
shadedErrorBar(gait,VGRF.VGRF60_m(:,4)  ,VGRF.VGRF60_s(:,4),'lineProps','b')
xlabel('% gait cycle')
set(findobj(gca,'type','line'),'linew',2)
ylabel('Normalized vertical GRF')
set(gca,'FontSize',18)
title('1.5% horizontal force')
ylim([0 2])

nexttile
shadedErrorBar(gait,VGRF.VGRF0_m  ,VGRF.VGRF0_s,'lineProps','--k')
shadedErrorBar(gait,VGRF.VGRF30_m(:,5)  ,VGRF.VGRF30_s(:,5),'lineProps','r')
shadedErrorBar(gait,VGRF.VGRF60_m(:,5)  ,VGRF.VGRF60_s(:,5),'lineProps','b')
xlabel('% gait cycle')
set(findobj(gca,'type','line'),'linew',2)
set(gca,'FontSize',18)
legend('0% unloading','30% unloading', '60% unloading')
title('3% horizontal force')
ylim([0 2])
set(gca,'yticklabel',{[]})

nexttile
h = boxplot2(dist,x);
ax = gca;
ax.XGrid = 'off';
ax.YMinorGrid = 'on';
set(gca,'FontSize',18)
set(gca,'Xticklabel',{'','-3%','-1.5%','0%','1.5%','3%',''})
set(findobj(gca,'type','line'),'linew',2)
xlabel('Horizontal force')
ylabel('Euclidean distance')
cmap = get(0, 'defaultaxescolororder');
for ii = 1:2
    structfun(@(x) set(x(ii,:), 'color', cmap(ii,:), ...
        'markeredgecolor', cmap(ii,:)), h);
end
set([h.lwhis h.uwhis], 'linestyle', '-');
set(h.out, 'marker', '.');
legend('30% unloading','60% unloading')
end

