function [APGRF,VGRF] = loadGRFData()
%% Title of Dataset: Neglected physical human-robot interaction may explain variable outcomes in gait neurorehabilitation research
% This function computes the mean and SD of vertical GRF and saves in a
% specific format


%% Initiate variables
ap_30_1 = [];
ap_30_2 = [];
ap_60_1 = [];
ap_60_2 = [];
v_00_000 = [];
v_10_000 = [];
v_30_n03 = [];
v_30_n15 = [];
v_30_000 = [];
v_30_p15 = [];
v_30_p03 = [];
v_60_n03 = [];
v_60_n15 = [];
v_60_000 = [];
v_60_p15 = [];
v_60_p03 = [];
v_30_n03_d = [];
v_30_n15_d = [];
v_30_000_d = [];
v_30_p15_d = [];
v_30_p03_d = [];
v_60_n03_d = [];
v_60_n15_d = [];
v_60_000_d = [];
v_60_p15_d = [];
v_60_p03_d = [];
%% Load data

for pn = 1:1:15
    funcName = sprintf('GRF_p%d',pn);
    fh = str2func(funcName);
    [ap1_30,ap2_30,ap1_60,ap2_60,v_30,v_60]= fh();
    ap_30_1 = [ap_30_1;ap1_30];
    ap_30_2 = [ap_30_2;ap2_30];
    ap_60_1 = [ap_60_1;ap1_60];
    ap_60_2 = [ap_60_2;ap2_60];
    v_00_000 = [v_00_000;v_30(1,:)];
    v_10_000 = [v_10_000;v_30(2,:)];
    v_30_n03 = [v_30_n03;v_30(3,:)];
    v_30_n15 = [v_30_n15;v_30(4,:)];
    v_30_000 = [v_30_000;v_30(5,:)];
    v_30_p15 = [v_30_p15;v_30(6,:)];
    v_30_p03 = [v_30_p03;v_30(7,:)];
    v_60_n03 = [v_60_n03;v_60(3,:)];
    v_60_n15 = [v_60_n15;v_60(4,:)];
    v_60_000 = [v_60_000;v_60(5,:)];
    v_60_p15 = [v_60_p15;v_60(6,:)];
    v_60_p03 = [v_60_p03;v_60(7,:)];    
    
    % Distance between VGRF profiles
    v_30_n03_d = [v_30_n03_d;norm(v_30(3,:)-v_30(1,:))];
    v_30_n15_d = [v_30_n15_d;norm(v_30(4,:)-v_30(1,:))];
    v_30_000_d = [v_30_000_d;norm(v_30(5,:)-v_30(1,:))];
    v_30_p15_d = [v_30_p15_d;norm(v_30(6,:)-v_30(1,:))];
    v_30_p03_d = [v_30_p03_d;norm(v_30(7,:)-v_30(1,:))];
    v_60_n03_d = [v_60_n03_d;norm(v_60(3,:)-v_60(1,:))];
    v_60_n15_d = [v_60_n15_d;norm(v_60(4,:)-v_60(1,:))];
    v_60_000_d = [v_60_000_d;norm(v_60(5,:)-v_60(1,:))];
    v_60_p15_d = [v_60_p15_d;norm(v_60(6,:)-v_60(1,:))];
    v_60_p03_d = [v_60_p03_d;norm(v_60(7,:)-v_60(1,:))];    
end

%% Calculate mean and sd and collate data
VGRF.VGRF0_m = mean(v_00_000)';
VGRF.VGRF0_s = std(v_00_000)';

VGRF.VGRF10_m = mean(v_10_000)';
VGRF.VGRF10_s = std(v_10_000)';

VGRF.VGRF30_m   = [mean(v_30_n03);mean(v_30_n15);mean(v_30_000);mean(v_30_p15);mean(v_30_p03)]';
VGRF.VGRF30_s   = [std(v_30_n03);std(v_30_n15);std(v_30_000);std(v_30_p15);std(v_30_p03)]';
VGRF.VGRF30_d   = [v_30_n03_d, v_30_n15_d, v_30_000_d, v_30_p15_d,v_30_p03_d];

VGRF.VGRF60_m   = [mean(v_60_n03);mean(v_60_n15);mean(v_60_000);mean(v_60_p15,'omitnan');mean(v_60_p03)]';
VGRF.VGRF60_s   = [std(v_60_n03);std(v_60_n15);std(v_60_000);std(v_60_p15,'omitnan');std(v_60_p03)]';
VGRF.VGRF60_d   = [v_60_n03_d, v_60_n15_d, v_60_000_d, v_60_p15_d,v_60_p03_d];
%% Save data
APGRF.ap_00_1 = ap_30_1(:,1);
APGRF.ap_00_2 = ap_30_2(:,1);
APGRF.ap_00_3 = ap_30_1(:,1) + ap_30_2(:,1);

APGRF.ap_10_1 = ap_30_1(:,2);
APGRF.ap_10_2 = ap_30_2(:,2);
APGRF.ap_10_3 = ap_30_1(:,2) + ap_30_2(:,2);

APGRF.ap_30_1 = ap_30_1(:,3:7);
APGRF.ap_30_2 = ap_30_2(:,3:7);
APGRF.ap_30_3 = ap_30_1(:,3:7) + ap_30_2(:,3:7);

APGRF.ap_60_1 = ap_60_1(:,3:7);
APGRF.ap_60_2 = ap_60_2(:,3:7);
APGRF.ap_60_3 = ap_60_1(:,3:7) + ap_60_2(:,3:7);

% Uncomment the statement below to save the processed GRF data
% save('forceDataProcessed.mat','VGRF','APGRF');

end

