function [grf_ap_p1,grf_ap_p2,grf_mean_v] = extractGRFpeaks(pn,nTrials,u,h,c,x,wt,pwt)
% Title of Dataset: Neglected physical human-robot interaction may explain variable outcomes in gait neurorehabilitation research
% pn: participant number, nTrials: number of trials, u: unloading -
% expressed as a string, h: horizontal force - expressed as a string, 
% ci: eligible trials, x: division of gait cycle into 1000 parts

wtRem = (1-pwt/100)*wt*9.806; % weight support by the participant
count =  nTrials;

% low-pass filter
fs = 100; % sampling F frequency
fc = 5; % cut-off frequency

[bf,af] = butter(2,1.16*fc/(fs/2));

for i  = count
structName = sprintf('p%d_%s_%s_000%d.mat',pn,u,h,i);
a =load(structName);
baseline = a.data;

an_1 = find(abs(baseline.Force(1).Force(1,:))>=(0.02*wtRem)); 
an_2 = find(abs(baseline.Force(2).Force(1,:))>=(0.02*wtRem)); 
vn_1 = find(abs(baseline.Force(1).Force(3,:))>=(0.05*wtRem));
vn_2 = find(abs(baseline.Force(2).Force(3,:))>=(0.05*wtRem));

ap_fp1_temp = -baseline.Force(1).Force(1,an_1(1):an_1(end));
xs = linspace(0, 100, length(ap_fp1_temp));
grf_fp1_ap(i,:) = interp1(xs,ap_fp1_temp,x);
grf_fp1_ap(i,:) = filtfilt(bf,af,double(grf_fp1_ap(i,:)'));

ap_fp2_temp = -baseline.Force(2).Force(1,an_2(1):an_2(end));
xs = linspace(0, 100, length(ap_fp2_temp));
grf_fp2_ap(i,:) = interp1(xs,ap_fp2_temp,x);
grf_fp2_ap(i,:) = filtfilt(bf,af,double(grf_fp2_ap(i,:)'));

v_fp1_temp = -baseline.Force(1).Force(3,vn_1(1):vn_1(end));
xs = linspace(0, 100, length(v_fp1_temp));
grf_fp1_v(i,:) = interp1(xs,v_fp1_temp,x);
grf_fp1_v(i,:) = filtfilt(bf,af,double(grf_fp1_v(i,:)'));

v_fp2_temp = -baseline.Force(2).Force(3,vn_2(1):vn_2(end));
xs = linspace(0, 100, length(v_fp2_temp));
grf_fp2_v(i,:) = interp1(xs,v_fp2_temp,x);
grf_fp2_v(i,:) = filtfilt(bf,af,double(grf_fp2_v(i,:)'));

end
% 
% figure; plot(x(1:500),grf_fp1_ap(:,1:500),x(1:500),grf_fp2_ap(:,1:500),'--'); hold on; plot(x(501:1000),grf_fp1_ap(:,501:1000),x(501:1000),grf_fp2_ap(:,501:1000),'--')
% figure; area(x(1:500),grf_fp1_ap(1,1:500)); hold on; area(x(501:1000),grf_fp1_ap(1,501:1000))

grf_ap = [];

for j = count
    if c(j) == 1
        grf_ap = [ grf_ap ; grf_fp1_ap(j,:)];
    elseif c(j) == 2
        grf_ap = [ grf_ap ; grf_fp2_ap(j,:)];
    else
        grf_ap = [grf_ap ; []];
    end
end

grf_ap = grf_ap/wtRem;
grf_ap = grf_ap';

grf_ap_p1 = mean(mean(grf_ap(1:500,:)));
grf_ap_p2 = mean(mean(grf_ap(501:1000,:)));

% figure; plot(x,grf_fp1_v,x,grf_fp2_v,'--');

grf_v = [];

for k = count
    if c(k) == 1
        grf_v = [ grf_v ; grf_fp1_v(k,:)];
    elseif c(k) == 2
        grf_v = [ grf_v ; grf_fp2_v(k,:)];
    else
        grf_v = [grf_v ; []];
    end
end

grf_v = grf_v/wtRem;
s = size(grf_v);

if s(1) == 1
    grf_mean_v = grf_v;
else
    grf_mean_v = mean(grf_v);
end

end

