%% Add data and code library paths

clear 
clc

addpath('/data')  

%% Load GRF data
% ap1 = mean of braking force (braking impulse), ap2 = mean of pushoff
[APGRF,VGRF] = loadGRFData();

%% Plots - AP impulse and VGRF profile
plotGRF(APGRF,VGRF)

%% Significance testing
[pbrakingImpulse,ppushoffImpulse,ptotalImpulse] = statisticalAnalysis(APGRF);

%%
if(~isdeployed)
  cd(fileparts(which('main.m')));
end
