clc
clear all
close all


load('DataFromForms\B7.mat')
load('DataFromForms\B12.mat')
load('DataFromForms\B5.mat')
load('DataFromForms\B2.mat')
load('DataFromForms\B10.mat')
load('DataFromForms\B8.mat')
load('DataFromForms\B14.mat')
load('DataFromForms\B11.mat')
load('DataFromForms\B1.mat')
load('DataFromForms\B6.mat')
load('DataFromForms\B3.mat')
load('DataFromForms\B4.mat')
load('DataFromForms\B9.mat')
load('DataFromForms\B15.mat')
load('DataFromForms\B13.mat')

subjects(1) = B1;
subjects(2) = B2;
subjects(3) = B3;
subjects(4) = B4;
subjects(5) = B5;
subjects(6) = B6;
subjects(7) = B7;
subjects(8) = B8;
subjects(9) = B9;
subjects(10) = B10;
subjects(11) = B11;
subjects(12) = B12;
subjects(13) = B13;
subjects(14) = B14;
subjects(15) = B15;


for subjectIdx = 1:length(subjects)
    force = subjects(subjectIdx).spectrum(:,1);
    velocity = subjects(subjectIdx).spectrum(:,2:5);
    subjects(subjectIdx).spectrum = [];
    subjects(subjectIdx).spectrum.force = force;
    subjects(subjectIdx).spectrum.velocity = velocity;
end


save('allDataB', 'subjects')


%% Motion capture

clc
clear all
close all


load('allDataB');


load('dataQTM\datasToSend\B4QTM.mat')
load('dataQTM\datasToSend\B6QTM.mat')
load('dataQTM\datasToSend\B5QTM.mat')
load('dataQTM\datasToSend\B3QTM.mat')
load('dataQTM\datasToSend\B7QTM.mat')
load('dataQTM\datasToSend\B8QTM.mat')
load('dataQTM\datasToSend\B9QTM.mat')
load('dataQTM\datasToSend\B2QTM.mat')
load('dataQTM\datasToSend\B14QTM.mat')
load('dataQTM\datasToSend\B1QTM.mat')
load('dataQTM\datasToSend\B15QTM.mat')
load('dataQTM\datasToSend\B10QTM.mat')
load('dataQTM\datasToSend\B11QTM.mat')
load('dataQTM\datasToSend\B12QTM.mat')
load('dataQTM\datasToSend\B13QTM.mat')


subjects(1).motionCapture = B1;
subjects(2).motionCapture = B2;
subjects(3).motionCapture = B3;
subjects(4).motionCapture = B4;
subjects(5).motionCapture = B5;
subjects(6).motionCapture = B6;
subjects(7).motionCapture = B7;
subjects(8).motionCapture = B8;
subjects(9).motionCapture = B9;
subjects(10).motionCapture = B10;
subjects(11).motionCapture = B11;
subjects(12).motionCapture = B12;
subjects(13).motionCapture = B13;
subjects(14).motionCapture = B14;
subjects(15).motionCapture = B15;


for subjectIdx = 1:length(subjects)
    subjects(subjectIdx).motionCapture.time = (0:1/subjects(subjectIdx).motionCapture.FrameRate:(subjects(subjectIdx).motionCapture.Frames-1)/subjects(subjectIdx).motionCapture.FrameRate)';
    subjects(subjectIdx).motionCapture.position = squeeze(subjects(subjectIdx).motionCapture.Trajectories.Labeled.Data(1,1:3,:))' / 1000;
end


save('allDataB', 'subjects')




