
%% Get data
if 0
    sortData;
end

clear all

load('allDataB.mat')

numberOfSubjects = length(subjects);


%% Self selected velocity @10%

selfSelectedVelocity10 = zeros(1, numberOfSubjects);
selfSelectedVelocity10STD = zeros(1, numberOfSubjects);

for subjectIdx = 1:numberOfSubjects
    selfSelectedVelocity10(subjectIdx) = mean(subjects(subjectIdx).targetVel);
    selfSelectedVelocity10STD(subjectIdx) = std(subjects(subjectIdx).targetVel);
end


% Motion capture
selfSelectedVelocity10_MC = zeros(1, numberOfSubjects);
selfSelectedVelocity10STD_MC = zeros(1, numberOfSubjects);


xMin = -1.0;
xMax = 3.0;

for subjectIdx = 1:numberOfSubjects
    goingPositive = false;
    goingNegative = false;
    timeStart = 0;
    timeEnd = 0;
    positionStart = 0;
    positionEnd = 0;
    
    velocities = [];
    
    time = subjects(subjectIdx).motionCapture.time;
    position = subjects(subjectIdx).motionCapture.position;
    
    for Idx = 2:length(time)
        if position(Idx, 2) < xMin
            if goingNegative
                timeEnd = time(Idx);
                positionEnd = position(Idx,2);
                velocities = [velocities; (positionStart - positionEnd) / (timeEnd - timeStart)];
            end
            timeStart = time(Idx);
            positionStart = position(Idx,2);

            goingPositive = true;
            goingNegative = false;
        end
        if position(Idx, 2) > xMax
            if goingPositive
                timeEnd = time(Idx);
                positionEnd = position(Idx,2);
                velocities = [velocities; (positionEnd - positionStart) / (timeEnd - timeStart)];
            end
            timeStart = time(Idx);
            positionStart = position(Idx,2);
            goingPositive = false;
            goingNegative = true;
        end        
    end
    
    selfSelectedVelocity10_MC(subjectIdx) = mean(velocities);
    selfSelectedVelocity10STD_MC(subjectIdx) = std(velocities);
end



%% Velocity depending on force

figure;
forceSpectrum = (-3.2:0.4:3.2)';
velocitySpectrum = zeros(length(forceSpectrum), numberOfSubjects);
velocitySpectrumSTD = zeros(length(forceSpectrum), numberOfSubjects);
spectrumLinearization = zeros(2,numberOfSubjects);

for subjectIdx = 1:numberOfSubjects
    velocitySpectrum(:,subjectIdx) = mean(subjects(subjectIdx).spectrum.velocity, 2);
    velocitySpectrumSTD(:,subjectIdx) = std(subjects(subjectIdx).spectrum.velocity, 0, 2);
    spectrumLinearization(:,subjectIdx) = polyfit(forceSpectrum,velocitySpectrum(:,subjectIdx),1)';
    
    if 1
%         hold off
        scatter(forceSpectrum, velocitySpectrum(:,subjectIdx)/selfSelectedVelocity10(subjectIdx))
        hold on
        plot(forceSpectrum, polyval(spectrumLinearization(:,subjectIdx)', forceSpectrum)/selfSelectedVelocity10(subjectIdx));
    end
end


% normalizationParameter = selfSelectedVelocity10;
normalizationParameter = spectrumLinearization(2,:);




meanSpectrumPoly = mean(spectrumLinearization./normalizationParameter, 2);
stdSpectrumPoly = std(spectrumLinearization./normalizationParameter, 0, 2);




%% Force needed to compensate for attachment

figure

forceRequiredBack = zeros(numberOfSubjects, 1);
forceRequiredMiddle = zeros(numberOfSubjects, 1);
forceRequiredFront = zeros(numberOfSubjects, 1);
forceRequiredLooped = zeros(numberOfSubjects, 1);

velAtZeroAPForceBack = zeros(numberOfSubjects, 1);
velAtZeroAPForceMiddle = zeros(numberOfSubjects, 1);
velAtZeroAPForceFront = zeros(numberOfSubjects, 1);
velAtZeroAPForceLooped = zeros(numberOfSubjects, 1);

intermediatePlots = true;


numberOfDataPointsToSkip = 0;


for subjectIdx = 1:numberOfSubjects
    % back
    forces = subjects(subjectIdx).stitched.back(1+numberOfDataPointsToSkip:end,1);
    velocities = mean(subjects(subjectIdx).stitched.back(1+numberOfDataPointsToSkip:end,2:3), 2) / normalizationParameter(subjectIdx);
    P = polyfit(forces,velocities,1);
    velocitiesFit = polyval(P, forces);
    
    forceRequiredBack(subjectIdx) = (1-P(2))/P(1);
    velAtZeroAPForceBack(subjectIdx) = P(2);
    
    if intermediatePlots
        hold off
        scatter(forces, velocities, 'b')
        hold on
        plot(forces, velocitiesFit, 'b')
    end
    
    
    % middle
    forces = subjects(subjectIdx).stitched.mid(1+numberOfDataPointsToSkip:end,1);
    velocities = mean(subjects(subjectIdx).stitched.mid(1+numberOfDataPointsToSkip:end,2:3), 2) / normalizationParameter(subjectIdx);
    P = polyfit(forces,velocities,1);
    velocitiesFit = polyval(P, forces);
    
    forceRequiredMiddle(subjectIdx) = (1-P(2))/P(1);
    velAtZeroAPForceMiddle(subjectIdx) = P(2);
    
    if intermediatePlots
        scatter(forces, velocities, 'r')
        hold on
        plot(forces, velocitiesFit, 'r')
    end
    
    % front
    forces = subjects(subjectIdx).stitched.front(1+numberOfDataPointsToSkip:end,1);
    velocities = mean(subjects(subjectIdx).stitched.front(1+numberOfDataPointsToSkip:end,2:3), 2) / normalizationParameter(subjectIdx);
    P = polyfit(forces,velocities,1);
    velocitiesFit = polyval(P, forces);
    
    forceRequiredFront(subjectIdx) = (1-P(2))/P(1);
    velAtZeroAPForceFront(subjectIdx) = P(2);
    
    if intermediatePlots
        scatter(forces, velocities, 'g')
        hold on
        plot(forces, velocitiesFit, 'g')
    end
    
    
    % looped
    forces = subjects(subjectIdx).looped(1+numberOfDataPointsToSkip:end,1);
    velocities = mean(subjects(subjectIdx).looped(1+numberOfDataPointsToSkip:end,2:3), 2) / normalizationParameter(subjectIdx);
    P = polyfit(forces,velocities,1);
    velocitiesFit = polyval(P, forces);
    
    forceRequiredLooped(subjectIdx) = (1-P(2))/P(1);
    velAtZeroAPForceLooped(subjectIdx) = P(2);
    
    if intermediatePlots
        scatter(forces, velocities, 'c')
        hold on
        plot(forces, velocitiesFit, 'c')
        
        plot([-5, 5], [1, 1])
    end
    
    
end


%% Self selected force

selfSelectedForce = zeros(2,numberOfSubjects);

for subjectIdx = 1:numberOfSubjects
    selfSelectedForce(:, subjectIdx) = subjects(subjectIdx).adjust';
end

mean(selfSelectedForce, 2)
std(selfSelectedForce, 0, 2)

mean(diff(selfSelectedForce))



%% Plot the stuff

close all

figure
boxplot([selfSelectedVelocity10_MC; selfSelectedVelocity10; spectrumLinearization(2,:)]', 'Labels', {'0%', '10%', '60%'});
ylabel('Self selected velocity (m/s)')


saveas(gcf, '..\paperFigures\self selected velocity')



figure
plot(forceSpectrum, mean(velocitySpectrum./normalizationParameter, 2))
hold on
jbfill(forceSpectrum' , (mean(velocitySpectrum./normalizationParameter, 2)+std(velocitySpectrum./normalizationParameter, 0, 2))', ...
                      (mean(velocitySpectrum./normalizationParameter, 2)-std(velocitySpectrum./normalizationParameter, 0, 2))', ...
                      'b', 'b', 1, 0.2);
% plot(forceSpectrum, mean(velocitySpectrum./normalizationParameter, 2)+std(velocitySpectrum./normalizationParameter, 0, 2))
% plot(forceSpectrum, mean(velocitySpectrum./normalizationParameter, 2)-std(velocitySpectrum./normalizationParameter, 0, 2))

% plot(forceSpectrum, polyval(meanSpectrumPoly', forceSpectrum));
hold on

ax = gca;

jbfill(mean(selfSelectedForce'), ...
                ones(1,2)*ax.YLim(2),ones(1,2)*ax.YLim(1), ...
                      'r', 'r', 1, 0.2);

hold on

scatter([0, 0, 0], [mean(velAtZeroAPForceBack), mean(velAtZeroAPForceMiddle), mean(velAtZeroAPForceFront)])

xlabel('AP force (%)')
ylabel('Normalized self selected velocity')

saveas(gcf, '..\paperFigures\RYSEN_vel_vs_APforce')



% 
% figure
% subplot(2,1,1)
% boxplot((velocitySpectrum./velocitySpectrum(end/2+0.5,:))', 'Labels', {'-3.2', '-2.8', '-2.4', ...
%     '-2.0', '-1.6', '-1.2', '-0.8', '-0.4', '0.0', '0.4', '0.8', '1.2', '1.6', '2.0', '2.4', ...
%     '2.8', '3.2'})
% ylabel('Normalized velocity')
% title('Normalized by velocity at 0% AP force')
% xlabel('AP force (%)')
% 
% 
% subplot(2,1,2)
% boxplot((velocitySpectrum./selfSelectedVelocity10)', 'Labels', {'-3.2', '-2.8', '-2.4', ...
%     '-2.0', '-1.6', '-1.2', '-0.8', '-0.4', '0.0', '0.4', '0.8', '1.2', '1.6', '2.0', '2.4', ...
%     '2.8', '3.2'})
% ylabel('Normalized velocity')
% title('Normalized by velocity at 10% BWS')
% xlabel('AP force (%)')



figure
boxplot(saturate([forceRequiredBack, forceRequiredMiddle, forceRequiredLooped, forceRequiredFront], -5, 5), ...
    'Labels', {'Back', 'Both', 'Looped', 'Front'})

jbfill([0, 5] , ones(1,2)*mean(selfSelectedForce(2,:)), ...
                ones(1,2)*mean(selfSelectedForce(1,:)), ...
                      'r', 'r', 1, 0.2);

title('Force required to compensate for attachment')
ylabel('AP Force (%)')
xlabel('Type of attachment')


saveas(gcf, '..\paperFigures\Force versus type of attachment')



% 
% figure
% boxplot(selfSelectedForce', 'Labels', {'Negative start', 'Positive start'})
% title('Self selected force')
% ylabel('Force (%)')

