%% Init
clear all ; close all ; clc ;
folder = 'C:\Users\LocalAdmin\Documents\2019-08-12-RYSENSlingbar-Romain';
addpath(genpath(folder));

%%

filesToOpen = {'B1' 'B2' 'B3' 'B4' 'B5' 'B6' 'B7' 'B8' 'B9' 'B10' 'B11' 'B12' 'B13' 'B14' 'B15' }; %'A1' 'A2' 'A3' 'A4' 'A5' 'A6' 'A7' 'A8' 'A9' 'A10' 'A11' 'A12' 'A13' 'A14'};

%%
for i = 1:length(filesToOpen)
    load([filesToOpen{i} 'QTM.mat']);
end

nEvents = 6;
for i = 1:length(filesToOpen)
    %extract current events
    events(1)=1;
    for j = 1:nEvents
        eval(['events(j+1)=round(' filesToOpen{i} '.Events(j).Frame);'])
    end
    
    %cut datas
    %     figure;
    datasCutted = {};
    for k = 1:nEvents
        eval(['datasCutted{k} = squeeze(' filesToOpen{i} '.Trajectories.Labeled.Data(1,2,events(k):events(k+1)));']);
        %         plot(datasCutted{k}); hold on
        if k == 1 || k == 3 || k == 5
            in = find(datasCutted{k}>=3000,1,'first');
            out = find(datasCutted{k}<=-1000,1,'last');
        elseif k == 2 || k == 4 || k == 6
            in = find(datasCutted{k}>=3000,1,'last');
            out = find(datasCutted{k}<=-1000,1,'first');
        end
        timeSpan = (out - in)/100;
        velocity(i,k) = abs(4/timeSpan); %4 meters done in X time
        clearvars in out
    end
    clearvars datasCutted events
end

boxplot( velocity',filesToOpen)
% Only returns the velocity
clearvars -except velocity

%% RYSEN vs. QTM velocity estimation error

filesToOpen = {'RysQTMVel'};
velocityRys = [1.39, 1.44, 1.47, 1.47];

for i = 1:length(filesToOpen)
    load([filesToOpen{i} 'QTM.mat']);
end

nEvents = 4;

m1 = 2500; m2 = 3500;
m = m1:10:m2;
n1 = -1500; n2 = -500;
n = n1:10:n2;

increment = 1;
rowing = 1;
datasCutted = {};

for i = 1:length(filesToOpen)
    %extract current events
    events(1)=1;
    for j = 1:nEvents
        eval(['events(j+1)=round(' filesToOpen{i} '.Events(j).Frame);'])
    end
    
    for k = 1:nEvents    
        eval(['datasCutted{k} = squeeze(' filesToOpen{i} '.Trajectories.Labeled.Data(1,2,events(k):events(k+1)));']);
    end
end

storeK = {};

for i = 1:length(filesToOpen)       
    for k = 1:nEvents    
        for o = m1:m2                
            for p = n1:n2
                if k == 1 || k == 3
                    in = find(datasCutted{k}>=o,1,'first');
                    out = find(datasCutted{k}<=p,1,'last');
                elseif k == 2 || k == 4
                    in = find(datasCutted{k}>=o,1,'last');
                    out = find(datasCutted{k}<=p,1,'first');
                end
                timeSpan = (out - in)/100;
                velocity(i,k) = abs((o-p)/1000/timeSpan); %Y meters done in X time
                
                %error computation
                error = velocity(i,k)-velocityRys(k);
                
                %error storage
                storing(o-m1+1,p-n1+1) =error;
            end
            
            if o == (m1+(m2+m1)/2)/2
                disp(['Trial ' num2str(k) '/' num2str(nEvents) ': 25%'])
            elseif o == (m2+m1)/2
                disp(['Trial ' num2str(k) '/' num2str(nEvents) ': 50%'])   
            elseif o == (m2+(m2+m1)/2)/2
                disp(['Trial ' num2str(k) '/' num2str(nEvents) ': 75%']) 
            end
        end        
        storeK{k} = storing;
        clearvars storing
    end
end


figure(1);
mesh(m, n, storeK{1})
keyboard

figure(2);
 for k = 1:nEvents    
     mesh(m, n, storeK{k})
     grid on
     hold on;
 end


