
%% Get data

sortData;

clear all

load('allDataB.mat')

numberOfSubjects = length(subjects);


%% Self selected velocity @10%

selfSelectedVelocity10 = zeros(1, numberOfSubjects);
selfSelectedVelocity10STD = zeros(1, numberOfSubjects);

for subjectIdx = 1:numberOfSubjects
    selfSelectedVelocity10(subjectIdx) = mean(subjects(subjectIdx).targetVel);
    selfSelectedVelocity10STD(subjectIdx) = std(subjects(subjectIdx).targetVel);
end





%% Velocity depending on force

figure;
forceSpectrum = (-3.2:0.4:3.2)';
velocitySpectrum = zeros(length(forceSpectrum), numberOfSubjects);
velocitySpectrumSTD = zeros(length(forceSpectrum), numberOfSubjects);
spectrumLinearization = zeros(2,numberOfSubjects);

for subjectIdx = 1:numberOfSubjects
    velocitySpectrum(:,subjectIdx) = mean(subjects(subjectIdx).spectrum.velocity, 2);
    velocitySpectrumSTD(:,subjectIdx) = std(subjects(subjectIdx).spectrum.velocity, 0, 2);
    spectrumLinearization(:,subjectIdx) = polyfit(forceSpectrum,velocitySpectrum(:,subjectIdx),1)';
    
    if 1
%         hold off
        scatter(forceSpectrum, velocitySpectrum(:,subjectIdx)/selfSelectedVelocity10(subjectIdx))
        hold on
        plot(forceSpectrum, polyval(spectrumLinearization(:,subjectIdx)', forceSpectrum)/selfSelectedVelocity10(subjectIdx));
    end
end


% normalizationParameter = selfSelectedVelocity10;
normalizationParameter = spectrumLinearization(2,:);


figure
boxplot([selfSelectedVelocity10; spectrumLinearization(2,:)]', 'Labels', {'10%', '60%'});
ylabel('Self selected velocity (m/s)')




meanSpectrumPoly = mean(spectrumLinearization./normalizationParameter, 2);
stdSpectrumPoly = std(spectrumLinearization./normalizationParameter, 0, 2);


figure
plot(forceSpectrum, mean(velocitySpectrum./normalizationParameter, 2))
hold on
plot(forceSpectrum, mean(velocitySpectrum./normalizationParameter, 2)+std(velocitySpectrum./normalizationParameter, 0, 2))
plot(forceSpectrum, mean(velocitySpectrum./normalizationParameter, 2)-std(velocitySpectrum./normalizationParameter, 0, 2))

plot(forceSpectrum, polyval(meanSpectrumPoly', forceSpectrum));

xlabel('AP force (%)')
ylabel('Normalized self selected velocity')


figure
subplot(2,1,1)
boxplot((velocitySpectrum./velocitySpectrum(end/2+0.5,:))', 'Labels', {'-3.2', '-2.8', '-2.4', ...
    '-2.0', '-1.6', '-1.2', '-0.8', '-0.4', '0.0', '0.4', '0.8', '1.2', '1.6', '2.0', '2.4', ...
    '2.8', '3.2'})
ylabel('Normalized velocity')
title('Normalized by velocity at 0% AP force')
xlabel('AP force (%)')


subplot(2,1,2)
boxplot((velocitySpectrum./selfSelectedVelocity10)', 'Labels', {'-3.2', '-2.8', '-2.4', ...
    '-2.0', '-1.6', '-1.2', '-0.8', '-0.4', '0.0', '0.4', '0.8', '1.2', '1.6', '2.0', '2.4', ...
    '2.8', '3.2'})
ylabel('Normalized velocity')
title('Normalized by velocity at 10% BWS')
xlabel('AP force (%)')



%% Force needed to compensate for attachment

figure

forceRequiredBack = zeros(numberOfSubjects, 1);
forceRequiredMiddle = zeros(numberOfSubjects, 1);
forceRequiredFront = zeros(numberOfSubjects, 1);
forceRequiredLooped = zeros(numberOfSubjects, 1);

intermediatePlots = true;


numberOfDataPointsToSkip = 0;


for subjectIdx = 1:numberOfSubjects
    % back
    forces = subjects(subjectIdx).stitched.back(1+numberOfDataPointsToSkip:end,1);
    velocities = mean(subjects(subjectIdx).stitched.back(1+numberOfDataPointsToSkip:end,2:3), 2) / normalizationParameter(subjectIdx);
    P = polyfit(forces,velocities,1);
    velocitiesFit = polyval(P, forces);
    
    forceRequiredBack(subjectIdx) = (1-P(2))/P(1);
    
    if intermediatePlots
        hold off
        scatter(forces, velocities, 'b')
        hold on
        plot(forces, velocitiesFit, 'b')
    end
    
    
    % middle
    forces = subjects(subjectIdx).stitched.mid(1+numberOfDataPointsToSkip:end,1);
    velocities = mean(subjects(subjectIdx).stitched.mid(1+numberOfDataPointsToSkip:end,2:3), 2) / normalizationParameter(subjectIdx);
    P = polyfit(forces,velocities,1);
    velocitiesFit = polyval(P, forces);
    
    forceRequiredMiddle(subjectIdx) = (1-P(2))/P(1);
    
    if intermediatePlots
        scatter(forces, velocities, 'r')
        hold on
        plot(forces, velocitiesFit, 'r')
    end
    
    % front
    forces = subjects(subjectIdx).stitched.front(1+numberOfDataPointsToSkip:end,1);
    velocities = mean(subjects(subjectIdx).stitched.front(1+numberOfDataPointsToSkip:end,2:3), 2) / normalizationParameter(subjectIdx);
    P = polyfit(forces,velocities,1);
    velocitiesFit = polyval(P, forces);
    
    forceRequiredFront(subjectIdx) = (1-P(2))/P(1);
    
    if intermediatePlots
        scatter(forces, velocities, 'g')
        hold on
        plot(forces, velocitiesFit, 'g')
    end
    
    
    % looped
    forces = subjects(subjectIdx).looped(1+numberOfDataPointsToSkip:end,1);
    velocities = mean(subjects(subjectIdx).looped(1+numberOfDataPointsToSkip:end,2:3), 2) / normalizationParameter(subjectIdx);
    P = polyfit(forces,velocities,1);
    velocitiesFit = polyval(P, forces);
    
    forceRequiredLooped(subjectIdx) = (1-P(2))/P(1);
    
    if intermediatePlots
        scatter(forces, velocities, 'c')
        hold on
        plot(forces, velocitiesFit, 'c')
        
        plot([-5, 5], [1, 1])
    end
    
    
end

figure
boxplot([forceRequiredBack, forceRequiredMiddle, forceRequiredFront, forceRequiredLooped], ...
    'Labels', {'Back', 'Both', 'Front', 'Looped'})

title('Force required to obtain normal walking velocity')
ylabel('Force (%)')
xlabel('Type of attachment')

%% Self selected force

selfSelectedForce = zeros(2,numberOfSubjects);

for subjectIdx = 1:numberOfSubjects
    selfSelectedForce(:, subjectIdx) = subjects(subjectIdx).adjust';
end

mean(selfSelectedForce, 2)
std(selfSelectedForce, 0, 2)

mean(diff(selfSelectedForce))

figure
boxplot(selfSelectedForce', 'Labels', {'Negative start', 'Positive start'})
title('Self selected force')
ylabel('Force (%)')







