clear all ; close all ; clc ;
folder = 'C:\Users\Roy\Documents\.2019 - TUDELFT\7 - BioMechMotionLab\5-Device Inspection\DatasSlingbarExpe';
addpath(genpath(folder));

subjectsToProcess = {'B1' ; 'B2' ; 'B3' ; 'B4';
                     'B5' ; 'B6' ; 'B7' ; 'B8';
                     'B9' ; 'B10'; 'B11'; 'B12';
                     'B13'; 'B14'; 'B15'};
                        
% subjectsToProcess = {'A1' ; 'A2' ; 'A3' ; 'A4' ;
%                      'A5' ; 'A6' ; 'A7' ; 'A8' ;
%                      'A9' ; 'A10'; 'A11'; 'A12';
%                      'A13'; 'A14' };


% subjectsToProcess = {'B1' ; 'B2' ; 'B3' ; 'B4';
%                      'B5' ; 'B6' ; 'B7' ; 'B8';
%                      'B9' ; 'B10'; 'B11'; 'B12';
%                      'B13'; 'B14'; 'B15';
%                      'A1' ; 'A2' ; 'A3' ; 'A4' ;
%                      'A5' ; 'A6' ; 'A7' ; 'A8' ;
%                      'A9' ; 'A10'; 'A11'; 'A12';
%                      'A13'; 'A14' };
                     

for i = 1:length(subjectsToProcess)
    load([subjectsToProcess{i} '.mat']);  
end

% Looped vs. Stiched conditions
% For now, takes the minimum difference
% Fitting a trend and estimating a value would be more accurate
for i = 1:length(subjectsToProcess)
    eval(['evaluateMeanTargetStitchedBack = nanmean(' subjectsToProcess{i} '.targetVel);']);
    eval(['diffWantedStitchedBack = abs(mean(' subjectsToProcess{i} '.stitched.back(:,2:3)'')-evaluateMeanTargetStitchedBack);']);
    [pks, loc] = min(diffWantedStitchedBack);
    eval(['forceWantedStitchedBack = ' subjectsToProcess{i} '.stitched.back(loc,1);']);
    clearvars evaluateMeanTargetStitchedBack diffWantedStitchedBack pks loc

    eval(['evaluateMeanTargetStitchedFront = nanmean(' subjectsToProcess{i} '.targetVel);']);
    eval(['diffWantedStitchedFront = abs(mean(' subjectsToProcess{i} '.stitched.front(:,2:3)'')-evaluateMeanTargetStitchedFront);']);
    [pks, loc] = min(diffWantedStitchedFront);
    eval(['forceWantedStitchedFront = ' subjectsToProcess{i} '.stitched.front(loc,1);']);
    clearvars evaluateMeanTargetStitchedFront diffWantedStitchedFront pks loc
    
    eval(['evaluateMeanTargetStitchedMid = nanmean(' subjectsToProcess{i} '.targetVel);']);
    eval(['diffWantedStitchedMid = abs(mean(' subjectsToProcess{i} '.stitched.mid(:,2:3)'')-evaluateMeanTargetStitchedMid);']);
    [pks, loc] = min(diffWantedStitchedMid);
    eval(['forceWantedStitchedMid = ' subjectsToProcess{i} '.stitched.mid(loc,1);']);
    clearvars evaluateMeanTargetStitchedMid diffWantedStitchedMid pks loc
    
    eval(['evaluateMeanTargetLooped = nanmean(' subjectsToProcess{i} '.targetVel);']);
    eval(['diffWantedLooped = abs(mean(' subjectsToProcess{i} '.looped(:,2:3)'')-evaluateMeanTargetLooped);']);
    [pks, loc] = min(diffWantedLooped);
    eval(['forceWantedLooped = ' subjectsToProcess{i} '.looped(loc,1);']);
    clearvars evaluateMeanTargetLooped diffWantedLooped pks loc
    
        
    store(:,i) = [forceWantedStitchedBack ; forceWantedStitchedMid ;  forceWantedStitchedFront ; forceWantedLooped];
end

names = {'Stitched Back','Stitched Mid','Stitched Front', 'Looped'};
a= figure ; boxplot(store',names);
ylabel('Force (\%)','Interpreter','latex')
title ('Force applied to counteract the effect of the attachment type','Interpreter','latex')
% Spectrum Plot
xForceVector = B1.spectrum(:,1)';

for i = 1:length(subjectsToProcess)
   eval(['dataVector = ' subjectsToProcess{i} '.spectrum(:,2:5);']);
   eval(['valuesPersonalForce = ' subjectsToProcess{i} '.adjust;']);
   meanDataVector = mean(dataVector');
   storeMeans(:,i) = meanDataVector;
   %storeNormalizedMean(:,i) =  meanDataVector-meanDataVector(9);
   storeValues(:,i) = valuesPersonalForce;
   % Real normalization to the preferred walking velocity
   eval(['meanTargetVel = nanmean(' subjectsToProcess{i} '.targetVel);']);

   storeNormalized(:,(i*4)-3) = dataVector(:,1)/meanTargetVel;
   storeNormalized(:,(i*4)-2) = dataVector(:,2)/meanTargetVel;
   storeNormalized(:,(i*4)-1) = dataVector(:,3)/meanTargetVel;
   storeNormalized(:,(i*4)) = dataVector(:,4)/meanTargetVel;
   storeNormalizedMean(:,i) = ((dataVector(:,1)/meanTargetVel)+(dataVector(:,2)/meanTargetVel)+(dataVector(:,3)/meanTargetVel)+(dataVector(:,4)/meanTargetVel))/4;
   
   eval([ 'storeWeight(:,i) = ' subjectsToProcess{i} '.weight;']);
   clearvars dataVector   
end
figure; plot(xForceVector,storeMeans);
xlim([-3.2 3.2])
ylim([0.5 1.85])
xlabel('Force (\%)','Interpreter','latex')
ylabel('Velocity (m/s)','Interpreter','latex')

figure ; plot(xForceVector,storeNormalized)
xlim([-3.2 3.2])
ylim([0.4 1.9])
xlabel('Force (\%)','Interpreter','latex')
ylabel('Velocity (m/s)','Interpreter','latex')

% figure ; vs = violinplot(storeNormalized', num2cell(xForceVector))
% xlabel('Force (\%)','Interpreter','latex')
% ylabel('Velocity (m/s)','Interpreter','latex')
% title('Spectrum velocity vs. force', 'Interpreter', 'latex');
% p = polyfit(xForceVector, mean(storeNormalized'), 3);
% regression = polyval(p, xForceVector);
% hold on ; plot(regression, 'red', 'LineWidth', 2)

%% order the datas for function fitting (1D vectors)
LW = length(storeWeight);
LF = length(xForceVector);
LNM = length(storeNormalizedMean);

for i = 1:LW
    for j = 1:LF
        storeWeightNew((i*LF)-LF+j) = storeWeight(i);
    end    
end
storeWeightNew = storeWeightNew';

for i = 1:LW
        storeForceVectorNew((i*LF)-LF+1:(i*LF)) = xForceVector;
        storeMeanNew((i*LF)-LF+1:(i*LF)) = storeNormalizedMean(:,i)';
end
storeForceVectorNew = storeForceVectorNew';
storeMeanNew = storeMeanNew';

sf = fit([storeWeightNew, storeForceVectorNew],storeMeanNew,'poly23');

figure;
plot(sf,[storeWeightNew, storeForceVectorNew],storeMeanNew);
xlabel('Weight (kg)','Interpreter', 'latex')
ylabel('Force (\%)','Interpreter','latex')
zlabel('Velocity (m/s)','Interpreter','latex')