# Artifact: Deductive verification of SYCL in VerCors 

## Paper Submission & DOI
SEFM'24 Submission: 31

DOI: 10.4121/45d37292-cce5-4fb7-8d4e-a1b32cfa3028

DOI URL: [here](https://doi.org/10.4121/45d37292-cce5-4fb7-8d4e-a1b32cfa3028)

SHA256 checksum of ZIP: `not in ZIP/image`

Private Temporary Link: [here](https://data.4tu.nl/private_datasets/euq0yXSuT6E72kA-eXDMSx1taquzEiOnVo1ZaLaC8pA)

Please use the private temporary link. The DOI link is currently not active due to the artifact being under review on the 4TU archive (i.e. a check whether everything has been filled in etc.). Once the artifact passes their checks, the DOI and URL will become active. 

## Abstract
This artifact is accompanied by the paper "Deductive verification of SYCL in VerCors" (paper submission 31). It is a Docker image containing a version of the VerCors toolset with SYCL support. The image includes both the SYCL feature tests and the two full examples from the paper. Accompanying these files are two scripts to automatically run the examples and feature tests. 

The README (as specified on the artifact page of SEFM 2024) contains all the necessary information on setting up the artifact, how to do some initial testing, how to run examples and how to run the scripts to execute all the tests.


The ZIP consists of the following files (from the root of the ZIP):
- `SEFM24_paper_31.pdf`: A copy of the paper "Deductive verification of SYCL in VerCors" with paper submission 31.
- `Dockerfile`: The Dockerfile on which the artifact Docker image is based.
- `LICENSE.txt`: The license for the artifact and the included examples.
- `README.md`: A README containing all the necessary information.
- `feature-tests/`: A directory containing all the feature tests of VerCors related to SYCL.
- `full-examples/`: A directory containing the full examples mentioned in Section 7.2 of the paper.
- `run-all-feature-tests.sh`: A script to run all the tests in the `feature-tests` folder.
- `run-full-examples.sh`: A script to run all the tests in the `full-examples` folder.
- `sycl-sefm24.tar`: The docker image to run.

These files have also been added in the root of the ZIP for your convenience.

DOI: 10.4121/45d37292-cce5-4fb7-8d4e-a1b32cfa3028

DOI URL: [here](https://doi.org/10.4121/45d37292-cce5-4fb7-8d4e-a1b32cfa3028)

SHA256 checksum of ZIP: `not in ZIP/image`

We would like to apply for the Functional and Available badge. 

# Hardware Requirements, Proprietary Software, Data Requirements and Replication with Limited Resources

There are no special hardware requirements. This artifact has been made/tested on an Intel MacBook 2020 with a 2GHz quad core CPU and 16 GB's of RAM. No additional software or data is required. There are no replications that need large amount of resources. Please see "Replication Instructions".

# Setup
The `Dockerfile`, from which the Docker image `sycl_sefm24.tar` was built, can be found in the root of the ZIP. The image is based on the VerCors Docker image with tag `2.1.1` (containing VerCors 2.1.1) on DockerHub. To import the artifact image run the following command:

```bash
docker image load -i sycl-sefm24.tar
```

All further commands assume that you are typing in a shell in the docker image. To enter the docker image, run:

```bash
docker run -it vercors-sycl-sefm24:latest sycl_sefm24
```

Please note that all supporting files are copied into the container at the path `/data`, and repeated in the zip archive for your convenience.


# Test Instructions
Execute `vercors --version`. The expected output is something similar to:

```bash
root@57b295972741:/data# vercors --version
VerCors 2.1.1
```

Execute `ls -al`. The executed output is something similar to:

```
root@8d0dbe8802bd:/data# ls -al
total 72
drwxr-xr-x 1 root root  4096 Jun 19 08:02 .
drwxr-xr-x 1 root root  4096 Jun 19 08:02 ..
-rw-r--r-- 1 root root    97 Apr 11 12:34 Dockerfile
-rw-r--r-- 1 root root 17331 Jun 13 13:07 LICENSE.txt
-rw-r--r-- 1 root root  5621 Jun 19 08:00 README.md
-rw-r--r-- 1 root root     0 Jun 13 13:48 SEFM24_paper_31.pdf
drwxr-xr-x 6 root root  4096 Jun 13 13:07 feature-tests
drwxr-xr-x 2 root root  4096 Jan 23 12:43 full-examples
-rwxr-xr-x 1 root root  1053 Jun 13 12:55 run-all-feature-tests.sh
-rwxr-xr-x 1 root root   636 Jun 13 13:10 run-full-examples.sh
```

If not, please change your directory to the `/data` folder.

#  Replication Instructions: 
The two examples in Section 7.2 of the paper can be found in the folder `full-examples`. Program 1 can be found in the file `VectorAdd.cpp` and Program 2 can be found in the file `MatrixTransposeWithF.cpp`.

To run the examples, one can either run the script named `run-full-examples.sh` (taking around 10 minutes) or one of the following lines to run the examples individually:

```bash 
vercors --no-infer-heap-context-into-frame VectorAdd.cpp # For Program 1
vercors --no-infer-heap-context-into-frame MatrixTransposeWithF.cpp # For Program 2
```

To run the tests related to different SYCL features, you can either run the script named `run-all-feature-tests.sh` (taking around 1.5 to 2 hours), these tests correspond to the tests reported in Table 11 of Section 7.1 of the paper. 

These can also be invoked individually with VerCors as has been done for Programs 1 and 2.

## Replication Times
The script `run-full-examples.sh` takes around 10 minutes to run and the script `run-all-feature-tests.sh` takes around 1,5 to 2 hours to run.


## Profiling data
The profiling data from Table 12 in Section 7.2 can be generated by adding the `--profile` flag to VerCors. By adding this flag, VerCors will generate a file called `profile.pprof.gz`. 

To inspect the profiling data, we refer to VerCors' documentation on [Profiling](https://github.com/utwente-fmt/vercors/wiki/Profiling).


# Example of usage
To verify a SYCL file `myfile.cpp` in directory `mydir`, invoke VerCors as follows:

```bash
vercors --no-infer-heap-context-into-frame mydir/myfile.cpp
```