clear all
close all
clc

%Defining parameters
Lsys = 7.5e-5; %Length of nanochannel [m]
T0 = 293; %[K]
kB = 1.38e-23; %constant of Boltzmann
e = 1.609e-19; % [C]
Vref = kB*T0/e;
nn = 1;

%% Importing and calculations on the data 

% Temperature iso Low
IsoLow_TotalCurrent = importdata('IsoLow_TotalCurrent.txt');
IsoLow_Selectivity = importdata('IsoLow_Selectivity.txt');

% IsoLow_CurrRect = abs(IsoLow_TotalCurrent(1:16,2))./abs(IsoLow_TotalCurrent(17:32,2));

IsoLow_TotalCurrent = [-flipud(IsoLow_TotalCurrent(1:16,:)); IsoLow_TotalCurrent(1:16,:)];
IsoLow_Selectivity = [flipud(IsoLow_Selectivity(1:16,:)); IsoLow_Selectivity(1:16,:)];

% Temperature iso High
IsoHigh_TotalCurrent = importdata('IsoHigh_TotalCurrent.txt');
IsoHigh_Selectivity = importdata('IsoHigh_Selectivity.txt');

% IsoHigh_CurrRect = abs(IsoHigh_TotalCurrent(1:16,2))./abs(IsoHigh_TotalCurrent(17:32,2));
% 
IsoHigh_TotalCurrent = [-flipud(IsoHigh_TotalCurrent(1:16,:)); IsoHigh_TotalCurrent(1:16,:)];
IsoHigh_Selectivity = [flipud(IsoHigh_Selectivity(1:16,:)); IsoHigh_Selectivity(1:16,:)];

% Temperature LR
LR_TotalCurrent = importdata('LR_TotalCurrent.txt');
LR_Selectivity = importdata('LR_Selectivity.txt');

LR_CurrRect = abs(LR_TotalCurrent(17:32,2))./abs(LR_TotalCurrent(1:16,2));

LR_TotalCurrent = [flipud(LR_TotalCurrent(1:16,:)); LR_TotalCurrent(17:32,:)];
LR_Selectivity = [flipud(LR_Selectivity(1:16,:)); LR_Selectivity(17:32,:)];

% % Temperature RL
% RL_TotalCurrent = importdata('RL_TotalCurrent.txt');
% RL_Selectivity = importdata('RL_Selectivity.txt');
% 
% RL_CurrRect = abs(RL_TotalCurrent(1:16,2))./abs(RL_TotalCurrent(17:32,2));
% 
% RL_TotalCurrent = [flipud(RL_TotalCurrent(1:16,:)); RL_TotalCurrent(17:32,:)];
% RL_Selectivity = [flipud(RL_Selectivity(1:16,:)); RL_Selectivity(17:32,:)];

% Calculating field strength
Eapp = LR_TotalCurrent(:,1);
dimVapp = Eapp.*Lsys./Vref;
V_spline = linspace(0,max(dimVapp),1000);
V_spline = linspace(min(dimVapp),max(dimVapp),1000);
%% Plotting data

colormap lines
map = colormap;
map = [242 95 92; 255 224 102;80 81 79; 112 193 179; 36 123 160]./255; 


figure(nn)
hold on
h1 = loglog(dimVapp(1:32),IsoLow_TotalCurrent(:,2),'d', 'color', map(4,:))
set(h1, 'MarkerFaceColor', get(h1, 'Color'));
yy = spline(dimVapp(1:32),IsoLow_TotalCurrent(:,2),V_spline);
i = loglog(V_spline,yy,'--');
set(i, 'Color', get(h1, 'Color'));

h2 = loglog(dimVapp(1:32),IsoHigh_TotalCurrent(:,2),'d', 'color', map(1,:))
set(h2, 'MarkerFaceColor', get(h2, 'Color'));
yy = spline(dimVapp(1:32),IsoHigh_TotalCurrent(:,2),V_spline);
i = loglog(V_spline,yy,'--');
set(i, 'Color', get(h2, 'Color'));


V_spline = linspace(min(dimVapp),max(dimVapp),1000);

h3 = loglog(dimVapp,LR_TotalCurrent(:,2),'d', 'color', map(3,:))
set(h3, 'MarkerFaceColor', get(h3, 'Color'));
yy = spline(dimVapp,LR_TotalCurrent(:,2),V_spline);
i = loglog(V_spline,yy,'--');
set(i, 'Color', get(h3, 'Color'));

% h4 = loglog(dimVapp,RL_TotalCurrent(:,2),'d', 'color', map(3,:))
% set(h4, 'MarkerFaceColor', get(h4, 'Color'));
% yy = spline(dimVapp,RL_TotalCurrent(:,2),V_spline);
% i = loglog(V_spline,yy,'--');
% set(i, 'Color', get(h4, 'Color'));

XaxisLabel = xlabel('Applied potential \phi')
YaxisLabel = ylabel('Total current J')
% title('Total current')
h_legend = legend([h1 h2 h3],{'T_L = T_R = 293 K','T_L = T_R = 313 K','T_L = 313 K, T_R = 293 K'},'Location','NorthWest')
legend boxoff
box on
saveas(nn, 'TotalCurrent', 'png')
matlab2tikz('AR1_totalCurrent.tex')
nn = nn+1;

figure(nn)
hold on

% V_spline = linspace(0,max(dimVapp),1000);

h1 = loglog(dimVapp(1:32),IsoLow_Selectivity(:,2),'d', 'color', map(4,:))
set(h1, 'MarkerFaceColor', get(h1, 'Color'));
yy = spline(dimVapp(1:32),IsoLow_Selectivity(:,2),V_spline);
i = loglog(V_spline,yy,'--')
set(i, 'Color', get(h1, 'Color'));

h2 = loglog(dimVapp(1:32),IsoHigh_Selectivity(:,2),'d', 'color', map(1,:))
set(h2, 'MarkerFaceColor', get(h2, 'Color'));
yy = spline(dimVapp(1:32),IsoHigh_Selectivity(:,2),V_spline);
i = loglog(V_spline,yy,'--');
set(i, 'Color', get(h2, 'Color'));

V_spline = linspace(min(dimVapp),max(dimVapp),1000);


h3 = loglog(dimVapp,LR_Selectivity(:,2),'d', 'color', map(3,:))
set(h3, 'MarkerFaceColor', get(h3, 'Color'));
yy = spline(dimVapp,LR_Selectivity(:,2),V_spline);
i = loglog(V_spline,yy,'--');
set(i, 'Color', get(h3, 'Color'));

% h4 = loglog(dimVapp,RL_Selectivity(:,2),'d', 'color', map(3,:))
% set(h4, 'MarkerFaceColor', get(h4, 'Color'));
% yy = spline(dimVapp,RL_Selectivity(:,2),V_spline);
% i = loglog(V_spline,yy,'--');
% set(i, 'Color', get(h4, 'Color'));

XaxisLabel = xlabel('Applied potential \phi')
YaxisLabel = ylabel('Selectivity')
h_legend = legend([h1 h2 h3],{'T_L = T_R = 293 K','T_L = T_R = 313 K','T_L = 313 K, T_R = 293 K'},'Location','NorthWest')
legend boxoff
box on
saveas(nn, 'Selectivity', 'png')
matlab2tikz('AR1_Selectivity.tex')

nn = nn+1;

V_spline = linspace(0,300,1000);

figure(nn)
hold on
% h1 = loglog(dimVapp(17:32),IsoLow_CurrRect,'d', 'color', map(4,:))
% set(h1, 'MarkerFaceColor', get(h1, 'Color'));
% yy = spline(dimVapp(17:32),IsoLow_CurrRect,V_spline);
% i = loglog(V_spline,yy,'--')
% set(i, 'Color', get(h1, 'Color'));

% h2 = loglog(dimVapp(17:32),IsoHigh_CurrRect,'d', 'color', map(1,:))
% set(h2, 'MarkerFaceColor', get(h2, 'Color'));
% yy = spline(dimVapp(17:32),IsoHigh_CurrRect,V_spline);
% i = loglog(V_spline,yy,'--')
% set(i, 'Color', get(h2, 'Color'));

h3 = plot(dimVapp(17:32),LR_CurrRect,'d', 'color', map(3,:))
set(h3, 'MarkerFaceColor', get(h3, 'Color'));
yy = spline(dimVapp(17:32),LR_CurrRect,V_spline);
i = loglog(V_spline,yy,'--')
set(i, 'Color', get(h3, 'Color'));

% h4 = loglog(dimVapp(17:32),RL_CurrRect,'d', 'color', map(3,:))
% set(h4, 'MarkerFaceColor', get(h4, 'Color'));
% yy = spline(dimVapp(17:32),RL_CurrRect,V_spline);
% i = loglog(V_spline,yy,'--')
% set(i, 'Color', get(h4, 'Color'));


XaxisLabel = xlabel('Applied potential \phi (V_{th})')
YaxisLabel = ylabel('Rectification (-)')
% h_legend = legend([h3],{'LR'},'Location','NorthEast')
% legend boxoff
box on
saveas(nn, 'Rectification', 'png')
matlab2tikz('AR1_Rectification.tex')

nn = nn+1;

% figure(nn)
% hold on
% h1 = loglog(dimVapp,IsoLow_TotalCurrent(:,2),'d', 'color', map(4,:))
% set(h1, 'MarkerFaceColor', get(h1, 'Color'));
% yy = spline(dimVapp,IsoLow_TotalCurrent(:,2),V_spline);
% i = loglog(V_spline,yy,'--');
% set(i, 'Color', get(h1, 'Color'));
% 
% h2 = loglog(dimVapp,IsoHigh_TotalCurrent(:,2),'d', 'color', map(1,:))
% set(h2, 'MarkerFaceColor', get(h2, 'Color'));
% yy = spline(dimVapp,IsoHigh_TotalCurrent(:,2),V_spline);
% i = loglog(V_spline,yy,'--');
% set(i, 'Color', get(h2, 'Color'));
% 
% h3 = loglog(dimVapp,LR_TotalCurrent(:,2),'d', 'color', map(2,:))
% set(h3, 'MarkerFaceColor', get(h3, 'Color'));
% yy = spline(dimVapp,LR_TotalCurrent(:,2),V_spline);
% i = loglog(V_spline,yy,'--');
% set(i, 'Color', get(h3, 'Color'));
% 
% % h4 = loglog(dimVapp,RL_TotalCurrent(:,2),'d', 'color', map(3,:))
% % set(h4, 'MarkerFaceColor', get(h4, 'Color'));
% % yy = spline(dimVapp,RL_TotalCurrent(:,2),V_spline);
% % i = loglog(V_spline,yy,'--');
% % set(i, 'Color', get(h4, 'Color'));
% 
% XaxisLabel = xlabel('Applied potential \phi')
% YaxisLabel = ylabel('Total current J')
% % axis([-100 100 -0.001 0.001])
% % title('Total current')
% h_legend = legend([h1 h2 h3 h4],{'IsoLow','IsoHigh','LR','RL'},'Location','NorthWest')
% legend boxoff
% % saveas(nn, 'TotalCurrent', 'png')
% % matlab2tikz('AR9_totalCurrent.tex')
% nn = nn+1;
