# Final analysis made during review process

 library(corrplot)
 library(plyr)
 library(dplyr)
 library(Hmisc)
 
 
 ## 1. set working directories (adapt to your own path)
 wd_data  <- "~/Final_repository/Data"
 wd_codes    <- "~/Final_repository/Codes"
 
 ## 2. full datasets 
 setwd(wd_data)
 full_dataset <- read.csv('full_dataset.csv')
 full_dataset_Srare <- subset(full_dataset, (!is.na(full_dataset$Srare))) # subset only plots with Srare values
 dataset_Srare_dist_unscaled <- subset(full_dataset_Srare, forest_category_2=="disturbed forests")
 dataset_Srare_undist_unscaled <- subset(full_dataset_Srare, forest_category_2!="disturbed forests")
 dataset_AGB_dist <- read.csv('dataset_AGB_dist.csv') #scaled
 dataset_relative_dist <- read.csv('dataset_relAGB_similarity_dist.csv') #scaled and with adjusted similarity values
 
##### 1. COLLINEARITY #####
 
 # Collinearity between AGB 
 var_CWD <- dplyr::select(dataset_AGB_dist, CWD, AGB_CWD_ha)
 all_cor <- rcorr(as.matrix(var_CWD), type = c("spearman"))
 M_all <- all_cor$r
 p_mat_all<- all_cor$P
 # Create a table to show the correlations (symbolic number coding)
 symnum(M_all, abbr.colnames = FALSE)
 
##### 2. DIFFERENCE BETWEEN DIST AND UNDIST PLOTS #####
 
library(lme4)
library(sjPlot)

fm1.0 <- lmerTest::lmer(AGB_CWD_ha ~ 1 + (1|new_cod_plot), data=full_dataset ,REML=FALSE, na.action='na.fail')
fm1.1 <- lmerTest::lmer(AGB_CWD_ha ~ forest_category_2 + (1|new_cod_plot), data=full_dataset ,REML=FALSE, na.action='na.fail')
summary(fm1.1)

#output
# Fixed effects:
#                                       Estimate Std. Error      df t value Pr(>|t|)    
# (Intercept)                            170.49      20.61  990.99   8.271 4.24e-16 ***
# forest_category_2undisturbed forests    99.84      22.27 1172.77   4.482 8.11e-06 ***
# ---
# Signif. codes:  0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1

AIC(fm1.0, fm1.1)

fm2.0 <- lmerTest::lmer(Srare ~ 1 + (1|new_cod_plot), data=full_dataset_Srare ,REML=FALSE, na.action='na.fail')
fm2.1 <- lmerTest::lmer(Srare ~ forest_category_2 + (1|new_cod_plot), data=full_dataset_Srare ,REML=FALSE, na.action='na.fail')
summary(fm2.1)

#output:
# Fixed effects:
#                                       Estimate Std. Error        df t value Pr(>|t|)    
# (Intercept)                          7.575e+00  1.028e-01 8.512e+02  73.652  < 2e-16 ***
# forest_category_2undisturbed forests 3.916e-01  8.847e-02 1.643e+03   4.426 1.02e-05 ***
# ---
# Signif. codes:  0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1

AIC(fm2.0, fm2.1)

##### 3. WORKING WITH AGB and BA #####
 
describing_plot <- function(data, variable_of_interest, title_main, title_y, ylim_min, ylim_max) {
    
    dataset <- as.data.frame(data)
    dataset$final_variable <-  dataset[,c(variable_of_interest)]
    levels(dataset$forest_category_2) <- gsub(" ", "\n", levels(dataset$forest_category_2))
    
    #plot
    plot <- ggplot(data=dataset, aes(x=forest_category_2, y=final_variable)) + 
       geom_jitter(fill="darkgray", size=0.2)+
       geom_violin(trim  = TRUE, fill="gray", alpha=0.5) +
       geom_boxplot(width=0.1, outlier.size=0.5, notch=FALSE) +
       stat_summary(fun=mean, geom="point", shape=5, size=2) +
       #stat_summary(fun.data=data_summary, col='red')+
       ylim(as.numeric(c(ylim_min, ylim_max))) +
       ylab(title_y) +xlab(NULL)+labs(title= title_main)+
       theme_light()
    plot
 }
 
plot_agb <- describing_plot(full_dataset, "AGB_CWD_ha", 'a.', bquote('AGB (Mg '~ha^-1~')'), '0', '1600')
plot_agb_new <- plot_agb +  annotate("text", x=1.75, y=1450, label= "*", col="blue", size=8)

plot_ba <-  describing_plot(full_dataset, "Basal_area_m2_ha", 'b.', bquote('Basal area ('~m^2~' '~ha^-1~')'), '0', '150')
plot_ba_new <-  plot_ba +  annotate("text", x=1.75, y=125, label= "*", col="blue", size=8)

#test whether there is also a sig. difference between plot categories for basal area
fm3.0 <- lmerTest::lmer(Basal_area_m2_ha ~ 1 + (1|new_cod_plot), data=full_dataset ,REML=FALSE, na.action='na.fail')
fm3.1 <- lmerTest::lmer(Basal_area_m2_ha ~ forest_category_2 + (1|new_cod_plot), data=full_dataset ,REML=FALSE, na.action='na.fail')
summary(fm3.1)

# #Output: 
# Fixed effects:
#     Estimate Std. Error       df t value Pr(>|t|)    
# (Intercept)                            17.983      1.073 1017.906  16.765  < 2e-16 ***
#     forest_category_2undisturbed forests    7.394      1.145 1313.697   6.459 1.48e-10 ***
#     ---
#     Signif. codes:  0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1

#plot together
cowplot::plot_grid(plot_agb_new,plot_ba_new,ncol=2,align="hv")
