# Figure 5 

#load packages
library(plyr)
library(dplyr)
library(ggplot2)
library(ggpubr)
library(ggsignif)
library(grid)
library(gridExtra)


############ A. Set working directories and load full dataset #########

## 1. set working directories (Adapt to own path)
wd_data  <- "~/Final_repository/Data"
wd_codes    <- "~/Final_repository/Codes"

## 2. Load datasets 
setwd(wd_data)
full_dataset <- read.csv('full_dataset.csv')
dataset_Srare <- read.csv('dataset_Srare_dist.csv')
dataset_relSrare_dist <- read.csv('dataset_relSrare_dist.csv')
dataset_relative_dist <- read.csv('dataset_relAGB_similarity_dist.csv')

## 3. Create figure  ##
data_summary <- function(x) {
  m <- mean(x)
  ymin <- m-sd(x)
  ymax <- m+sd(x)
  return(c(y=m,ymin=ymin,ymax=ymax))
}

describing_plot <- function(data, variable_of_interest, title_main, title_y, ylim_min, ylim_max) {
  
  dataset <- as.data.frame(data)
  dataset$final_variable <-  dataset[,c(variable_of_interest)]
  levels(dataset$forest_category_2) <- gsub(" ", "\n", levels(dataset$forest_category_2))
  
  #plot
  plot <- ggplot(data=dataset, aes(x=forest_category_2, y=final_variable)) + 
    geom_violin(trim  = TRUE, fill="gray") +
    geom_boxplot(width=0.1, outlier.size=0.5, notch=FALSE) +
    stat_summary(fun=mean, geom="point", shape=5, size=2) +
    #stat_summary(fun.data=data_summary, col='red')+
    ylim(as.numeric(c(ylim_min, ylim_max))) +
    ylab(title_y) +xlab(NULL)+labs(title= title_main)+
    theme_light()
  plot
}

p1 <- describing_plot(full_dataset, "AGB_CWD_ha", '(a)', bquote('AGB (Mg '~ha^-1~')'), '0', '1600')
p1_new <- p1 +  annotate("text", x=1.5, y=1550, label= "*", size=8)+
                annotate(geom = "segment", x = 1, xend = 2, y = 1525, yend = 1525, color = "grey", linetype = "dashed", size = 0.5)

p2 <- describing_plot(full_dataset, "Srare", '(c)', "Rarefied richness (# spp. per 10 stems)",'0', '10') # for NFI paper
p2_new <- p2 +  annotate("text", x=1.5, y=0.3, label= "*", size=8)+
                annotate(geom = "segment", x = 1, xend = 2, y = 1.10, yend = 1.10, color = "grey", linetype = "dashed", size = 0.5)

p3 <- describing_plot(dataset_relative_dist, "rel_AGB", '(b)', bquote('AGB (%r)'), '0', '700')
p4 <- describing_plot(dataset_relSrare_dist, "rel_Srare", '(d)', bquote('Rarefied richness (%r)'), '0', '175')
p5 <- describing_plot(dataset_relative_dist, "adj_similarity_mean_prc", '(e)', bquote('sp. composition (%r)'), '0', '235')

#Figure_5
cowplot::plot_grid(p1_new,p3,NULL,p2_new,p4,p5, ncol=3,align="hv")
