# Figure 4b and 4c (Barplots)

#load packages
library(plyr)
library(dplyr)
library(ggplot2)

############ A. Set working directories and load full dataset #########

## 1. set working directories (adapt to own path)
wd_data  <- "~/Final_repository/Data"
wd_codes    <- "~/Final_repository/Codes"

## 2. full dataset 
setwd(wd_data)
NFI_dataset <- read.csv('full_dataset.csv')

############ B. Create full dataset of disturbed forests #########
NFI_dataset_dist <- subset(NFI_dataset, forest_category_2=="disturbed forests")

############ C. plot time since disturbance and disturbance intensity

# C1. Time since disturbance
ggplot()+ geom_histogram(aes(x=NFI_dataset_dist$time_since_disturbance, fill=..x..),colour='gray40',  
  breaks=seq(0, 34, by=1))+
  xlab('time since disturbance (years)')+ylab('Number of plots')+
  scale_fill_gradient2(
    low = "#f7fbff",
    high = "#08306b")+
  theme_classic()+
  theme(legend.position='none')

#C2. Disturbance intensity
ggplot()+ geom_histogram(aes(x=NFI_dataset_dist$Absolute_anomaly, fill=..x..),colour='gray40')+
  xlab('disturbance intensity (\u0394NDMI)')+ylab('Number of plots')+
  scale_fill_gradient2(
    low = "#fef0d9",
    high = "#b30000")+
  theme_classic()+
  theme(legend.position='none')
