import numpy as np
import matplotlib.pyplot as plt

# Define the parameters
#p = 0.3  # Probability of success
# p = 0.013109393570
# n_max = 500 # Maximum value of n to plot

# # Calculate the CDF for each n from 0 to n_max
# n_values = np.arange(0, n_max + 1)
# cdf_values = 1 - (1 - p) ** n_values
# scaled_values = n_values * 200e3 / 1e6

# # Calculate the expected value of the geometric distribution
# expected_value = 1 / p

# # Create a figure and axis
# fig, ax1 = plt.subplots(figsize=(8, 6))

# # Plot the CDF on the left y-axis
# ax1.plot(n_values, cdf_values, marker='o', linestyle='-', color='b', label=r'$P(X \leq n)$')
# ax1.set_xlabel('n (Number of generation attempts)')
# ax1.set_ylabel(r'$P(X \leq n)$', color='b')
# ax1.tick_params(axis='y', labelcolor='b')

# # Create a second y-axis for the scaled values
# ax2 = ax1.twinx()
# ax2.plot(n_values, scaled_values, marker='s', linestyle='--', color='r', label=r'$n \times 200 \times 10^3$')
# ax2.set_ylabel('EPR Gen Time (ms)', color='r')
# ax2.tick_params(axis='y', labelcolor='r')

# # Plot the point at the expected value
# n_expected = int(np.floor(expected_value))  # Closest integer value for plotting
# cdf_expected = 1 - (1 - p) ** n_expected
# scaled_expected = n_expected * 200e3 / 1e6

# # Add a point at the expected value (on both axes)
# ax1.plot(n_expected, cdf_expected, 'go', label=f'Expected value at n = {n_expected}')
# ax2.plot(n_expected, scaled_expected, 'go')

# # Add the labels next to the green dots
# ax1.text(n_expected, cdf_expected, f'{cdf_expected:.2f}', color='green', fontsize=12, verticalalignment='bottom', horizontalalignment='right')
# ax2.text(n_expected, scaled_expected, f'{scaled_expected:.1f}', color='green', fontsize=12, verticalalignment='top', horizontalalignment='right')

# # Title and grid
# plt.title(f'Geometric Distribution CDF and Scaled n Values\nwith Success Probability p = {p}')
# ax1.grid(True)

# # Show the plot
# plt.legend(loc='upper left')
# plt.show()
import numpy as np
import matplotlib.pyplot as plt
from scipy.stats import nbinom

def plot_geometric_distribution(P, K, n_max):
    # Generate the number of trials (n) from 1 to n_max
    n_values = np.arange(1, n_max + 1)
    n_values_bin = n_values
    
    # Calculate the probability of K successes in <= n trials
    # Using the negative binomial distribution (which is related to the geometric distribution)
    prob_k_successes = nbinom.cdf(n_values - K, K, P)
    
    # Calculate n * 200e3 / 1e6
    n_scaled = n_values * 200e3 / 1e6
    
    # Calculate the expected number of trials to achieve K successes
    expected_trials = K / P
    
    # Create the plot
    fig, ax1 = plt.subplots()
    
    # Plot the probability on the left Y-axis
    color = 'tab:blue'
    ax1.set_xlabel('Number of Attempts (n)')
    ax1.set_ylabel(f'Probability of {K} Successes in <= n Trials', color=color)
    ax1.plot(n_values, prob_k_successes, color=color, label='Probability')
    ax1.tick_params(axis='y', labelcolor=color)
    
    # Add a point at the expected value for the probability curve
    expected_prob = nbinom.cdf(expected_trials - K, K, P)
    ax1.scatter(expected_trials, expected_prob, color=color, s=100, label=f'Expected Trials (n={expected_trials:.2f})')
    
    # Create a second Y-axis for the scaled n values
    ax2 = ax1.twinx()
    color = 'tab:red'
    ax2.set_ylabel('n * 200e3 / 1e6', color=color)
    ax2.plot(n_values, n_scaled, color=color, label='Scaled n')
    ax2.tick_params(axis='y', labelcolor=color)
    
    # Add a point at the expected value for the scaled n curve
    expected_scaled = expected_trials * 200e3 / 1e6
    ax2.scatter(expected_trials, expected_scaled, color=color, s=100, label=f'Expected Trials (n={expected_trials:.2f})')
    
    # Title and show the plot
    plt.title(f'Probability of {K} Successes in <= n Trials vs. n')
    fig.tight_layout()
    
    # Add legends
    ax1.legend(loc='upper left')
    ax2.legend(loc='upper right')
    
    plt.show()

# Example usage:
P = 0.013109393570  # Probability of success
K = 3    # Number of successes
n_max = 500  # Maximum number of trials to consider

plot_geometric_distribution(P, K, n_max)