%- set figure size
%set(groot,'default')
set(groot,'defaultFigurePosition',[680 558 560 420]);
set(groot,'defaultFigurePaperPositionMode','auto');
set(groot,'defaultFigurePaperType','A4');
set(groot,'defaultFigurePaperSize',[21 29.7]);
set(groot,'defaultFigureColor','w');

%- obtain default settings
optionObj   = get(groot,'factory');
optionNames = fieldnames(optionObj);

%- set default interpreter [loop through interpreters]
findOptionString  = 'Interpreter';
targetOptionNames = {optionNames{contains(optionNames,findOptionString)}};
targetOptionNames =  strrep(targetOptionNames,'factory','default');
for ii = 1 : size(targetOptionNames,2)
   set(groot,targetOptionNames{ii},'latex');
end

%- set default font size
findOptionString  = 'FontSize';
targetOptionNames = {optionNames{contains(optionNames,findOptionString)}};
targetOptionNames =  strrep(targetOptionNames,'factory','default');
for ii = 1 : size(targetOptionNames,2)
    strtemp = strsplit(targetOptionNames{ii},findOptionString);
    if isempty(strtemp{2})
        set(groot,targetOptionNames{ii},11);
    end
end

% - set default font name
findOptionString  = 'FontName';
targetOptionNames = {optionNames{contains(optionNames,findOptionString)}};
targetOptionNames =  strrep(targetOptionNames,'factory','default');
for ii = 1 : size(targetOptionNames,2)
   set(groot,targetOptionNames{ii},'Helvetica');
end

%- set line properties
set(groot,'defaultLineLineWidth',1);

%- set surface properties
set(groot,'defaultSurfaceLineStyle','none');

