%
%  Influence of concentration on sedimentation 
%   of a dense suspension in a viscous fluid
%  [Tariq Shajahan, Wim-Paul Breugem]
%
clc; clear all; close all;

%----------------------------------------------------------
% Figure 1 :
 AS = load('Fig1_CaseA.txt');
 BS = load('Fig1_CaseB.txt');
 CS = load('Fig1_CaseC.txt');
 DS = load('Fig1_CaseD.txt');
 ES = load('Fig1_CaseE.txt');
 FS = load('Fig1_CaseF.txt');
 GS = load('Fig1_CaseG.txt');
 HS = load('Fig1_CaseH.txt');
 IS = load('Fig1_CaseI.txt');
 JS = load('Fig1_CaseJ.txt');

 SS(1 ,1) = 0.0; SS(1,2) = 0.9135819612930195; % Single particle

 figure(1)
 hold on
 plot(AS(:,2),AS(:,3),'LineWidth',2.0)
 plot(BS(:,2),BS(:,3),'LineWidth',2.0)
 plot(CS(:,2),CS(:,3),'LineWidth',2.0)
 plot(DS(:,2),DS(:,3),'LineWidth',2.0)
 plot(ES(:,2),ES(:,3),'LineWidth',2.0)
 plot(FS(:,2),FS(:,3),'LineWidth',2.0)
 plot(GS(:,2),GS(:,3),'LineWidth',2.0)
 plot(HS(:,2),HS(:,3),'LineWidth',2.0)
 plot(IS(:,2),IS(:,3),'LineWidth',2.0)
 plot(JS(:,2),JS(:,3),'LineWidth',2.0)
 plot([0 1000],[-SS(1,2) -SS(1,2)],'--','LineWidth',1.0)
 xlim([0 1100])
 xlabel('$t/\sqrt{g/D_p}$')
 ylabel('$V_s/\sqrt{gD_p}$')

 % Adding labels
 p1 = '$0.5\%$';
 text(0.08+BS(end,2),AS(end,3),p1)
 p1 = '$2\%$';
 text(0.08+BS(end,2),BS(end,3),p1)
 p1 = '$4\%$';                         
 text(0.08+BS(end,2),CS(end,3),p1)
 p1 = '$6\%$';                         
 text(0.04+BS(end,2),DS(end,3),p1)
 p1 = '$8\%$';                         
 text(0.04+BS(end,2),ES(end,3),p1)
 p1 = '$10\%$';
 text(0.04+BS(end,2),FS(end,3),p1)
 p1 = '$15\%$';
 text(0.04+JS(end,2),GS(end,3),p1)
 p1 = '$20\%$';
 text(0.08+JS(end,2),HS(end,3),p1)
 p1 = '$25\%$';
 text(0.08+JS(end,2),IS(end,3),p1)
 p1 = '$30\%$';
 text(0.08+JS(end,2),JS(end,3),p1)


%----------------------------------------------------------
% Figure 2 : Visualization of computational domain


%----------------------------------------------------------
% Figure 3 : 
 DNS = load('Fig3_DNS.txt');
 Exp = load('Fig3_Exp.txt');

 figure(2)
 hold on
 plot(DNS(:,1),DNS(:,2),'k','LineWidth',2.)
 plot(Exp(:,1),Exp(:,2),'.','MarkerSize',30.0)
 xlabel('t [s]')
 ylabel('v [m/s]')
 ylim([-0.1 0])
 xlim([0 1.7])

 
%----------------------------------------------------------
% Figure 4 : Instantaneous snapshots of a slice of the domain 
 

%----------------------------------------------------------
% Figure 5 : 

 PCA_J =load('Fig5_CaseJ_PCA.mat'); % 30%
 PCA_F =load('Fig5_CaseF_PCA.mat'); % 10%
 PCA_A =load('Fig5_CaseA_PCA.mat'); % 0.5%

 Dp = 1.0;
 ang = linspace(0,2.0*pi,50);
 Xcirc = (Dp/2.0) * cos(ang);
 Ycirc = (Dp/2.0) * sin(ang);

 figure(3)
 hold on
 pcolor(PCA_F.Zq,PCA_F.Yq,PCA_F.Phi_sum/mean(mean(PCA_F.Phi_sum)))
 plot(Xcirc,Ycirc,'LineWidth',2.0,'color','red')
 shading flat
 plot([1.344 1.344],[-5. 5.],'--r') 
 plot([-1.344 -1.344],[-5. 5.],'--r') 
 ylabel('$Y/D_P$')
 xlabel('$Z/D_P$')
 ylim([-5*Dp 5*Dp])
 xlim([-5*Dp 5*Dp])
 caxis([0.75 1.25])

 figure(4)
 hold on
 pcolor(PCA_J.Zq,PCA_J.Yq,PCA_J.Phi_sum/mean(mean(PCA_J.Phi_sum)))
 plot(Xcirc,Ycirc,'LineWidth',2.0,'color','red')
 plot(2.*1.156*Xcirc,2.*1.156*Ycirc,'--r','LineWidth',1.5)
 plot(2.*2.094*Xcirc,2.*2.094*Ycirc,'--r','LineWidth',1.5)
 shading flat
 ylabel('$Y/D_P$')
 xlabel('$Z/D_P$')
 ylim([-5*Dp 5*Dp])
 xlim([-5*Dp 5*Dp])
 caxis([0.75 1.25])

 figure(5)
 hold on
 pcolor(PCA_A.Zq,PCA_A.Yq,PCA_A.Phi_sum/mean(mean(PCA_A.Phi_sum)))
 plot(Xcirc,Ycirc,'LineWidth',2.0,'color','red')
 shading flat
 ylabel('$Y/D_P$')
 xlabel('$Z/D_P$')
 ylim([-5*Dp 5*Dp])
 xlim([-5*Dp 5*Dp])
 caxis([0.75 1.25])


%----------------------------------------------------------
% Figure 6 : 

 ang = linspace(0.,2*pi,100);
 Xcirc = 0.5*cos(ang);
 Ycirc = 0.5*sin(ang);

 AvgF0 = load('Fig6a_AvgF0.mat');
 AvgFB = load('Fig6b_AvgFB.mat');
 AvgFJ = load('Fig6c_AvgFJ.mat');

 figure(6)
 hold on
 pcolor(AvgF0.dataX,AvgF0.dataY,AvgF0.data)
 shading flat
 contour(AvgF0.dataX,AvgF0.dataY,AvgF0.data,8,'-k')
 contour(AvgF0.dataX,AvgF0.dataY,AvgF0.data,[0. 0.],'-r')
 plot([0 0],[-2.5 5],'--k','LineWidth',0.5)
 plot([-2 2],[0 0],'--k','LineWidth',0.5)  
 pbaspect([1. 2. 2.])
 xlim([-2. 2.])
 ylim([-2.5 5])
 colorbar
 caxis([0. 1.])
 plot(Xcirc,Ycirc,'LineWidth',2.0,'color','w')
 ylabel('$Y/D_p$')
 xlabel('$X/D_p$')
 yticks([-2.5 0 2.5  5])

 figure(7)
 hold on
 pcolor(AvgFB.dataX, AvgFB.dataY,AvgFB.data);
 shading flat
 contour(AvgFB.dataX, AvgFB.dataY,AvgFB.data,8,'-k')
 contour(AvgFB.dataX, AvgFB.dataY,AvgFB.data,[0. 0.],'-r')
 plot([0 0],[-2.5 5],'--k','LineWidth',0.5)
 plot([-2 2],[0 0],'--k','LineWidth',0.5)  
 pbaspect([1. 2. 2.])
 xlim([-2. 2.])
 ylim([-2.5 5])
 colorbar
 caxis([0. 1.])
 plot(Xcirc,Ycirc,'LineWidth',2.0,'color','w')
 ylabel('$Y/D_p$')
 xlabel('$X/D_p$')
 yticks([-2.5 0 2.5  5])
 
 figure(8)
 hold on
 pcolor(AvgFJ.dataX, AvgFJ.dataY,AvgFJ.data);
 shading flat
 contour(AvgFJ.dataX, AvgFJ.dataY,AvgFJ.data,8,'-k')
 contour(AvgFJ.dataX, AvgFJ.dataY,AvgFJ.data,[0. 0.],'-r')
 plot([0 0],[-2.5 5],'--k','LineWidth',0.5)
 plot([-2 2],[0 0],'--k','LineWidth',0.5)  
 pbaspect([1. 2. 2.])
 xlim([-2. 2.])
 ylim([-2.5 5])
 colorbar
 caxis([0. 1.])
 plot(Xcirc,Ycirc,'LineWidth',2.0,'color','w')
 ylabel('$Y/D_p$')
 xlabel('$X/D_p$')
 yticks([-2.5 0 2.5  5])


%----------------------------------------------------------
% Figure 7 : 

 Ws = load('Fig7_Settling.txt');
 SS(1 ,1) = 0.0; SS(1,2) = 0.9135819612930195; % Single particle

 figure(9)
 hold on
 plot(log10(1.0-Ws(1:end,1)),log10(abs(Ws(1:end,2))),'.','MarkerSize',30.0,'color','black')
 plot(log10(1.0-SS(:,1)),log10(SS(:,2)),'.','MarkerSize',30.0,'color','red')
 plot(log10(1.0-SS(:,1)),log10(0.7575),'.','MarkerSize',30.0,'color','blue')
 xR = xlim;
 xR = linspace(xR(1),xR(2),50);
 yR = 2.997.*xR + -0.1206;
 plot(xR,yR,'--','color','black')
 xlabel('log(1-$\phi$)')
 ylabel('$log(V_s/\sqrt{gD_p})$')

 % Adding labels
 p1 = '$0.5\%$';
 text(log10(1.0-Ws(1,1))-0.02,log10(abs(Ws(1,2))),p1)
 p1 = '$2\%$';
 text(log10(1.0-Ws(2,1))-0.02,log10(abs(Ws(2,2))),p1)
 p1 = '$4\%$';                    
 text(log10(1.0-Ws(3,1))-0.02,log10(abs(Ws(3,2))),p1)
 p1 = '$6\%$';                    
 text(log10(1.0-Ws(4,1))-0.02,log10(abs(Ws(4,2))),p1)
 p1 = '$8\%$';                    
 text(log10(1.0-Ws(5,1))-0.02,log10(abs(Ws(5,2))),p1)
 p1 = '$10\%$';
 text(log10(1.0-Ws(6,1))-0.02,log10(abs(Ws(6,2))),p1)
 p1 = '$15\%$';
 text(log10(1.0-Ws(7,1))-0.02,log10(abs(Ws(7,2))),p1)
 p1 = '$20\%$';
 text(log10(1.0-Ws(8,1))-0.02,log10(abs(Ws(8,2))),p1)
 p1 = '$25\%$';
 text(log10(1.0-Ws(9,1))-0.02,log10(abs(Ws(9,2))),p1)
 p1 = '$30\%$';
 text(log10(1.0-Ws(10,1))-0.02,log10(abs(Ws(10,2))),p1)

%----------------------------------------------------------
% Figure 8 : 

 MSD_A = load('Fig8_MSD.txt');
 tauB = 16.9890;

 figure(10)
 hold on
 plot(log10(MSD_A(:,1)),log10(MSD_A(:,3)),'LineWidth',2.0)
 xR1 = xlim;
 xR = linspace(xR1(1),xR1(2),50);
 l1 = 1.996.*xR -1.376;
 l2 = 1.05.*xR + 0.04786;
 plot(xR,l1,'--k')
 plot(xR,l2,'--k')
 yR = ylim;
 plot([log10(2.0*tauB) log10(2.0*tauB)],[yR(1) yR(2)])
 xlabel('log($\tau$)')
 ylabel('$\log(\overline{Y^2}(\tau))$')

 % Adding labels
 p1 = '$\tau \rightarrow$';
 text(xR(45)-0.1,0.4+l2(45),p1)
 p1 = '$\tau^2 \rightarrow$';
 text(xR(10)-0.1,0.9+l1(10),p1)
 p1 = '$\tau=\tau_L \rightarrow$';
 text(log10(2.0*tauB)-0.8 ,-2,p1)

%----------------------------------------------------------
% Figure 9 : 

 Ga144 = load('Fig9_Tau_Ga144.txt');

 figure(11)
 hold on
 plot(Ga144(:,1),Ga144(:,2),'o','MarkerSize',8,'MarkerFaceColor','red'   ,'MarkerEdgeColor','black','color','k')
 plot(Ga144(:,1),Ga144(:,3),'o','MarkerSize',8,'MarkerFaceColor','blue'  ,'MarkerEdgeColor','black','color','k')
 plot(Ga144(:,1),Ga144(:,4),'o','MarkerSize',8,'MarkerFaceColor','yellow','MarkerEdgeColor','black','color','k')
 xR1 = linspace(0,0.1,20);
 yR1 = -115*xR1 + 18.62;
 xR2 = linspace(0.1,0.3,20);
 xR3 = linspace(0.06,0.3,20);
 yR2 =   3.56*xR1 + 6.619;
 yR3 =  -2.067*xR2 + 4.028;
 plot(xR1,yR1,'--k')
 plot(xR2,yR2,'--k')
 plot(xR3,yR3,'--k')
 xlabel('$\phi$')
 ylabel('$\tau_L/\sqrt{D_p/g}$')
 ylim([0 20])


%----------------------------------------------------------
% Figure 10 : 
 
 SF = load('Fig10_SF.txt');

 phi = linspace(0,1,100);
 ut = -0.7575;
 vs = ut*(1-phi).^3.0;
 phivs = vs.*phi;

 figure(12)
 hold on
 plot(phi,phivs,'--k')
 plot((SF(:,1)),((SF(:,1).*(SF(:,2)))),'.','MarkerSize',20.0)
 ylim([-0.1 0])
 ylabel('$\phi V_s / \sqrt{g D_p}$')
 xlabel('$\phi$')
 xlim([0 0.6])


%----------------------------------------------------------
% Figure 11 : 

 load('Fig11_CKW_D.mat')
 VKW_D = -83.9200000000000e-003; 
 VX = linspace(100.,1000.,100);
 VX1 = 600.;VY1 =60.;
 VY = VKW_D*VX + (VY1-VKW_D*VX1);

 figure(13)
 hold on
 pcolor(tp,zp,Vf/mean(mean(Vf)))
 plot(VX,VY,'-r','LineWidth',2.)
 set(gca,'XTickLabelRotation',45)
 shading flat
 colorbar
 xlabel('$t/\sqrt{D_p/g}$')
 ylabel('$Y/Dp$')
 caxis([0.75 1.25])
 xlim([100. 1000.])
 ylim([0. 100.]);
 pbaspect([2. 1. 1.])


%----------------------------------------------------------
% Figure 12 : 
 
 KWA = load('Fig12_VKW.txt');

 % Sedimentation Flux
 VT  = -0.7458;
 p1  =  2.952;
 phi = linspace(0.,1.,50);
 SF  = VT*phi.*(1.-phi).^p1;

 % Kinematic wave velocity
 VS = VT*(1-phi).^p1;
 VKW = VS.*((1 - ((p1+1).*phi))./(1-phi));
 figure(14)
 hold on
 plot(phi,VKW./VS,'--k')
 plot(KWA(:,1),KWA(:,2)./KWA(:,3),'.','MarkerSize',30.0,'color','red')
 xlim([0 0.4])
 xlabel('$\phi$')
 ylabel('$V_{KW}/V_S$')
