%----------------------------------------------------
%
% Plot the data for concentration
%
%----------------------------------------------------
clc
close all
clear

 load('CKW_D.mat')
 VKW_D = -83.9200000000000e-003; 
 VX = linspace(100.,1000.,100);
 VX1 = 600.;VY1 =60.;
 VY = VKW_D*VX + (VY1-VKW_D*VX1);

 figure(1)
 hold on
 pcolor(tp,zp,Vf/mean(mean(Vf)))
 plot(VX,VY,'-r','LineWidth',2.)
 set(gca,'XTickLabelRotation',45)
 shading flat
 colorbar
 xlabel('$t/\sqrt{D_p/g}$')
 ylabel('$Y/Dp$')
 caxis([0.75 1.25])
 xlim([100. 1000.])
 ylim([0. 100.]);
 pbaspect([2. 1. 1.])
