# -*- coding: utf-8 -*-
"""
Created on Sun Dec  1 01:57:58 2024

@author: LocalAdmin
"""

import pandas as pd

# Load the uploaded CSV file
file_path = './Data-PreProcessed-RemoveNoneExperts&SensitiveInfo-90.csv' #xlsx
survey_data = pd.read_csv(file_path) #read_excel if xlsx

# Display the first few rows to understand its structure
survey_data.head()

import matplotlib.pyplot as plt

plt.rc('font', family = 'Times New Roman')
# plt.figure(1)
# survey_data.iloc[:,45].value_counts()
# survey_data.iloc[:,45].value_counts().plot.pie(figsize =(8,8), autopct='%1.1f%%', explode=[0.05, 0.05, 0.05], counterclock = False)
# plt.ylabel('', fontsize=16)
# plt.savefig('Figure6(b)high_quality_plot.svg')
# plt.show()

#survey_data.iloc[:,8].value_counts().plot.pie().set_title('SeriousDlqin2yrs')
# import scienceplots
#plt.style.use('science')

plt.figure(2)
colors = ['#ff9999','#66b3ff','#99ff99','#ffcc99']
data = survey_data.iloc[:,8].value_counts()

labels = 'I work in a field directly related to automated vehicles: 54','I follow the developments of automated vehicles: 24','I am fairly familiar with the idea of automated vehicles: 12'
ax = data.plot(kind="pie", autopct='%1.1f%%', shadow=False, #True
               explode=[0.02, 0.02, 0.02], 
               colors=colors, legend=True,  labels=labels,
               ylabel='',  labeldistance=None)
ax.legend(bbox_to_anchor=(-0.2, 1.1699), loc='upper left')

#plt.labels('54','24','12', fontsize=16)

plt.ylabel('', fontsize=16)
#plt.title('How familiar are you with the concept of automated vehicles?')
plt.savefig('prof-high_quality_plot1.svg')
#plt.show()


# with plt.style.context('science'):
    
#     plt.figure(3)
#     #colors = ['#ff9999','#66b3ff','#99ff99','#ffcc99']
#     data = survey_data.iloc[:,8].value_counts()
#     ax = data.plot(kind="pie",  autopct='%1.1f%%', shadow=True, explode=[0.05, 0.05, 0.05],
#                    legend=True, title='How familiar are you with the concept of automated vehicles?',
#     ylabel='', labeldistance=None)
#     ax.legend(bbox_to_anchor=(0.8, 1.02), loc='upper left')
#     plt.show()
#     plt.savefig('high_quality_plot.svg')
    
plt.figure(3)
#colors = ['#ff9999','#66b3ff','#99ff99','#ffcc99']
countrydata = survey_data.iloc[:,2].value_counts()
other = sum(countrydata ==1)
countrydata_other = countrydata[0:12]

new_data = pd.Series([other], index=['Other'])  
countrydata_other=countrydata_other.append(new_data)

import numpy as np


# Generate a color list for 13 countries using the 'Set1' colormap  
# The 'Set1' colormap contains 9 unique colors, so we will extend it with additional colors  
colors = plt.cm.get_cmap('Set1', 9)  # Set1 colormap  
color_list = [colors(i) for i in range(9)]  # Get the first 9 colors  

# Manually add some additional colors to ensure we have at least 13 distinct colors  
additional_colors = [  
    '#D2B48C',  # Tan  
    '#ADD8E6',  # Light Blue  
    '#FFD700',  # Gold  
    '#FF69B4',  # Hot Pink  
]  

# Combine the colors into a single list  
color_list.extend(additional_colors)  
# Print the generated color list  
print("Generated Color List (with additional colors):")  
print(color_list)  

# Print the generated color list  
print("Generated Color List (RGB format):")  
print(color_list)  
'''
fig, ax = plt.subplots(figsize=(20, 20)) 
#np.ones(len(countrydata))*0.05
#labels = 'I work in a field directly related to automated vehicles: 54','I follow the developments of automated vehicles: 24','I am fairly familiar with the idea of automated vehicles: 12'
ax = countrydata_other.plot(kind="pie", figsize =(19.9,19.9),autopct='%1.1f%%', shadow=True,
                            explode= np.ones(len(countrydata_other))*0.01, 
                            #colors=colors, #legend=True,  #labels=labels,
                            ylabel='',  labeldistance=1.2, fontsize=19,
                            colors=color_list,  # Use the generated color list  
                            )
#ax.legend(bbox_to_anchor=(-0.2, 1.1699), loc='upper left')
'''


explode = np.ones(len(countrydata_other)) * 0.0369  # 增加爆炸效果  

# Create the pie chart  
fig, ax = plt.subplots(figsize=(12, 12))  # Set the figure size  

wedges, texts, autotexts = ax.pie(  
    countrydata_other,  
    autopct='%1.1f%%',  # show percentage  
    shadow=False, # True
    explode=explode,  # using explode
    colors=color_list,  
    startangle=90,  
    labels=None,  
    labeldistance=0.8  # adjusting distances 
)  

# locate the label of countries  
for i, wedge in enumerate(wedges):  
    angle = (wedge.theta1 + wedge.theta2) / 2.0  
    x = (wedge.r * 0.5) * np.cos(np.deg2rad(angle))  
    y = (wedge.r * 0.5) * np.sin(np.deg2rad(angle))  
    ax.text(x, y, countrydata_other.index[i], ha='center', fontsize=16, verticalalignment='center')  

# percentage  
for i, autotext in enumerate(autotexts):  
    angle = (wedges[i].theta1 + wedges[i].theta2) / 2.0  
    x = (wedges[i].r + 0.1) * np.cos(np.deg2rad(angle))  # percentage location  
    y = (wedges[i].r + 0.1) * np.sin(np.deg2rad(angle))  
    autotext.set_position((x, y))  # percentage  
    autotext.set_color('black')  # colour  
    autotext.set_fontsize(16)  # size  


# Set title and ensure the pie chart is circular  
#plt.title('Country Data Pie Chart', fontsize=24)  # Add a title to the pie chart  
plt.axis('equal')  # Equal aspect ratio to ensure the pie chart is circular 
plt.savefig('Figure6_Use__country-other-high_quality_plot.svg') 
print("Figure saved as country-other-high_quality_plot.svg")  
plt.show()  # Display the pie chart  

#plt.labels(fontsize=16)

#plt.ylabel('', fontsize=16)
#plt.title('How familiar are you with the concept of automated vehicles?')
#plt.savefig('country-other-high_quality_plot.svg')

'''
#Data Processing and Prepare for Analysis and Boxplot
'''
roledata = survey_data.iloc[:,3].value_counts()
av_role_data = survey_data.iloc[:,4].value_counts()
drivelicencedata = survey_data.iloc[:,5].value_counts()


dve_deploy_data = survey_data.iloc[:,13].value_counts()

safety_data = survey_data.iloc[:,9].value_counts()
efficiency_data = survey_data.iloc[:,11].value_counts()

buydata = survey_data.iloc[:,40].value_counts()

AnticipationCapability = survey_data.iloc[:,14].value_counts()
eHMIComCapability = survey_data.iloc[:,15].value_counts()
Culture = survey_data.iloc[:,16].value_counts()

UserAcceptance = survey_data.iloc[:,17].value_counts()
DrivingStyleAdaptation = survey_data.iloc[:,18].value_counts()
Bi_directional = survey_data.iloc[:,19].value_counts()

Multi_objective  = survey_data.iloc[:,20].value_counts()
Trade_offManagement = survey_data.iloc[:,21].value_counts()
ST_Memory = survey_data.iloc[:,22].value_counts()

BoxPlotData=survey_data.iloc[:,14:23]

BoxPlotData.to_excel("BoxPlot1Data.xlsx") 

mapkv={'1st':3, '2nd':2, '3rd':1, 'NaN':0}

shortterm=survey_data.iloc[:,23:29]
shortterm.iloc[:,0].value_counts()
shortterm.iloc[:,1].value_counts()
shortterm.iloc[:,2].value_counts()
shortterm.iloc[:,3].value_counts()

AnticipationRank = shortterm.iloc[:,0].map(mapkv).sum()
eHMIRank = shortterm.iloc[:,1].map(mapkv).sum()
CultureRank = shortterm.iloc[:,2].map(mapkv).sum()

DrivingStyleAdaptationRank = shortterm.iloc[:,3].map(mapkv).sum()
Multi_objectiveRank = shortterm.iloc[:,4].map(mapkv).sum()
Trade_offManagementRank = shortterm.iloc[:,5].map(mapkv).sum()


longterm=survey_data.iloc[:,29:33]
longterm.iloc[:,0].value_counts()
longterm.iloc[:,1].value_counts()
longterm.iloc[:,2].value_counts()
longterm.iloc[:,3].value_counts()


MathModel=survey_data.iloc[:,34:40]

CultureMath = MathModel.iloc[:,0].value_counts()
DrivingStyleMath = MathModel.iloc[:,1].value_counts()
Bi_directionalMath = MathModel.iloc[:,2].value_counts()
Multi_objectiveMath = MathModel.iloc[:,3].value_counts()
Trade_offManagementMath = MathModel.iloc[:,4].value_counts()
ST_MemoryMath = MathModel.iloc[:,5].value_counts()

MathModel.to_excel("MathModelBoxPlot2Data.xlsx") 

Implement_data = survey_data.iloc[:,13].value_counts()


