% main
close all
clear
clc
PLOT = 0;

MACDOWEL = [
           -0.000000000000000001, -16.096609186310186;
            0.052910052910052796, -16.2483520539999;
            0.10052910052910047, -16.450060644412808;
            0.14550264550264536, -16.601803512102517;
            0.20899470899470907, -16.75446922955229;
            0.25396825396825395, -16.95604598428519;
            0.3121693121693121, -17.208115804461322;
            0.3650793650793651, -17.41008806623425;
            0.41534391534391535, -17.66176237937035;
            0.46825396825396814, -17.913568528186474;
            0.5211640211640209, -18.16537467700259;
            0.5899470899470898, -18.46780572694194;
            0.6666666666666665, -18.96996783209408;
            0.7433862433862433, -19.47212993724622;
            0.8148148148148147, -19.824526709908774;
            0.8703703703703702, -20.076464694404898;
            0.9259259259259258, -20.378236565944206;
            0.9682539682539681, -20.52984759795391;
            1.007936507936508, -20.780994568369987;
            1.0555555555555558, -21.132204819912467;
            1.1005291005291005, -21.433449348731745;
            1.1349206349206349, -21.58466487370142;
            1.17989417989418, -21.98557717660708;
            1.2301587301587302, -22.287085376786376;
            1.2724867724867726, -22.538364182882457;
            1.328042328042328, -22.889969941464962;
            1.3835978835978837, -23.341243474133844;
            1.439153439153439, -23.69284923271635;
            1.4947089947089944, -24.09428887834204;
            1.5291005291005293, -24.44483995148447;
            1.5634920634920637, -24.74555713758372;
            1.6058201058201056, -25.046669830722994;
            1.6507936507936507, -25.397748246585454;
            1.6878306878306875, -25.748431155407904;
            1.7301587301587302, -25.999709961503978;
            1.7777777777777781, -26.35092021304646;
            1.8412698412698414, -26.50358593049624;
            1.8888888888888888, -26.705294520909145;
            1.933862433862434, -26.807203501555666;
            2.00000000000001, -26.86006960923905];
MACDOWEL = [10.^MACDOWEL(:,1),MACDOWEL(:,2)];

OFFSET = 10;
if OFFSET ~= 0
    SETTLEMENT_OFFSET = interp1(MACDOWEL(:,1),MACDOWEL(:,2),OFFSET);
else
    SETTLEMENT_OFFSET = 0;
end

Reference_50kPa = [...
    0.5168408826945408, 29.761904761904816;
    1.0371660859465734, 46.428571428571445;
    1.4982578397212545, 55.95238095238096;
    2.0198896631823455, 67.26190476190482;
    2.4925958188153308, 79.16666666666669;
    2.965592334494773, 89.88095238095241;
    3.4520905923344944, 95.2380952380953;
    3.975900116144019, 97.61904761904765;
    4.463559814169571, 98.21428571428572;
    4.987514518002324, 100;
    5.474303135888503, 104.16666666666669;
    5.951655052264809, 97.02380952380958;
    6.413763066202091, 102.38095238095241;
    6.925232288037168, 105.35714285714289;
    7.40185830429733, 101.1904761904762;
    7.902729384436703, 97.61904761904765;
    8.36556329849013, 100;
    8.939459930313593, 97.02380952380958;
    9.413763066202094, 102.38095238095241;
    9.889663182346112, 101.1904761904762;
];
Reference_100kPa = [...
    0.5124854819976767, 47.61904761904765;
    0.9825783972125435, 70.2380952380953;
    1.4760452961672472, 97.02380952380958;
    1.9718350754936118, 114.28571428571428;
    2.4573170731707314, 123.80952380952385;
    2.9542682926829267, 136.30952380952385;
    3.4403310104529616, 143.45238095238102;
    3.9486062717770034, 159.52380952380958;
    4.445993031358885, 170.2380952380953;
    4.920150987224158, 176.19047619047626;
    5.420296167247388, 175.59523809523813;
    5.931910569105692, 177.97619047619054;
    6.407665505226482, 177.38095238095246;
    6.907665505226482, 177.38095238095246;
    7.4075203252032535, 177.97619047619054;
    8.394889663182347, 179.76190476190484;
    8.884291521486645, 173.21428571428578;
    9.358739837398378, 177.97619047619054;
    9.872386759581882, 172.02380952380958;
];
Reference_200kPa = [...
    0.507694541231126, 67.26190476190482;
    1.0049361207897785, 128.5714285714286;
    1.4568815331010447, 175.59523809523813;
    1.9570267131242733, 225.00000000000009;
    2.4265389082462248, 250.00000000000009;
    2.9194250871080127, 279.16666666666674;
    3.425087108013937, 305.9523809523811;
    3.8774680603948894, 351.19047619047626;
    4.403455284552845, 344.6428571428572;
    4.876451800232288, 355.35714285714295;
    5.3835656213705, 326.19047619047626;
    5.885743321718931, 367.2619047619049;
    6.363240418118466, 359.52380952380963;
    6.849157955865274, 367.2619047619049;
    7.360917537746807, 369.04761904761915;
    7.838850174216028, 359.52380952380963;
    8.33652729384437, 369.04761904761915;
    8.849012775842045, 367.85714285714295;
    9.313588850174217, 363.0952380952382;
    9.824622531939607, 367.85714285714295;
];
%% Box test parameters - reference for the bi Axial properties
% Geometry
Length = 0.7;
Height = 0.3;
Width = 0.3;
% Load input
WidthLoad = 0.25;
Fmin = 3e3;
Fmax = 40e3;
FmaxRef = Fmax;
FminRef = 8000;
% Ballast properties - Stiffness and settelment
TotalSettlement = -(MACDOWEL(end,2)-SETTLEMENT_OFFSET)/1000;
Ks = 15e6;
Kf = 30e6;
Kinc = Kf/Ks;
K0 = 200e6;               % Initial stiffness of lattice (Pa/m)
K0 = K0*Width*WidthLoad;  % Initial stiffness of lattice (N/m)
% Lattice properties - initial
D = 0.0375;
nZ = round(Height/D);
nX = round(Length/D);
nXLoad = round(WidthLoad/D);
Ratio = 1/10;
[Kn,Ks,Kd,Fn,Fs,Fd] = FindStiffnesses(K0,Ratio,nXLoad,nZ);
Fn = 1/nXLoad;
Kn = K0*nZ/nXLoad;
Ks = Kn*Ratio;
Kd = (Kn-Ks)/2;
m = 1800*D^2*Width;
% Non-linear properties: Normal springs:
FmaxRef_n = FmaxRef*Fn;
FminRef_n = FminRef*Fn;
SN = TotalSettlement/nZ;
betha = 0.35;
Kn_1 = Kn*betha;
Kn_2 = Kn-Kn_1;
Kn_3 = Kinc*Kn-Kn_1;
rMax_n = SN-Fmin*Fn/(Kn_1+Kn_3);
G3_n = rMax_n;
F2max_n = FminRef_n * Kn_2 / (Kn_2 + Kn_1);
if F2max_n/Kn_2 - G3_n > 0
    F2max_n = (FminRef_n + Kn_3*G3_n) * Kn_2 / (Kn_1 + Kn_2 + Kn_3);
end
F2red_n = 0.03;
Cn = (Kn_1+Kn_2)*0.001;
% Non-linear properties: Shear springs:
FricCoef = tan(60.27*pi/180);
Cs = Ks*0.001;
Fmax_s = inf;
Fred_s = 0.00;
% Non-linear properties: Diagonal springs:
SD = SN*sqrt(2)/2;
G3_d = inf*SD;
Choesion = 9950*Length*Width;
F2max_d = Choesion/(2*nX+2)/sqrt(2);
Choesion = 9950;
F2max_d = Choesion*Width*D/sqrt(2);
Kd_1 = 0;
Kd_2 = Kd;
Kd_3 = 0;
FmaxRef_d = inf;
F2red_d = 0;
Cd = Kd*0.001;

%% Scale the values to the shear test parameters:
WidthShear = 0.6;
Length = 0.6;
Hd = 0.25;
Hu = 0.30;
Dshear = 0.03;
rMax_n = rMax_n*Dshear/D;
G3_n = G3_n*Dshear/D;
F2max_n = F2max_n/D/Width*Dshear*WidthShear;
F2max_d = F2max_d/D/Width*Dshear*WidthShear;
m = m/D^2*Dshear^2/Width*WidthShear;
Kn_1 = Kn_1/Width*WidthShear;
Kn_2 = Kn_2/Width*WidthShear;
Kn_3 = Kn_3/Width*WidthShear;
Cn = Cn/Width*WidthShear;
Ks = Ks/Width*WidthShear;
Cs = Cs/Width*WidthShear;
Kd_1 = Kd_1/Width*WidthShear;
Kd_2 = Kd_2/Width*WidthShear;
Kd_3 = Kd_3/Width*WidthShear;
Cd = Cd/Width*WidthShear;
Width = WidthShear;
Height = Hu+Hd;
D = Dshear;
%% Create mesh
global as1Springs
[ad2Mass,as1Springs] = CreateLattice(...
                       Length,Height,D,m,...
                       Kn_1,Kn_2,Kn_3,Cn,G3_n,F2max_n,F2red_n,FmaxRef_n,rMax_n,...
                       Ks,Cs,Fmax_s,Fred_s,...
                       Kd_1,Kd_2,Kd_3,Cd,G3_d,F2max_d,F2red_d,FmaxRef_d,0,...
                       FricCoef);
                   
% Apply proper boundary conditions
% 1 - Free all dofs
ad2Mass(:,[4 5]) = 1;
% 2 - Bottom: can only move upwards
BOTTOM = find(ad2Mass(:,2) == min(ad2Mass(:,2)));
ad2Mass = [ad2Mass; 0 min(ad2Mass(:,2)-0.1) 0 0 0];
nNode = size(ad2Mass,1);
for iNode = 1: 1: length(BOTTOM)
    kNode = BOTTOM(iNode);
    Spring = CreateSpring('GapComp', kNode, nNode, [0 1 0 -1], (Kn_1+Kn_2)*100, 0);
    nSpring = length(as1Springs);
    as1Springs{nSpring+1} = Spring;
end
% 3 - bottom half left - can only move right
LEFT_BOTTOM = find((ad2Mass(:,1) == min(ad2Mass(:,1))) .* (ad2Mass(:,2) < -Hu));
for iNode = 1: 1: length(LEFT_BOTTOM)
    kNode = LEFT_BOTTOM(iNode);
    Spring = CreateSpring('GapComp', kNode, nNode, [1 0 -1 0], (Kn_1+Kn_2)*100, 0);
    nSpring = length(as1Springs);
    as1Springs{nSpring+1} = Spring;
end
% 4 - bottom half right - can only move to left
RIGHT_BOTTOM = find((ad2Mass(:,1) == max(ad2Mass(:,1))) .* (ad2Mass(:,2) < -Hu));
for iNode = 1: 1: length(RIGHT_BOTTOM)
    kNode = RIGHT_BOTTOM(iNode);
    Spring = CreateSpring('GapComp', kNode, nNode, [-1 0 1 0], (Kn_1+Kn_2)*100, 0);
    nSpring = length(as1Springs);
    as1Springs{nSpring+1} = Spring;
end
% 5 - top: can only move downwards
TOP = find(ad2Mass(:,2) == max(ad2Mass(:,2)));
ad2Mass = [ad2Mass; 0 max(ad2Mass(:,2)+0.1) 0 0 1];
nNode = size(ad2Mass,1);
for iNode = 1: 1: length(TOP)
    kNode = TOP(iNode);
    Spring = CreateSpring('GapComp', kNode, nNode, [0 -1 0 1], (Kn_1+Kn_2)*100, 0);
    nSpring = length(as1Springs);
    as1Springs{nSpring+1} = Spring;
end
% 6 - top half left - can only move right
LEFT_TOP = find((ad2Mass(:,1) == min(ad2Mass(:,1))) .* (ad2Mass(:,2) >= -Hu));
for iNode = 1: 1: length(LEFT_TOP)
    kNode = LEFT_TOP(iNode);
    Spring = CreateSpring('GapComp', kNode, nNode, [1 0 -1 0], (Kn_1+Kn_2)*100, 0);
    nSpring = length(as1Springs);
    as1Springs{nSpring+1} = Spring;
end
% 7 - top half right - can only move right
RIGHT_TOP = find((ad2Mass(:,1) == max(ad2Mass(:,1))) .* (ad2Mass(:,2) >= -Hu));
for iNode = 1: 1: length(RIGHT_TOP)
    kNode = RIGHT_TOP(iNode);
    Spring = CreateSpring('GapComp', kNode, nNode, [-1 0 1 0], (Kn_1+Kn_2)*100, 0);
    nSpring = length(as1Springs);
    as1Springs{nSpring+1} = Spring;
end
XY = ad2Mass(:,1:2);

%% Solve forced problem
VideoName = 'ShearTest';
COLOR = 'kgr';
Fz = [50 100 200]*1e3*Length*Width;
UxMax = 0.1*Length;

U = [];
F = [];
as1SpringsTemp = as1Springs;
for iF = 1: 1: length(Fz)
    as1Springs = as1SpringsTemp;
    [Fx,ad2U] = TestShearQuasiStatic(ad2Mass, Fz(iF), UxMax, PLOT, VideoName);
    %% Plot the averaged response under the load
    U = [U ad2U(:,end-3)];
    F = [F Fx(:)];
end

%% Plot
close all
figure(1);
for iF = 1: 1: length(Fz)
    kColor = mod(iF-1,length(COLOR))+1;
    plot(U(:,iF)/Length, F(:,iF)/Length/Width/1e3, COLOR(kColor));hold on;
    drawnow;
end
plot(Reference_50kPa(:,1)/100, Reference_50kPa(:,2), 'ko');
plot(Reference_100kPa(:,1)/100, Reference_100kPa(:,2), 'go');
plot(Reference_200kPa(:,1)/100, Reference_200kPa(:,2), 'ro');
grid on;
xlabel('Shear strain');
ylabel('Shear stress (kPa)');
title('b)');
legend('50 kPa model', '100 kPa model', '200 kPa model',...
       '50 kPa test', '100 kPa test', '200 kPa test');
figure(2);
Fact = 1;
XY = ad2Mass(:,1:2);
plot(XY(1:end-2,1)+ad2U(end,1:2:end-4)'*Fact,XY(1:end-2,2)+ad2U(end,2:2:end-4)'*Fact,'ob'); hold on;
plot(min(XY(1:end-2,1))*[1 1]+ad2U(end,end-1), [-Hu 0], 'k', 'LineWidth', 2);
plot(max(XY(1:end-2,1))*[1 1]+ad2U(end,end-1), [-Hu 0], 'k', 'LineWidth', 2);
plot([min(XY(1:end-2,1))+ad2U(end,end-1) max(XY(1:end-2,1))+ad2U(end,end-1)], [0 0], 'k', 'LineWidth', 2);
plot(min(XY(1:end-2,1))*[1 1]+ad2U(end,end-3), [-Hu-Hd -Hu], 'k', 'LineWidth', 2);
plot(max(XY(1:end-2,1))*[1 1]+ad2U(end,end-3), [-Hu-Hd -Hu], 'k', 'LineWidth', 2);
plot([min(XY(1:end-2,1))+ad2U(end,end-3) max(XY(1:end-2,1))+ad2U(end,end-3)], [-Hu-Hd -Hu-Hd], 'k', 'LineWidth', 2);
xlabel('{\itx} (m)');
ylabel('{\itz} (m)');
title('a)');
axis equal