% main
close all
clear
clc
PLOT = 1;

MACDOWEL = [
           -0.000000000000000001, -16.096609186310186;
            0.052910052910052796, -16.2483520539999;
            0.10052910052910047, -16.450060644412808;
            0.14550264550264536, -16.601803512102517;
            0.20899470899470907, -16.75446922955229;
            0.25396825396825395, -16.95604598428519;
            0.3121693121693121, -17.208115804461322;
            0.3650793650793651, -17.41008806623425;
            0.41534391534391535, -17.66176237937035;
            0.46825396825396814, -17.913568528186474;
            0.5211640211640209, -18.16537467700259;
            0.5899470899470898, -18.46780572694194;
            0.6666666666666665, -18.96996783209408;
            0.7433862433862433, -19.47212993724622;
            0.8148148148148147, -19.824526709908774;
            0.8703703703703702, -20.076464694404898;
            0.9259259259259258, -20.378236565944206;
            0.9682539682539681, -20.52984759795391;
            1.007936507936508, -20.780994568369987;
            1.0555555555555558, -21.132204819912467;
            1.1005291005291005, -21.433449348731745;
            1.1349206349206349, -21.58466487370142;
            1.17989417989418, -21.98557717660708;
            1.2301587301587302, -22.287085376786376;
            1.2724867724867726, -22.538364182882457;
            1.328042328042328, -22.889969941464962;
            1.3835978835978837, -23.341243474133844;
            1.439153439153439, -23.69284923271635;
            1.4947089947089944, -24.09428887834204;
            1.5291005291005293, -24.44483995148447;
            1.5634920634920637, -24.74555713758372;
            1.6058201058201056, -25.046669830722994;
            1.6507936507936507, -25.397748246585454;
            1.6878306878306875, -25.748431155407904;
            1.7301587301587302, -25.999709961503978;
            1.7777777777777781, -26.35092021304646;
            1.8412698412698414, -26.50358593049624;
            1.8888888888888888, -26.705294520909145;
            1.933862433862434, -26.807203501555666;
            2.00000000000001, -26.86006960923905];
MACDOWEL = [10.^MACDOWEL(:,1),MACDOWEL(:,2)];

OFFSET = 10;
if OFFSET ~= 0
    SETTLEMENT_OFFSET = interp1(MACDOWEL(:,1),MACDOWEL(:,2),OFFSET);
else
    SETTLEMENT_OFFSET = 0;
end

%% Box test parameters - reference for the bi Axial properties
% Geometry
Length = 0.7;
Height = 0.3;
Width = 0.3;
% Load input
WidthLoad = 0.25;
Fmin = 3e3;
Fmax = 40e3;
FmaxRef = Fmax;
FminRef = 8000;
% Ballast properties - Stiffness and settelment
TotalSettlement = -(MACDOWEL(end,2)-SETTLEMENT_OFFSET)/1000;
Ks = 15e6;
Kf = 30e6;
Kinc = Kf/Ks;
K0 = 200e6;                % Initial stiffness of lattice (Pa/m)
K0 = K0*Width*WidthLoad;   % Initial stiffness of lattice (N/m)
% Lattice properties - initial
D = 0.0375;
nZ = round(Height/D);
nX = round(Length/D);
nXLoad = round(WidthLoad/D);
Ratio = 1/10;
[Kn,Ks,Kd,Fn,Fs,Fd] = FindStiffnesses(K0,Ratio,nXLoad,nZ);
Fn = 1/nXLoad;
Kn = K0*nZ/nXLoad;
Ks = Kn*Ratio;
Kd = (Kn-Ks)/2;
m = 1800*D^2*Width;
% Non-linear properties: Normal springs:
FmaxRef_n = FmaxRef*Fn;
FminRef_n = FminRef*Fn;
SN = TotalSettlement/nZ;
betha = 0.35;
Kn_1 = Kn*betha;
Kn_2 = Kn-Kn_1;
Kn_3 = Kinc*Kn-Kn_1;
rMax_n = SN-Fmin*Fn/(Kn_1+Kn_3);
G3_n = rMax_n;
F2max_n = FminRef_n * Kn_2 / (Kn_2 + Kn_1);
if F2max_n/Kn_2 - G3_n > 0
    F2max_n = (FminRef_n + Kn_3*G3_n) * Kn_2 / (Kn_1 + Kn_2 + Kn_3);
end
F2red_n = 0.03;
Cn = (Kn_1+Kn_2)*0.001;
% Non-linear properties: Shear springs:
FricCoef = tan(60.27*pi/180);
% FricCoef = 0;
Cs = Ks*0.001;
Fmax_s = inf;
Fred_s = 0.00;
% Non-linear properties: Diagonal springs:
FmaxRef_d = FmaxRef*Fd;
FminRef_d = FminRef*Fd;
G3_d = inf;
Kd_1 = 0;
Kd_2 = Kd;
Kd_3 = 0;
Choesion = 10e3*Length*Width;
F2max_d = Choesion/(2*nX+2)/sqrt(2);
Choesion = 9950;
F2max_d = Choesion*Width*D/sqrt(2);
% F2max_d = inf;
F2red_d = 0;
Cd = Kd*0.001;


%% Create mesh
global as1Springs
[ad2Mass,as1Springs] = CreateLattice(...
                       Length,Height,D,m,...
                       Kn_1,Kn_2,Kn_3,Cn,G3_n,F2max_n,F2red_n,FmaxRef_n,rMax_n,...
                       Ks,Cs,Fmax_s,Fred_s,...
                       Kd_1,Kd_2,Kd_3,Cd,G3_d,F2max_d,F2red_d,FmaxRef_d,0,...
                       FricCoef);
                   
% Apply proper boundary conditions
% 1 - Free all dofs
ad2Mass(:,[4 5]) = 1;
% 2 - Bottom: can only move upwards
BOTTOM = find(ad2Mass(:,2) == min(ad2Mass(:,2)));
% ad2Mass = [ad2Mass; 0 min(ad2Mass(:,2)-0.1) 0 0 0];
nNode = size(ad2Mass,1);
for iNode = 1: 1: length(BOTTOM)
    kNode = BOTTOM(iNode);
%    Spring = CreateSpring('GapComp', kNode, nNode, [0 1 0 -1], (Kn_1+Kn_2)*100, 0);
%    nSpring = length(as1Springs);
%    as1Springs{nSpring+1} = Spring;
    ad2Mass(kNode,5) = 0;
end
% 3 - left - can only move right
LEFT = find((ad2Mass(:,1) == min(ad2Mass(:,1))));
for iNode = 1: 1: length(LEFT)
    kNode = LEFT(iNode);
%    Spring = CreateSpring('GapComp', kNode, nNode, [1 0 -1 0], (Kn_1+Kn_2)*100, 0);
%    nSpring = length(as1Springs);
%    as1Springs{nSpring+1} = Spring;
    ad2Mass(kNode,4) = 0;
end
% 4 - right - can only move to left
RIGHT = find((ad2Mass(:,1) == max(ad2Mass(:,1))));
for iNode = 1: 1: length(RIGHT)
    kNode = RIGHT(iNode);
%    Spring = CreateSpring('GapComp', kNode, nNode, [-1 0 1 0], (Kn_1+Kn_2)*100, 0);
%    nSpring = length(as1Springs);
%    as1Springs{nSpring+1} = Spring;
    ad2Mass(kNode,4) = 0;
end
% 5 - top - strip load: can only move downwards
TOP = find((ad2Mass(:,2) == max(ad2Mass(:,2))) .* (abs(ad2Mass(:,1)) <= WidthLoad/2));
ad2Mass = [ad2Mass; 0 max(ad2Mass(:,2)+0.1) 0 0 1];
nNode = size(ad2Mass,1);
for iNode = 1: 1: length(TOP)
    kNode = TOP(iNode);
    Spring = CreateSpring('GapComp', kNode, nNode, [0 -1 0 1], (Kn_1+Kn_2)*100, 0);
    nSpring = length(as1Springs);
    as1Springs{nSpring+1} = Spring;
end
XY = ad2Mass(:,1:2);

%% Solve forced problem
VideoName = 'BoxTestQuasiStatic';
COLOR = 'brkgcm';
F_Min_Max_N = [Fmin Fmax 100];

[Fz,Uz,Settlement,ad2U] = TestBoxQuasiStatic(ad2Mass, F_Min_Max_N, PLOT, VideoName);
%% Plot the averaged response under the load
close all
figure(1)
plot((1:1:length(Settlement)), -Settlement, 'b');hold on;
plot(MACDOWEL(:,1)-OFFSET, MACDOWEL(:,2)/1000-SETTLEMENT_OFFSET/1000, 'r');hold on;
xlim([OFFSET+1 OFFSET + length(Settlement)]);
xlabel('Cycle number');
ylabel('Settlement (m)');
title('b)');
figure(2)
plot(Uz,Fz)
xlabel('Displacement (m)');
ylabel('Force (N)');
figure(3);
Fact = 5;
plot(XY(1:end-1,1)+ad2U(end,1:2:end-2)'*Fact,XY(1:end-1,2)+ad2U(end,2:2:end-2)'*Fact,'ob'); hold on;
plot(min(XY(1:end-1,1))*[1 1], [min(XY(1:end-1,2)) max(XY(1:end-1,2))], 'k', 'LineWidth', 2);
plot(max(XY(1:end-1,1))*[1 1], [min(XY(1:end-1,2)) max(XY(1:end-1,2))], 'k', 'LineWidth', 2);
plot([min(XY(1:end-1:end-1,1)) max(XY(1:end-1,1))], min(XY(1:end-1,2))*[1 1], 'k', 'LineWidth', 2);
plot(WidthLoad/2*[-1 1 1 -1 -1],mean(XY(TOP,2)+ad2U(end,2*TOP)'*Fact)*[1 1 1 1 1] + 0.05 * [0 0 1 1 0], 'k', 'LineWidth', 2)
xlabel('{\itx} (m)');
ylabel('{\itz} (m)');
title('a)');
axis equal