% main
close all
clear
clc
PLOT = 0;

%% Box geometry and confinement pressure
Length = 0.7;
Height = 0.3;
Width = 1.0;
%% Load input
WidthLoad = 0.25;
Fmin = 3e3;
Fmax = 40e3;
Freq = 4;
Ncyc = 100;
Tload0 = 1;
ConfinementPressure = 0;

%% Ballast properties
TotalSettlement = 0.0275;
K0 = 200e6;               % Initial stiffness of lattice (Pa/m)
K0 = K0*Width*WidthLoad;  % Initial stiffness of lattice (N/m)
Kinc = 1.5;               % Total tiffness increase: Kf = K0*(1+Kinc)

%% Lattice properties - initial
D = 0.0375;
nZ = round(Height/D);
nX = round(Length/D);
nXLoad = round(WidthLoad/D);
Ratio = 1/8;
[Kn,Ks,Kd,Fn,Fs,Fd] = FindStiffnesses(K0,Ratio,nXLoad,nZ);
m = 1800*D^2*Width;

%% Non-linear properties
% Normal springs:
% FmaxRef_n = Fmax/K0*Kn/nZ;
% FminRef_n = Fmin/K0*Kn/nZ;
FmaxRef_n = Fmax*Fn;
FminRef_n = Fmin*Fn;
SN = TotalSettlement/nZ;
FricCoef = 1.5;

betha = 0.5;
Kn_1 = Kn*betha;
Kn_2 = Kn-Kn_1;
Kn_3 = Kinc*Kn-Kn_1;
rMax_n = SN;
G3_n = rMax_n;
F2max_n = FminRef_n * Kn_2 / (Kn_2 + Kn_1);
if F2max_n/Kn_2 - G3_n > 0
    F2max_n = (FminRef_n + Kn_3*G3_n) * Kn_2 / (Kn_1 + Kn_2 + Kn_3);
end
F2red_n = 0.05;
Cn = (Kn_1+Kn_2)*0.001;

% Shear springs:
FmaxRef_s = Fmax*Fs;
FminRef_s = Fmin*Fs;
beta = 0.25;
Cs = Ks*0.001;
Fmax_s = (beta*FmaxRef_s+(1-beta)*FminRef_s);
Fred_s = 0.00;

% Diagonal springs:
FmaxRef_d = Fmax*Fd;
FminRef_d = Fmin*Fd;

SD = SN*sqrt(2)/2;
betha = 0;
Choesion = 10e3*Length*Width;
Kd_1 = 0;
Kd_2 = Kd;
Kd_3 = 0;
G3_d = 0;
F2max_d = Choesion/nX/sqrt(2);
F2red_d = 0;
Cd = Kd*0.001;

%% Create mesh - only normalsprings are non-linear
global as1Springs
[ad2Mass,as1Springs] = CreateLattice(...
                       Length,Height,D,m,...
                       Kn_1,Kn_2,Kn_3,Cn,G3_n,F2max_n,F2red_n,FmaxRef_n,rMax_n,...
                       Ks,Cs,Fmax_s,Fred_s,...
                       Kd_1,Kd_2,Kd_3,Cd,G3_d,F2max_d,F2red_d,FmaxRef_d,0,...
                       FricCoef);
% ad2Mass(:,4) = 0;
XY = ad2Mass(:,1:2);
%% Solve forced problem
MODAL = 0;
PLOT = 0;
VideoName = [];
[ad1T, ad2U] = ...
        TestBoxImplicit(ad2Mass, WidthLoad, Fmin, Fmax, Freq, Ncyc, Tload0, 1e-2, MODAL, PLOT, VideoName);

if PLOT > 0
    FileName = 'BoxTest.mp4';
    %% Create the object
    FPS = round(1/Freq/(ad1T(2)-ad1T(1))); % Frames per second
    writerObj = VideoWriter(FileName,'MPEG-4');
    writerObj.Quality = 100;
    writerObj.FrameRate = FPS; % frames per second
    open(writerObj); 
    figure;
    XY = ad2Mass(:,1:2);
    ad1T1 = ad1T(ad1T>=0);
    ad1F = (Fmin+Fmax)/2 + (Fmin-Fmax)/2*cos(2*pi*Freq*ad1T1);
    for iT = 1: 1: length(ad1T1)
        kIndex = find(ad1T==ad1T1(iT));
        plot(XY(:,1)+ad2U(kIndex,1:2:end)',XY(:,2)+ad2U(kIndex,2:2:end)', 'ob');
        xlim([min(XY(:,1))-0.1 max(XY(:,1))+0.1]);
        ylim([min(XY(:,2))-0.1 max(XY(:,2))+0.1]);
        title(['T = ' num2str(ad1T1(iT)) '; Force = ' num2str(ad1F(iT))]);
        writeVideo(writerObj,getframe(gcf));
    end
    close(writerObj);
end
%% Plot the averaged response under the load
figure;
Middle = find((ad2Mass(:,2) == 0) .* (abs(ad2Mass(:,1))<=WidthLoad/2));
ad1U = mean(ad2U(:,2*Middle),2);
% Time vs displacement
subplot(2,2,1); plot(ad1T,ad1U); xlabel('Time'), ylabel('Displacement');
% Cycle vs Setlement
k0 = find(ad1T==0);
S0 = ad1U(k0);
ad1U1 = ad1U(find(ad1T>=0));
ad1T1 = ad1T(find(ad1T>=0));
ad1F = (Fmin+Fmax)/2 + (Fmin-Fmax)/2*cos(2*pi*Freq*ad1T1);
[ad1Peaks,ai1IndexP] = findpeaks(-ad1F);
ad1Peaks = ad1U1(ai1IndexP);
subplot(2,2,2); plot(1:1:length(ad1Peaks), S0-ad1Peaks);
xlabel('Cycle'), ylabel('Settlement'); % ylim([0 0.03]);
% Cycle vs Loading Stiffness
[ad1AntiPeaks,ai1IndexAP] = findpeaks(ad1F);
ad1AntiPeaks = ad1U1(ai1IndexAP);
StiffnessInc = (Fmax-Fmin)./([S0;ad1Peaks(1:end)]-ad1AntiPeaks);
subplot(2,2,3); plot(1:1:length(StiffnessInc), StiffnessInc);
xlabel('Cycle'), ylabel('Loading stiffness');
% Cycle vs Unloading Stiffness
StiffnessInc = (Fmax-Fmin)./(ad1Peaks-ad1AntiPeaks(1:end-1));
subplot(2,2,4); plot(1:1:length(StiffnessInc), StiffnessInc);
xlabel('Cycle'), ylabel('Unloading stiffness');

figure;
subplot(1,2,1), plot(-ad1U1,ad1F);
subplot(1,2,2), semilogx(1:1:length(ad1Peaks), -(S0-ad1Peaks));
figure; semilogx(1:1:length(ad1Peaks), -(S0-ad1Peaks)*1000); ylim([-30 0]);
xlabel('Cycle'), ylabel('Settlement');