% main
close all
clear
clc
PLOT = 0;

%% Box test parameters - reference for the bi Axial properties
% Geometry
Length = 0.7;
Height = 0.3;
Width = 0.3;
% Load input
WidthLoad = 0.25;
Fmin = 3e3;
Fmax = 40e3;
% Ballast properties - Stiffness and settelment
TotalSettlement = 0.0275;
K0 = 200e6;               % Initial stiffness of lattice (Pa/m)
K0 = K0*Width*WidthLoad;  % Initial stiffness of lattice (N/m)
Kinc = 1.5;               % Total tiffness increase: Kf = K0*(1+Kinc)
% Lattice properties - initial
D = 0.0375;
nZ = round(Height/D);
nX = round(Length/D);
nXLoad = round(WidthLoad/D);
Ratio = 1/8;
[Kn,Ks,Kd,Fn,Fs,Fd] = FindStiffnesses(K0,Ratio,nXLoad,nZ);
m = 1800*D^2*Width;
% Non-linear properties: Normal springs:
FmaxRef_n = Fmax*Fn;
FminRef_n = Fmin*Fn;
SN = TotalSettlement/nZ;
rMax_n = SN;

FricCoef = 1.0;
K1 = 0.5*Kn;
K2 = Kn-K1;
K3 = Kinc*Kn-K1;
G3_n = 1.0*SN;
F2max_n = FminRef_n * K2 / (K2 + K1);
if F2max_n/K2 - G3_n > 0
    F2max_n = (FminRef_n + K3*G3_n) * K2 / (K1 + K2 + K3);
end
F2red_n = 0.01;
Kn_1 = K1;
Kn_2 = K2;
Kn_3 = K3;
Cn = (Kn_1+Kn_2)*0.001;
% Non-linear properties: Shear springs:
FmaxRef_s = Fmax*Fs;
FminRef_s = Fmin*Fs;
beta = 0.25;
Cs = Ks*0.001;
Fmax_s = (beta*FmaxRef_s+(1-beta)*FminRef_s)*inf;
Fred_s = 0.00;
% Non-linear properties: Diagonal springs:
FmaxRef_d = Fmax*Fd;
FminRef_d = Fmin*Fd;
SD = SN*sqrt(2)/2;
G3_d = inf*SD;
Kd_1 = 0;
Kd_2 = Kd;
Kd_3 = 0;
F2max_d = FmaxRef_d;
F2red_d = 0;
Cd = Kd*0.001;

%% Properties for Biaxial test
Dbi = 0.02;
Length = 10*Dbi;
Height = 10*Dbi;
m = m*Dbi^2/D^2;
Kn_1 = Kn_1*D/Dbi;
Kn_2 = Kn_2*D/Dbi;
Kn_3 = Kn_3*D/Dbi;
Cn = Cn*D/Dbi;
F2max_n = F2max_n*Dbi/D;
rMax_n = rMax_n*Dbi/D;
G3_n = G3_n*Dbi/D;
Ks = Ks*D/Dbi;
Cs = Cs*D/Dbi;
Fmax_s = Fmax_s*Dbi/D;
Kd_1 = Kd_1*D/Dbi;
Kd_2 = Kd_2*D/Dbi;
Kd_3 = Kd_3*D/Dbi;
Cd = Cd*D/Dbi;
F2max_d = F2max_d*Dbi/D;
D = Dbi;

%% Forcing
OA = 1; OB = 2; OC = 3; OD = 4; AB = 5; AC = 6; AD = 7; BC = 8; BD = 9; CD = 10;
%            ConfStress(Pa) DevStressMin(Pa) DevStressMax(Pa) nCycle Freq (Hz)
StressPath1 = [       21e3                0            21e3    1000        1;
                      21e3                0            43e3    1000        1;
                      21e3                0            65e3    1000        1;
                      21e3                0            86e3    1000        1;
                      21e3             21e3            43e3    1000        1;
                      21e3             21e3            65e3    1000        1;
                      21e3             21e3            86e3    1000        1;
                      21e3             43e3            65e3    1000        1;
                      21e3             43e3            86e3    1000        1;
                      21e3             65e3            86e3    1000        1;
                      ];
StressPath2 = [       41e3                0            41e3    1000        1;
                      41e3                0            83e3    1000        1;
                      41e3                0           124e3    1000        1;
                      41e3                0           165e3    1000        1;
                      41e3             41e3            83e3    1000        1;
                      41e3             41e3           124e3    1000        1;
                      41e3             41e3           165e3    1000        1;
                      41e3             83e3           124e3    1000        1;
                      41e3             83e3           165e3    1000        1;
                      41e3            124e3           165e3    1000        1;
                      ];
StressPath3 = [       83e3                0            41e3    1000        1;
                      83e3                0            83e3    1000        1;
                      83e3                0           124e3    1000        1;
                      83e3                0           165e3    1000        1;
                      83e3             41e3            83e3    1000        1;
                      83e3             41e3           124e3    1000        1;
                      83e3             41e3           165e3    1000        1;
                      83e3             83e3           124e3    1000        1;
                      83e3             83e3           165e3    1000        1;
                      83e3            124e3           165e3    1000        1;
                      ];

%% Create mesh - only normalsprings are non-linear
global as1Springs
[ad2Mass,as1Springs] = CreateLattice(...
                       Length,Height,D,m,...
                       Kn_1,Kn_2,Kn_3,Cn,G3_n,F2max_n,F2red_n,FmaxRef_n,rMax_n,...
                       Ks,Cs,Fmax_s,Fred_s,...
                       Kd_1,Kd_2,Kd_3,Cd,G3_d,F2max_d,F2red_d,FmaxRef_d,0,...
                       FricCoef);
% Apply proper boundary conditions
% 1 - Free all dofs
ad2Mass(:,[4 5]) = 1;
% 2 - Bottom: precribe vertical direction - half of the sample, symmetric boudnary condition
BOTTOM = find(ad2Mass(:,2) == min(ad2Mass(:,2)));
ad2Mass(BOTTOM,5) = 0;
% 3 - Left: prescrive horizontal direction - half of the sample, symmetric boudnary condition
LEFT = find(ad2Mass(:,1) == min(ad2Mass(:,1)));
ad2Mass(LEFT,4) = 0;
% 4 - TOP: applie load
TOP = find(ad2Mass(:,2) == max(ad2Mass(:,2)));
% 5 - RIGHT - applied load
RIGHT = find(ad2Mass(:,1) == max(ad2Mass(:,1)));
XY = ad2Mass(:,1:2);

%% Solve forced problem
PLOT = 10;
T0 = 1;
VideoName = [];
PATH = [OD OA OB OC];
StressPath = StressPath1;
% StressPath(:,4) = 100;
[ad1T, ad2U, ad2C, ad2A, Sdev] = ...
        TestBiAxialImplicit(ad2Mass, TOP, RIGHT, StressPath(PATH,:), T0, 1e-1, PLOT, VideoName);

%% Plot the averaged response under the load
figure;
ad1U = mean(-ad2U(:,2*TOP),2);
% Cycle vs Setlement
lZ = Height;
ad1E = ad1U(find(ad1T>=0))/lZ;
ad1S = Sdev(find(ad1T>=0));
ad1T1 = ad1T(find(ad1T>=0));
subplot(2,3,1), plot(ad1T1, ad1E);
subplot(2,3,2), plot(ad1T1, ad1S);
subplot(2,3,3), plot(ad1E, ad1S);
E0 = ad1E(1);
[ad1Peaks,ai1IndexP] = findpeaks(-ad1S);
hold on;
plot(ad1E(ai1IndexP), ad1S(ai1IndexP), 'ro');
hold off;
ad1Peaks = ad1E(ai1IndexP);
subplot(2,1,2); plot(1:1:length(ad1Peaks), ad1Peaks-E0);
xlabel('Cycle'), ylabel('Vertical strain');
